/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.PasswordHelper;
import org.pgpainless.sop.VerificationHelper;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/sop/DecryptImpl;", "Lsop/operation/Decrypt;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "consumerOptions", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "ciphertext", "Lsop/ReadyWithResult;", "Lsop/DecryptionResult;", "Ljava/io/InputStream;", "mapSessionKey", "Lorg/pgpainless/util/SessionKey;", "sessionKey", "Lsop/SessionKey;", "verifyNotAfter", "timestamp", "Ljava/util/Date;", "verifyNotBefore", "verifyWithCert", "cert", "withKey", "key", "withKeyPassword", "password", "", "withPassword", "", "withSessionKey", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nDecryptImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptImpl.kt\norg/pgpainless/sop/DecryptImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1855#2,2:115\n*S KotlinDebug\n*F\n+ 1 DecryptImpl.kt\norg/pgpainless/sop/DecryptImpl\n*L\n92#1:115,2\n*E\n"})
public final class DecryptImpl
implements Decrypt {
    @NotNull
    private final PGPainless api;
    @NotNull
    private final ConsumerOptions consumerOptions;
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector;

    public DecryptImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.consumerOptions = ConsumerOptions.Companion.get(this.api);
        this.protector = new MatchMakingSecretKeyRingProtector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ReadyWithResult<DecryptionResult> ciphertext(@NotNull InputStream ciphertext2) {
        DecryptionStream decryptionStream;
        Intrinsics.checkNotNullParameter((Object)ciphertext2, (String)"ciphertext");
        if (this.consumerOptions.getDecryptionKeys().isEmpty() && this.consumerOptions.getDecryptionPassphrases().isEmpty() && this.consumerOptions.getSessionKey() == null) {
            throw new SOPGPException.MissingArg("Missing decryption key, passphrase or session key.");
        }
        try {
            decryptionStream = this.api.processMessage().onInputStream(ciphertext2).withOptions(this.consumerOptions);
        }
        catch (MissingDecryptionMethodException e) {
            throw new SOPGPException.CannotDecrypt("No usable decryption key or password provided.", (Throwable)e);
        }
        catch (WrongPassphraseException e) {
            throw new SOPGPException.KeyIsProtected();
        }
        catch (MalformedOpenPgpMessageException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        finally {
            this.protector.clear();
        }
        DecryptionStream decryptionStream2 = decryptionStream;
        return (ReadyWithResult)new ReadyWithResult<DecryptionResult>(decryptionStream2){
            final /* synthetic */ DecryptionStream $decryptionStream;
            {
                this.$decryptionStream = $decryptionStream;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public DecryptionResult writeTo(@NotNull OutputStream outputStream) {
                SessionKey sessionKey;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                Streams.pipeAll((InputStream)((InputStream)this.$decryptionStream), (OutputStream)outputStream);
                this.$decryptionStream.close();
                MessageMetadata metadata = this.$decryptionStream.getMetadata();
                if (!metadata.isEncrypted()) {
                    throw new SOPGPException.BadData("Data is not encrypted.");
                }
                Iterable $this$map$iv = metadata.getVerifiedInlineSignatures();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SignatureVerification signatureVerification = (SignatureVerification)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(VerificationHelper.Companion.mapVerification((SignatureVerification)it));
                }
                List verificationList = (List)destination$iv$iv;
                org.pgpainless.util.SessionKey sessionKey2 = metadata.getSessionKey();
                if (sessionKey2 != null) {
                    org.pgpainless.util.SessionKey it = sessionKey2;
                    boolean bl = false;
                    sessionKey = new SessionKey((byte)it.getAlgorithm().getAlgorithmId(), it.getKey());
                } else {
                    sessionKey = null;
                }
                SessionKey sessionKey3 = sessionKey;
                return new DecryptionResult(sessionKey3, verificationList);
            }
        };
    }

    @NotNull
    public Decrypt verifyNotAfter(@NotNull Date timestamp) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DecryptImpl $this$verifyNotAfter_u24lambda_u240 = decryptImpl = this;
        boolean bl = false;
        $this$verifyNotAfter_u24lambda_u240.consumerOptions.verifyNotAfter(timestamp);
        return decryptImpl;
    }

    @NotNull
    public Decrypt verifyNotBefore(@NotNull Date timestamp) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DecryptImpl $this$verifyNotBefore_u24lambda_u241 = decryptImpl = this;
        boolean bl = false;
        $this$verifyNotBefore_u24lambda_u241.consumerOptions.verifyNotBefore(timestamp);
        return decryptImpl;
    }

    @NotNull
    public Decrypt verifyWithCert(@NotNull InputStream cert) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        DecryptImpl $this$verifyWithCert_u24lambda_u242 = decryptImpl = this;
        boolean bl = false;
        $this$verifyWithCert_u24lambda_u242.consumerOptions.addVerificationCerts((Collection)new KeyReader($this$verifyWithCert_u24lambda_u242.api).readPublicKeys(cert, true));
        return decryptImpl;
    }

    @NotNull
    public Decrypt withKey(@NotNull InputStream key2) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        DecryptImpl $this$withKey_u24lambda_u244 = decryptImpl = this;
        boolean bl = false;
        Iterable $this$forEach$iv = new KeyReader($this$withKey_u24lambda_u244.api).readSecretKeys(key2, true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl2 = false;
            $this$withKey_u24lambda_u244.protector.addSecretKey(it);
            $this$withKey_u24lambda_u244.consumerOptions.addDecryptionKey(it, (SecretKeyRingProtector)$this$withKey_u24lambda_u244.protector);
        }
        return decryptImpl;
    }

    @NotNull
    public Decrypt withKeyPassword(@NotNull byte[] password) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DecryptImpl $this$withKeyPassword_u24lambda_u245 = decryptImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addPassphrasePlusRemoveWhitespace(password, $this$withKeyPassword_u24lambda_u245.protector);
        return decryptImpl;
    }

    @NotNull
    public Decrypt withPassword(@NotNull String password) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DecryptImpl $this$withPassword_u24lambda_u246 = decryptImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addMessagePassphrasePlusRemoveWhitespace(password, $this$withPassword_u24lambda_u246.consumerOptions);
        return decryptImpl;
    }

    @NotNull
    public Decrypt withSessionKey(@NotNull SessionKey sessionKey) {
        DecryptImpl decryptImpl;
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        DecryptImpl $this$withSessionKey_u24lambda_u247 = decryptImpl = this;
        boolean bl = false;
        $this$withSessionKey_u24lambda_u247.consumerOptions.setSessionKey($this$withSessionKey_u24lambda_u247.mapSessionKey(sessionKey));
        return decryptImpl;
    }

    private final org.pgpainless.util.SessionKey mapSessionKey(SessionKey sessionKey) {
        return new org.pgpainless.util.SessionKey(SymmetricKeyAlgorithm.Companion.requireFromId((int)sessionKey.getAlgorithm()), sessionKey.getKey());
    }
}

