/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.OpenPGPSignatureSet;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.PasswordHelper;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import sop.MicAlg;
import sop.ReadyWithResult;
import sop.SigningResult;
import sop.enums.SignAs;
import sop.exception.SOPGPException;
import sop.operation.DetachedSign;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\u0001H\u0016J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/pgpainless/sop/DetachedSignImpl;", "Lsop/operation/DetachedSign;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "armor", "", "mode", "Lsop/enums/SignAs;", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "signingKeys", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "signingOptions", "Lorg/pgpainless/encryption_signing/SigningOptions;", "data", "Lsop/ReadyWithResult;", "Lsop/SigningResult;", "Ljava/io/InputStream;", "key", "micAlgFromSignatures", "Lsop/MicAlg;", "signatures", "", "Lorg/bouncycastle/openpgp/PGPSignature;", "modeToSigType", "Lorg/pgpainless/algorithm/DocumentSignatureType;", "noArmor", "withKeyPassword", "password", "", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nDetachedSignImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetachedSignImpl.kt\norg/pgpainless/sop/DetachedSignImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1855#2,2:128\n1855#2,2:130\n1603#2,9:133\n1855#2:142\n1856#2:144\n1612#2:145\n1#3:132\n1#3:143\n*S KotlinDebug\n*F\n+ 1 DetachedSignImpl.kt\norg/pgpainless/sop/DetachedSignImpl\n*L\n40#1:128,2\n93#1:130,2\n121#1:133,9\n121#1:142\n121#1:144\n121#1:145\n121#1:143\n*E\n"})
public final class DetachedSignImpl
implements DetachedSign {
    @NotNull
    private final PGPainless api;
    @NotNull
    private final SigningOptions signingOptions;
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector;
    @NotNull
    private final List<OpenPGPKey> signingKeys;
    private boolean armor;
    @NotNull
    private SignAs mode;

    public DetachedSignImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.signingOptions = SigningOptions.Companion.get(this.api);
        this.protector = new MatchMakingSecretKeyRingProtector();
        this.signingKeys = new ArrayList();
        this.armor = true;
        this.mode = SignAs.binary;
    }

    @NotNull
    public ReadyWithResult<SigningResult> data(@NotNull InputStream data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$forEach$iv = this.signingKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl = false;
            try {
                this.signingOptions.addDetachedSignature((SecretKeyRingProtector)this.protector, it, this.modeToSigType(this.mode));
            }
            catch (KeyException.UnacceptableSigningKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + it.getKeyIdentifier() + " cannot sign.", (Throwable)e);
            }
            catch (KeyException.MissingSecretKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + it.getKeyIdentifier() + " cannot sign. Missing secret key.", (Throwable)e);
            }
            catch (PGPException e) {
                throw new SOPGPException.KeyIsProtected("Key " + it.getKeyIdentifier() + " cannot be unlocked.", (Throwable)e);
            }
        }
        try {
            EncryptionStream signingStream = this.api.generateMessage().discardOutput().withOptions(ProducerOptions.Companion.sign(this.signingOptions).setAsciiArmor(this.armor).overrideCompressionAlgorithm(CompressionAlgorithm.UNCOMPRESSED));
            return (ReadyWithResult)new ReadyWithResult<SigningResult>(signingStream, data2, this){
                final /* synthetic */ EncryptionStream $signingStream;
                final /* synthetic */ InputStream $data;
                final /* synthetic */ DetachedSignImpl this$0;
                {
                    this.$signingStream = $signingStream;
                    this.$data = $data;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public SigningResult writeTo(@NotNull OutputStream outputStream) {
                    Collection<PGPSignature> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    if (!(!this.$signingStream.isClosed())) {
                        boolean $i$a$-check-DetachedSignImpl$data$2$writeTo$22 = false;
                        String $i$a$-check-DetachedSignImpl$data$2$writeTo$22 = "The operation is a one-shot object.";
                        throw new IllegalStateException($i$a$-check-DetachedSignImpl$data$2$writeTo$22.toString());
                    }
                    Streams.pipeAll((InputStream)this.$data, (OutputStream)((OutputStream)this.$signingStream));
                    this.$signingStream.close();
                    EncryptionResult result = this.$signingStream.getResult();
                    DetachedSignImpl.access$getProtector$p(this.this$0).clear();
                    OpenPGPSignatureSet signatures = result.getDetachedDocumentSignatures();
                    OutputStream out = DetachedSignImpl.access$getArmor$p(this.this$0) ? (OutputStream)ArmoredOutputStreamFactory.Companion.get$default((ArmoredOutputStreamFactory.Companion)ArmoredOutputStreamFactory.Companion, (OutputStream)outputStream, null, (int)2, null) : outputStream;
                    Iterable $this$forEach$iv = (Iterable)signatures;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        OpenPGPSignature.OpenPGPDocumentSignature it = (OpenPGPSignature.OpenPGPDocumentSignature)element$iv;
                        boolean bl = false;
                        it.getSignature().encode(out);
                    }
                    out.close();
                    outputStream.close();
                    $this$forEach$iv = (Iterable)signatures;
                    DetachedSignImpl detachedSignImpl = this.this$0;
                    SigningResult.Builder builder = SigningResult.Companion.builder();
                    boolean $i$f$map = false;
                    Iterator<T> iterator = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature = (OpenPGPSignature.OpenPGPDocumentSignature)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getSignature());
                    }
                    collection = (List)destination$iv$iv;
                    return builder.setMicAlg(DetachedSignImpl.access$micAlgFromSignatures(detachedSignImpl, (List)collection)).build();
                }
            };
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public DetachedSign key(@NotNull InputStream key2) {
        DetachedSignImpl detachedSignImpl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        DetachedSignImpl $this$key_u24lambda_u242 = detachedSignImpl = this;
        boolean bl = false;
        Iterable $this$forEach$iv = new KeyReader($this$key_u24lambda_u242.api).readSecretKeys(key2, true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl2 = false;
            KeyRingInfo info = PGPainless.inspect$default((PGPainless)$this$key_u24lambda_u242.api, (OpenPGPCertificate)((OpenPGPCertificate)it), null, (int)2, null);
            if (!info.isUsableForSigning()) {
                throw new SOPGPException.KeyCannotSign("Key " + info.getFingerprint() + " does not have valid, signing capable subkeys.");
            }
            $this$key_u24lambda_u242.protector.addSecretKey(it);
            $this$key_u24lambda_u242.signingKeys.add(it);
        }
        return detachedSignImpl;
    }

    @NotNull
    public DetachedSign mode(@NotNull SignAs mode) {
        DetachedSignImpl detachedSignImpl;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        DetachedSignImpl $this$mode_u24lambda_u243 = detachedSignImpl = this;
        boolean bl = false;
        $this$mode_u24lambda_u243.mode = mode;
        return detachedSignImpl;
    }

    @NotNull
    public DetachedSign noArmor() {
        DetachedSignImpl detachedSignImpl;
        DetachedSignImpl $this$noArmor_u24lambda_u244 = detachedSignImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u244.armor = false;
        return detachedSignImpl;
    }

    @NotNull
    public DetachedSign withKeyPassword(@NotNull byte[] password) {
        DetachedSignImpl detachedSignImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DetachedSignImpl $this$withKeyPassword_u24lambda_u245 = detachedSignImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addPassphrasePlusRemoveWhitespace(password, $this$withKeyPassword_u24lambda_u245.protector);
        return detachedSignImpl;
    }

    private final DocumentSignatureType modeToSigType(SignAs mode) {
        DocumentSignatureType documentSignatureType;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
                break;
            }
            case 2: {
                documentSignatureType = DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return documentSignatureType;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final MicAlg micAlgFromSignatures(List<? extends PGPSignature> signatures) {
        MicAlg micAlg;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = signatures;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HashAlgorithm it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PGPSignature it = (PGPSignature)element$iv$iv;
            boolean bl2 = false;
            if (HashAlgorithm.Companion.fromId(it.getHashAlgorithm()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        HashAlgorithm hashAlgorithm = (HashAlgorithm)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        if (hashAlgorithm != null) {
            HashAlgorithm it = hashAlgorithm;
            boolean bl = false;
            MicAlg micAlg2 = MicAlg.Companion.fromHashAlgorithmId(it.getAlgorithmId());
            if (micAlg2 != null) {
                micAlg = micAlg2;
                return micAlg;
            }
        }
        micAlg = MicAlg.Companion.empty();
        return micAlg;
    }

    public static final /* synthetic */ MatchMakingSecretKeyRingProtector access$getProtector$p(DetachedSignImpl $this) {
        return $this.protector;
    }

    public static final /* synthetic */ boolean access$getArmor$p(DetachedSignImpl $this) {
        return $this.armor;
    }

    public static final /* synthetic */ MicAlg access$micAlgFromSignatures(DetachedSignImpl $this, List signatures) {
        return $this.micAlgFromSignatures(signatures);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SignAs.values().length];
            try {
                nArray[SignAs.binary.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SignAs.text.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

