/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.VerificationHelper;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.operation.DetachedVerify;
import sop.operation.VerifySignatures;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/sop/DetachedVerifyImpl;", "Lsop/operation/DetachedVerify;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "cert", "Ljava/io/InputStream;", "data", "", "Lsop/Verification;", "notAfter", "timestamp", "Ljava/util/Date;", "notBefore", "signatures", "Lsop/operation/VerifySignatures;", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nDetachedVerifyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetachedVerifyImpl.kt\norg/pgpainless/sop/DetachedVerifyImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n*S KotlinDebug\n*F\n+ 1 DetachedVerifyImpl.kt\norg/pgpainless/sop/DetachedVerifyImpl\n*L\n38#1:72\n38#1:73,3\n*E\n"})
public final class DetachedVerifyImpl
implements DetachedVerify {
    @NotNull
    private final PGPainless api;
    @NotNull
    private final ConsumerOptions options;

    public DetachedVerifyImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.options = ConsumerOptions.Companion.get(this.api).forceNonOpenPgpData();
    }

    @NotNull
    public DetachedVerify cert(@NotNull InputStream cert) {
        DetachedVerifyImpl detachedVerifyImpl;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        DetachedVerifyImpl $this$cert_u24lambda_u240 = detachedVerifyImpl = this;
        boolean bl = false;
        $this$cert_u24lambda_u240.options.addVerificationCerts((Collection)new KeyReader($this$cert_u24lambda_u240.api).readPublicKeys(cert, true));
        return detachedVerifyImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Verification> data(@NotNull InputStream data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        try {
            void $this$mapTo$iv$iv;
            DecryptionStream verificationStream = this.api.processMessage().onInputStream(data2).withOptions(this.options);
            Streams.drain((InputStream)((InputStream)verificationStream));
            verificationStream.close();
            MessageMetadata result = verificationStream.getMetadata();
            Iterable $this$map$iv = result.getVerifiedDetachedSignatures();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SignatureVerification signatureVerification = (SignatureVerification)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VerificationHelper.Companion.mapVerification((SignatureVerification)it));
            }
            List verifications = (List)destination$iv$iv;
            if (!((Collection)this.options.getCertificateSource().getExplicitCertificates()).isEmpty() && verifications.isEmpty()) {
                throw new SOPGPException.NoSignature(null, 1, null);
            }
            return verifications;
        }
        catch (MalformedOpenPgpMessageException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
    }

    @NotNull
    public DetachedVerify notAfter(@NotNull Date timestamp) {
        DetachedVerifyImpl detachedVerifyImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DetachedVerifyImpl $this$notAfter_u24lambda_u242 = detachedVerifyImpl = this;
        boolean bl = false;
        $this$notAfter_u24lambda_u242.options.verifyNotAfter(timestamp);
        return detachedVerifyImpl;
    }

    @NotNull
    public DetachedVerify notBefore(@NotNull Date timestamp) {
        DetachedVerifyImpl detachedVerifyImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DetachedVerifyImpl $this$notBefore_u24lambda_u243 = detachedVerifyImpl = this;
        boolean bl = false;
        $this$notBefore_u24lambda_u243.options.verifyNotBefore(timestamp);
        return detachedVerifyImpl;
    }

    @NotNull
    public VerifySignatures signatures(@NotNull InputStream signatures) {
        DetachedVerifyImpl detachedVerifyImpl;
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        DetachedVerifyImpl $this$signatures_u24lambda_u244 = detachedVerifyImpl = this;
        boolean bl = false;
        try {
            $this$signatures_u24lambda_u244.options.addVerificationOfDetachedSignatures(signatures);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        return (VerifySignatures)detachedVerifyImpl;
    }
}

