/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.AEADAlgorithm;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.PasswordHelper;
import org.pgpainless.util.Passphrase;
import sop.EncryptionResult;
import sop.Profile;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.operation.Encrypt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\fH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/pgpainless/sop/EncryptImpl;", "Lsop/operation/Encrypt;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "armor", "", "encryptionOptions", "Lorg/pgpainless/encryption_signing/EncryptionOptions;", "mode", "Lsop/enums/EncryptAs;", "profile", "", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "signingKeys", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "signingOptions", "Lorg/pgpainless/encryption_signing/SigningOptions;", "modeToSignatureType", "Lorg/pgpainless/algorithm/DocumentSignatureType;", "modeToStreamEncoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "noArmor", "plaintext", "Lsop/ReadyWithResult;", "Lsop/EncryptionResult;", "Ljava/io/InputStream;", "profileName", "signWith", "key", "withCert", "cert", "withKeyPassword", "password", "", "withPassword", "Companion", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nEncryptImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptImpl.kt\norg/pgpainless/sop/EncryptImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1855#3,2:174\n1855#3,2:176\n*S KotlinDebug\n*F\n+ 1 EncryptImpl.kt\norg/pgpainless/sop/EncryptImpl\n*L\n82#1:174,2\n141#1:176,2\n*E\n"})
public final class EncryptImpl
implements Encrypt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPainless api;
    @NotNull
    private final EncryptionOptions encryptionOptions;
    @Nullable
    private SigningOptions signingOptions;
    @NotNull
    private final List<OpenPGPKey> signingKeys;
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector;
    @NotNull
    private String profile;
    @NotNull
    private EncryptAs mode;
    private boolean armor;
    @JvmField
    @NotNull
    public static final Profile RFC4880_PROFILE = new Profile("rfc4880", "Follow the packet format of rfc4880", null, 4, null);
    @JvmField
    @NotNull
    public static final Profile RFC9580_PROFILE = new Profile("rfc9580", "Follow the packet format of rfc9580", null, 4, null);
    @JvmField
    @NotNull
    public static final List<Profile> SUPPORTED_PROFILES;

    public EncryptImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.encryptionOptions = EncryptionOptions.Companion.get(this.api);
        this.signingKeys = new ArrayList();
        this.protector = new MatchMakingSecretKeyRingProtector();
        this.profile = RFC4880_PROFILE.getName();
        this.mode = EncryptAs.binary;
        this.armor = true;
    }

    @NotNull
    public Encrypt mode(@NotNull EncryptAs mode) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        EncryptImpl $this$mode_u24lambda_u240 = encryptImpl = this;
        boolean bl = false;
        $this$mode_u24lambda_u240.mode = mode;
        return encryptImpl;
    }

    @NotNull
    public Encrypt noArmor() {
        EncryptImpl encryptImpl;
        EncryptImpl $this$noArmor_u24lambda_u241 = encryptImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u241.armor = false;
        return encryptImpl;
    }

    @NotNull
    public ReadyWithResult<EncryptionResult> plaintext(@NotNull InputStream plaintext2) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
        if (!this.encryptionOptions.hasEncryptionMethod()) {
            throw new SOPGPException.MissingArg("Missing encryption method.");
        }
        if (this.encryptionOptions.usesOnlyPasswordBasedEncryption() && Intrinsics.areEqual((Object)this.profile, (Object)RFC9580_PROFILE.getName())) {
            MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.aead((int)SymmetricKeyAlgorithm.AES_128.getAlgorithmId(), (int)AEADAlgorithm.OCB.getAlgorithmId());
            Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"aead(...)");
            this.encryptionOptions.overrideEncryptionMechanism(messageEncryptionMechanism);
        }
        if (this.signingOptions != null) {
            SigningOptions signingOptions = this.signingOptions;
            Intrinsics.checkNotNull((Object)signingOptions);
            producerOptions = ProducerOptions.Companion.signAndEncrypt(this.encryptionOptions, signingOptions);
        } else {
            producerOptions = ProducerOptions.Companion.encrypt(this.encryptionOptions);
        }
        ProducerOptions options = producerOptions.setAsciiArmor(this.armor).setEncoding(this.modeToStreamEncoding(this.mode));
        Iterable $this$forEach$iv = this.signingKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl = false;
            try {
                SigningOptions signingOptions = this.signingOptions;
                Intrinsics.checkNotNull((Object)signingOptions);
                signingOptions.addInlineSignature((SecretKeyRingProtector)this.protector, it, this.modeToSignatureType(this.mode));
            }
            catch (KeyException.UnacceptableSigningKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + it.getKeyIdentifier() + " cannot sign", (Throwable)e);
            }
            catch (WrongPassphraseException e) {
                throw new SOPGPException.KeyIsProtected("Cannot unlock key " + it.getKeyIdentifier(), (Throwable)e);
            }
            catch (PGPException e) {
                throw new SOPGPException.BadData((Throwable)e);
            }
        }
        try {
            return (ReadyWithResult)new ReadyWithResult<EncryptionResult>(this, options, plaintext2){
                final /* synthetic */ EncryptImpl this$0;
                final /* synthetic */ ProducerOptions $options;
                final /* synthetic */ InputStream $plaintext;
                {
                    this.this$0 = $receiver;
                    this.$options = $options;
                    this.$plaintext = $plaintext;
                }

                @NotNull
                public EncryptionResult writeTo(@NotNull OutputStream outputStream) {
                    SessionKey sessionKey;
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    EncryptionStream encryptionStream = EncryptImpl.access$getApi$p(this.this$0).generateMessage().onOutputStream(outputStream).withOptions(this.$options);
                    Streams.pipeAll((InputStream)this.$plaintext, (OutputStream)((OutputStream)encryptionStream));
                    encryptionStream.close();
                    org.pgpainless.util.SessionKey sessionKey2 = encryptionStream.getResult().getSessionKey();
                    if (sessionKey2 != null) {
                        org.pgpainless.util.SessionKey it = sessionKey2;
                        boolean bl = false;
                        sessionKey = new SessionKey((byte)it.getAlgorithm().getAlgorithmId(), it.getKey());
                    } else {
                        sessionKey = null;
                    }
                    SessionKey sessionKey3 = sessionKey;
                    return new EncryptionResult(sessionKey3);
                }
            };
        }
        catch (PGPException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public Encrypt profile(@NotNull String profileName) {
        Object v0;
        Object object;
        EncryptImpl encryptImpl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            EncryptImpl $this$profile_u24lambda_u244 = encryptImpl = this;
            boolean bl = false;
            object = SUPPORTED_PROFILES;
            EncryptImpl encryptImpl2 = $this$profile_u24lambda_u244;
            Iterable iterable = object;
            for (Object t : iterable) {
                Profile it = (Profile)t;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)profileName) || it.getAliases().contains(profileName))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Profile profile = v0;
        if (profile == null || (object = profile.getName()) == null) {
            throw new SOPGPException.UnsupportedProfile("encrypt", profileName);
        }
        encryptImpl2.profile = object;
        return encryptImpl;
    }

    @NotNull
    public Encrypt signWith(@NotNull InputStream key2) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        EncryptImpl $this$signWith_u24lambda_u245 = encryptImpl = this;
        boolean bl = false;
        if ($this$signWith_u24lambda_u245.signingOptions == null) {
            $this$signWith_u24lambda_u245.signingOptions = SigningOptions.Companion.get($this$signWith_u24lambda_u245.api);
        }
        OpenPGPKey openPGPKey = (OpenPGPKey)CollectionsKt.singleOrNull(new KeyReader($this$signWith_u24lambda_u245.api).readSecretKeys(key2, true));
        if (openPGPKey == null) {
            throw new SOPGPException.BadData((Throwable)((Object)new AssertionError((Object)"Exactly one secret key at a time expected. Got zero or multiple instead.")));
        }
        OpenPGPKey signingKey = openPGPKey;
        KeyRingInfo info = PGPainless.inspect$default((PGPainless)$this$signWith_u24lambda_u245.api, (OpenPGPCertificate)((OpenPGPCertificate)signingKey), null, (int)2, null);
        if (info.getSigningSubkeys().isEmpty()) {
            throw new SOPGPException.KeyCannotSign("Key " + info.getKeyIdentifier() + " cannot sign.");
        }
        $this$signWith_u24lambda_u245.protector.addSecretKey(signingKey);
        $this$signWith_u24lambda_u245.signingKeys.add(signingKey);
        return encryptImpl;
    }

    @NotNull
    public Encrypt withCert(@NotNull InputStream cert) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        EncryptImpl $this$withCert_u24lambda_u247 = encryptImpl = this;
        boolean bl = false;
        try {
            Iterable $this$forEach$iv = new KeyReader($this$withCert_u24lambda_u247.api).readPublicKeys(cert, true);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OpenPGPCertificate it = (OpenPGPCertificate)element$iv;
                boolean bl2 = false;
                $this$withCert_u24lambda_u247.encryptionOptions.addRecipient(it);
            }
        }
        catch (KeyException.UnacceptableEncryptionKeyException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Cert cannot encrypt";
            }
            throw new SOPGPException.CertCannotEncrypt(string, (Throwable)e);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        return encryptImpl;
    }

    @NotNull
    public Encrypt withKeyPassword(@NotNull byte[] password) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        EncryptImpl $this$withKeyPassword_u24lambda_u248 = encryptImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addPassphrasePlusRemoveWhitespace(password, $this$withKeyPassword_u24lambda_u248.protector);
        return encryptImpl;
    }

    @NotNull
    public Encrypt withPassword(@NotNull String password) {
        EncryptImpl encryptImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        EncryptImpl $this$withPassword_u24lambda_u249 = encryptImpl = this;
        boolean bl = false;
        $this$withPassword_u24lambda_u249.encryptionOptions.addMessagePassphrase(Passphrase.Companion.fromPassword((CharSequence)password).withTrimmedWhitespace());
        return encryptImpl;
    }

    private final StreamEncoding modeToStreamEncoding(EncryptAs mode) {
        StreamEncoding streamEncoding;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                streamEncoding = StreamEncoding.BINARY;
                break;
            }
            case 2: {
                streamEncoding = StreamEncoding.UTF8;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return streamEncoding;
    }

    private final DocumentSignatureType modeToSignatureType(EncryptAs mode) {
        DocumentSignatureType documentSignatureType;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
                break;
            }
            case 2: {
                documentSignatureType = DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return documentSignatureType;
    }

    public static final /* synthetic */ PGPainless access$getApi$p(EncryptImpl $this) {
        return $this.api;
    }

    static {
        Object[] objectArray = new Profile[2];
        String[] stringArray = new String[]{"default", "compatibility"};
        objectArray[0] = RFC4880_PROFILE.withAliases(stringArray);
        stringArray = new String[]{"security", "performance"};
        objectArray[1] = RFC9580_PROFILE.withAliases(stringArray);
        SUPPORTED_PROFILES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/pgpainless/sop/EncryptImpl$Companion;", "", "()V", "RFC4880_PROFILE", "Lsop/Profile;", "RFC9580_PROFILE", "SUPPORTED_PROFILES", "", "pgpainless-sop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptAs.values().length];
            try {
                nArray[EncryptAs.binary.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptAs.text.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

