/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.OpenPGPKeyVersion;
import org.pgpainless.bouncycastle.extensions.OpenPGPCertificateExtensionsKt;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.util.Passphrase;
import sop.Profile;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.GenerateKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0001H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/sop/GenerateKeyImpl;", "Lsop/operation/GenerateKey;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "armor", "", "passphrase", "Lorg/pgpainless/util/Passphrase;", "profile", "", "signingOnly", "userIds", "", "generate", "Lsop/Ready;", "generateKeyWithProfile", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "", "noArmor", "userId", "withKeyPassword", "password", "Companion", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nGenerateKeyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateKeyImpl.kt\norg/pgpainless/sop/GenerateKeyImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1#2:240\n1855#3,2:241\n*S KotlinDebug\n*F\n+ 1 GenerateKeyImpl.kt\norg/pgpainless/sop/GenerateKeyImpl\n*L\n232#1:241,2\n*E\n"})
public final class GenerateKeyImpl
implements GenerateKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPainless api;
    @NotNull
    private final Set<String> userIds;
    private boolean armor;
    private boolean signingOnly;
    @NotNull
    private Passphrase passphrase;
    @NotNull
    private String profile;
    @JvmField
    @NotNull
    public static final Profile CURVE25519_PROFILE = new Profile("draft-koch-eddsa-for-openpgp-00", "OpenPGP v4 keys over Curve25519", null, 4, null);
    @JvmField
    @NotNull
    public static final Profile RFC4880_RSA4096_PROFILE = new Profile("rfc4880-rsa4096", "OpenPGP v4 keys with RSA 4096", null, 4, null);
    @JvmField
    @NotNull
    public static final Profile RFC6637_NIST_P256_PROFILE = new Profile("rfc6637-nist-p256", null, null, 6, null);
    @JvmField
    @NotNull
    public static final Profile RFC6637_NIST_P384_PROFILE = new Profile("rfc6637-nist-p384", null, null, 6, null);
    @JvmField
    @NotNull
    public static final Profile RFC6637_NIST_P521_PROFILE = new Profile("rfc6637-nist-p521", null, null, 6, null);
    @JvmField
    @NotNull
    public static final Profile RFC9580_CURVE25519_PROFILE = new Profile("rfc9580-curve25519", "OpenPGP v6 keys over Curve25519", null, 4, null);
    @JvmField
    @NotNull
    public static final Profile RFC9580_CURVE448_PROFILE = new Profile("rfc9580-curve448", "OpenPGP v6 keys over Curve448", null, 4, null);
    @JvmField
    @NotNull
    public static final List<Profile> SUPPORTED_PROFILES;

    public GenerateKeyImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.userIds = new LinkedHashSet();
        this.armor = true;
        this.passphrase = Passphrase.Companion.emptyPassphrase();
        this.profile = CURVE25519_PROFILE.getName();
    }

    @NotNull
    public Ready generate() {
        try {
            OpenPGPKey key2 = this.generateKeyWithProfile(this.profile, this.userIds, this.passphrase, this.signingOnly);
            return new Ready(this, key2){
                final /* synthetic */ GenerateKeyImpl this$0;
                final /* synthetic */ OpenPGPKey $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                }

                public void writeTo(@NotNull OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    if (GenerateKeyImpl.access$getArmor$p(this.this$0)) {
                        OpenPGPCertificateExtensionsKt.asciiArmor((OpenPGPCertificate)((OpenPGPCertificate)this.$key), (OutputStream)outputStream, (PacketFormat)PacketFormat.CURRENT);
                    } else {
                        OpenPGPCertificateExtensionsKt.encode((OpenPGPCertificate)((OpenPGPCertificate)this.$key), (OutputStream)outputStream, (PacketFormat)PacketFormat.CURRENT);
                    }
                }
            };
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOPGPException.UnsupportedAsymmetricAlgo("Unsupported asymmetric algorithm.", (Throwable)e);
        }
        catch (PGPException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public GenerateKey noArmor() {
        GenerateKeyImpl generateKeyImpl;
        GenerateKeyImpl $this$noArmor_u24lambda_u240 = generateKeyImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u240.armor = false;
        return generateKeyImpl;
    }

    @NotNull
    public GenerateKey profile(@NotNull String profile) {
        Object object;
        Object v0;
        GenerateKeyImpl generateKeyImpl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            GenerateKeyImpl $this$profile_u24lambda_u242 = generateKeyImpl = this;
            boolean bl = false;
            Iterable iterable = SUPPORTED_PROFILES;
            GenerateKeyImpl generateKeyImpl2 = $this$profile_u24lambda_u242;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                Profile it = (Profile)t;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)profile) || it.getAliases().contains(profile))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Profile)v0) == null || (object = object.getName()) == null) {
            throw new SOPGPException.UnsupportedProfile("generate-key", profile);
        }
        generateKeyImpl2.profile = object;
        return generateKeyImpl;
    }

    @NotNull
    public GenerateKey signingOnly() {
        GenerateKeyImpl generateKeyImpl;
        GenerateKeyImpl $this$signingOnly_u24lambda_u243 = generateKeyImpl = this;
        boolean bl = false;
        $this$signingOnly_u24lambda_u243.signingOnly = true;
        return generateKeyImpl;
    }

    @NotNull
    public GenerateKey userId(@NotNull String userId) {
        GenerateKeyImpl generateKeyImpl;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        GenerateKeyImpl $this$userId_u24lambda_u244 = generateKeyImpl = this;
        boolean bl = false;
        $this$userId_u24lambda_u244.userIds.add(userId);
        return generateKeyImpl;
    }

    @NotNull
    public GenerateKey withKeyPassword(@NotNull String password) {
        GenerateKeyImpl generateKeyImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        GenerateKeyImpl $this$withKeyPassword_u24lambda_u245 = generateKeyImpl = this;
        boolean bl = false;
        $this$withKeyPassword_u24lambda_u245.passphrase = Passphrase.Companion.fromPassword((CharSequence)password).withTrimmedWhitespace();
        return generateKeyImpl;
    }

    private final OpenPGPKey generateKeyWithProfile(String profile, Set<String> userIds, Passphrase passphrase, boolean signingOnly) {
        KeyRingBuilder keyRingBuilder;
        KeyFlag[] keyFlagArray;
        KeyFlag[] keyFlagArray2;
        String string = profile;
        if (Intrinsics.areEqual((Object)string, (Object)CURVE25519_PROFILE.getName())) {
            keyFlagArray2 = new KeyRingBuilderInterface[]{KeyFlag.CERTIFY_OTHER};
            KeyRingBuilder keyRingBuilder2 = (KeyRingBuilder)this.api.buildKey(OpenPGPKeyVersion.v4).setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519), keyFlagArray2));
            keyFlagArray2 = new KeyFlag[]{KeyFlag.SIGN_DATA};
            keyFlagArray2 = keyRingBuilder2.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519), keyFlagArray2));
            KeyRingBuilder $this$generateKeyWithProfile_u24lambda_u246 = (KeyRingBuilder)keyFlagArray2;
            boolean bl = false;
            if (!signingOnly) {
                keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                $this$generateKeyWithProfile_u24lambda_u246.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.XDH_LEGACY(XDHLegacySpec._X25519), keyFlagArray));
            }
            keyRingBuilder = (KeyRingBuilder)keyFlagArray2;
        } else if (Intrinsics.areEqual((Object)string, (Object)RFC4880_RSA4096_PROFILE.getName())) {
            keyFlagArray2 = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
            KeyRingBuilder keyRingBuilder3 = (KeyRingBuilder)this.api.buildKey(OpenPGPKeyVersion.v4).setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.RSA(RsaLength._4096), keyFlagArray2));
            keyFlagArray2 = new KeyFlag[]{KeyFlag.SIGN_DATA};
            keyFlagArray2 = keyRingBuilder3.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.RSA(RsaLength._4096), keyFlagArray2));
            KeyRingBuilder $this$generateKeyWithProfile_u24lambda_u247 = (KeyRingBuilder)keyFlagArray2;
            boolean bl = false;
            if (!signingOnly) {
                keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                $this$generateKeyWithProfile_u24lambda_u247.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.RSA(RsaLength._4096), keyFlagArray));
            }
            keyRingBuilder = (KeyRingBuilder)keyFlagArray2;
        } else if (Intrinsics.areEqual((Object)string, (Object)RFC6637_NIST_P256_PROFILE.getName())) {
            keyFlagArray2 = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
            KeyRingBuilder keyRingBuilder4 = (KeyRingBuilder)this.api.buildKey(OpenPGPKeyVersion.v4).setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDSA(EllipticCurve._P256), keyFlagArray2));
            keyFlagArray2 = new KeyFlag[]{KeyFlag.SIGN_DATA};
            keyFlagArray2 = keyRingBuilder4.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDSA(EllipticCurve._P256), keyFlagArray2));
            KeyRingBuilder $this$generateKeyWithProfile_u24lambda_u248 = (KeyRingBuilder)keyFlagArray2;
            boolean bl = false;
            if (!signingOnly) {
                keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                $this$generateKeyWithProfile_u24lambda_u248.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDH(EllipticCurve._P256), keyFlagArray));
            }
            keyRingBuilder = (KeyRingBuilder)keyFlagArray2;
        } else if (Intrinsics.areEqual((Object)string, (Object)RFC6637_NIST_P384_PROFILE.getName())) {
            keyFlagArray2 = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
            KeyRingBuilder keyRingBuilder5 = (KeyRingBuilder)this.api.buildKey(OpenPGPKeyVersion.v4).setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDSA(EllipticCurve._P384), keyFlagArray2));
            keyFlagArray2 = new KeyFlag[]{KeyFlag.SIGN_DATA};
            keyFlagArray2 = keyRingBuilder5.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDSA(EllipticCurve._P384), keyFlagArray2));
            KeyRingBuilder $this$generateKeyWithProfile_u24lambda_u249 = (KeyRingBuilder)keyFlagArray2;
            boolean bl = false;
            if (!signingOnly) {
                keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                $this$generateKeyWithProfile_u24lambda_u249.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDH(EllipticCurve._P384), keyFlagArray));
            }
            keyRingBuilder = (KeyRingBuilder)keyFlagArray2;
        } else if (Intrinsics.areEqual((Object)string, (Object)RFC6637_NIST_P521_PROFILE.getName())) {
            keyFlagArray2 = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
            KeyRingBuilder keyRingBuilder6 = (KeyRingBuilder)this.api.buildKey(OpenPGPKeyVersion.v4).setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDSA(EllipticCurve._P521), keyFlagArray2));
            keyFlagArray2 = new KeyFlag[]{KeyFlag.SIGN_DATA};
            keyFlagArray2 = keyRingBuilder6.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDSA(EllipticCurve._P521), keyFlagArray2));
            KeyRingBuilder $this$generateKeyWithProfile_u24lambda_u2410 = (KeyRingBuilder)keyFlagArray2;
            boolean bl = false;
            if (!signingOnly) {
                keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                $this$generateKeyWithProfile_u24lambda_u2410.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDH(EllipticCurve._P521), keyFlagArray));
            }
            keyRingBuilder = (KeyRingBuilder)keyFlagArray2;
        } else if (Intrinsics.areEqual((Object)string, (Object)RFC9580_CURVE25519_PROFILE.getName())) {
            keyFlagArray2 = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
            KeyRingBuilder keyRingBuilder7 = (KeyRingBuilder)this.api.buildKey(OpenPGPKeyVersion.v6).setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.Ed25519(), keyFlagArray2));
            keyFlagArray2 = new KeyFlag[]{KeyFlag.SIGN_DATA};
            keyFlagArray2 = keyRingBuilder7.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.Ed25519(), keyFlagArray2));
            KeyRingBuilder $this$generateKeyWithProfile_u24lambda_u2411 = (KeyRingBuilder)keyFlagArray2;
            boolean bl = false;
            if (!signingOnly) {
                keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                $this$generateKeyWithProfile_u24lambda_u2411.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.X25519(), keyFlagArray));
            }
            keyRingBuilder = (KeyRingBuilder)keyFlagArray2;
        } else if (Intrinsics.areEqual((Object)string, (Object)RFC9580_CURVE448_PROFILE.getName())) {
            keyFlagArray2 = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
            KeyRingBuilder keyRingBuilder8 = (KeyRingBuilder)this.api.buildKey(OpenPGPKeyVersion.v6).setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.Ed448(), keyFlagArray2));
            keyFlagArray2 = new KeyFlag[]{KeyFlag.SIGN_DATA};
            keyFlagArray2 = keyRingBuilder8.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.Ed448(), keyFlagArray2));
            KeyRingBuilder $this$generateKeyWithProfile_u24lambda_u2412 = (KeyRingBuilder)keyFlagArray2;
            boolean bl = false;
            if (!signingOnly) {
                keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                $this$generateKeyWithProfile_u24lambda_u2412.addSubkey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.X448(), keyFlagArray));
            }
            keyRingBuilder = (KeyRingBuilder)keyFlagArray2;
        } else {
            throw new SOPGPException.UnsupportedProfile("generate-key", profile);
        }
        KeyRingBuilder keyBuilder = keyRingBuilder;
        Iterable $this$forEach$iv = userIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            keyBuilder.addUserId((CharSequence)it);
        }
        if (!passphrase.isEmpty()) {
            keyBuilder.setPassphrase(passphrase);
        }
        return keyBuilder.build();
    }

    public static final /* synthetic */ boolean access$getArmor$p(GenerateKeyImpl $this) {
        return $this.armor;
    }

    static {
        Object[] objectArray = new Profile[7];
        String[] stringArray = new String[]{"default", "compatibility"};
        objectArray[0] = CURVE25519_PROFILE.withAliases(stringArray);
        objectArray[1] = RFC4880_RSA4096_PROFILE;
        objectArray[2] = RFC6637_NIST_P256_PROFILE;
        objectArray[3] = RFC6637_NIST_P384_PROFILE;
        objectArray[4] = RFC6637_NIST_P521_PROFILE;
        stringArray = new String[]{"performance", "security"};
        objectArray[5] = RFC9580_CURVE25519_PROFILE.withAliases(stringArray);
        objectArray[6] = RFC9580_CURVE448_PROFILE;
        SUPPORTED_PROFILES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pgpainless/sop/GenerateKeyImpl$Companion;", "", "()V", "CURVE25519_PROFILE", "Lsop/Profile;", "RFC4880_RSA4096_PROFILE", "RFC6637_NIST_P256_PROFILE", "RFC6637_NIST_P384_PROFILE", "RFC6637_NIST_P521_PROFILE", "RFC9580_CURVE25519_PROFILE", "RFC9580_CURVE448_PROFILE", "SUPPORTED_PROFILES", "", "pgpainless-sop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

