/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.PasswordHelper;
import sop.Ready;
import sop.enums.InlineSignAs;
import sop.exception.SOPGPException;
import sop.operation.InlineSign;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/sop/InlineSignImpl;", "Lsop/operation/InlineSign;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "armor", "", "mode", "Lsop/enums/InlineSignAs;", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "signingKeys", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "signingOptions", "Lorg/pgpainless/encryption_signing/SigningOptions;", "data", "Lsop/Ready;", "Ljava/io/InputStream;", "key", "modeToSigType", "Lorg/pgpainless/algorithm/DocumentSignatureType;", "noArmor", "withKeyPassword", "password", "", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nInlineSignImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineSignImpl.kt\norg/pgpainless/sop/InlineSignImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1855#2,2:125\n1855#2,2:127\n1#3:129\n*S KotlinDebug\n*F\n+ 1 InlineSignImpl.kt\norg/pgpainless/sop/InlineSignImpl\n*L\n37#1:125,2\n97#1:127,2\n*E\n"})
public final class InlineSignImpl
implements InlineSign {
    @NotNull
    private final PGPainless api;
    @NotNull
    private final SigningOptions signingOptions;
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector;
    @NotNull
    private final List<OpenPGPKey> signingKeys;
    private boolean armor;
    @NotNull
    private InlineSignAs mode;

    public InlineSignImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.signingOptions = SigningOptions.Companion.get(this.api);
        this.protector = new MatchMakingSecretKeyRingProtector();
        this.signingKeys = new ArrayList();
        this.armor = true;
        this.mode = InlineSignAs.binary;
    }

    @NotNull
    public Ready data(@NotNull InputStream data2) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$forEach$iv = this.signingKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey key2 = (OpenPGPKey)element$iv;
            boolean bl = false;
            try {
                if (this.mode == InlineSignAs.clearsigned) {
                    this.signingOptions.addDetachedSignature((SecretKeyRingProtector)this.protector, key2, this.modeToSigType(this.mode));
                    continue;
                }
                this.signingOptions.addInlineSignature((SecretKeyRingProtector)this.protector, key2, this.modeToSigType(this.mode));
            }
            catch (KeyException.UnacceptableSigningKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + key2.getKeyIdentifier() + " cannot sign.", (Throwable)e);
            }
            catch (KeyException.MissingSecretKeyException e) {
                throw new SOPGPException.KeyCannotSign("Key " + key2.getKeyIdentifier() + " does not have the secret signing key component available.", (Throwable)e);
            }
            catch (PGPException e) {
                throw new SOPGPException.KeyIsProtected("Key " + key2.getKeyIdentifier() + " cannot be unlocked.", (Throwable)e);
            }
        }
        ProducerOptions $this$data_u24lambda_u241 = producerOptions = ProducerOptions.Companion.sign(this.signingOptions);
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                $this$data_u24lambda_u241.setCleartextSigned();
                $this$data_u24lambda_u241.setAsciiArmor(true);
                $this$data_u24lambda_u241.setEncoding(StreamEncoding.TEXT);
                $this$data_u24lambda_u241.applyCRLFEncoding();
                break;
            }
            case 2: {
                $this$data_u24lambda_u241.setEncoding(StreamEncoding.TEXT);
                $this$data_u24lambda_u241.applyCRLFEncoding();
                break;
            }
            default: {
                $this$data_u24lambda_u241.setAsciiArmor(this.armor);
            }
        }
        $this$data_u24lambda_u241.overrideCompressionAlgorithm(CompressionAlgorithm.UNCOMPRESSED);
        ProducerOptions producerOptions2 = producerOptions;
        return new Ready(this, producerOptions2, data2){
            final /* synthetic */ InlineSignImpl this$0;
            final /* synthetic */ ProducerOptions $producerOptions;
            final /* synthetic */ InputStream $data;
            {
                this.this$0 = $receiver;
                this.$producerOptions = $producerOptions;
                this.$data = $data;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                try {
                    EncryptionStream signingStream = InlineSignImpl.access$getApi$p(this.this$0).generateMessage().onOutputStream(outputStream).withOptions(this.$producerOptions);
                    Streams.pipeAll((InputStream)this.$data, (OutputStream)((OutputStream)signingStream));
                    signingStream.close();
                    InlineSignImpl.access$getProtector$p(this.this$0).clear();
                }
                catch (PGPException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @NotNull
    public InlineSign key(@NotNull InputStream key2) {
        InlineSignImpl inlineSignImpl;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        InlineSignImpl $this$key_u24lambda_u243 = inlineSignImpl = this;
        boolean bl = false;
        Iterable $this$forEach$iv = new KeyReader($this$key_u24lambda_u243.api).readSecretKeys(key2, true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl2 = false;
            KeyRingInfo info = PGPainless.inspect$default((PGPainless)$this$key_u24lambda_u243.api, (OpenPGPCertificate)((OpenPGPCertificate)it), null, (int)2, null);
            if (!info.isUsableForSigning()) {
                throw new SOPGPException.KeyCannotSign("Key " + info.getKeyIdentifier() + " does not have valid, signing capable subkeys.");
            }
            $this$key_u24lambda_u243.protector.addSecretKey(it);
            $this$key_u24lambda_u243.signingKeys.add(it);
        }
        return inlineSignImpl;
    }

    @NotNull
    public InlineSign mode(@NotNull InlineSignAs mode) {
        InlineSignImpl inlineSignImpl;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        InlineSignImpl $this$mode_u24lambda_u244 = inlineSignImpl = this;
        boolean bl = false;
        $this$mode_u24lambda_u244.mode = mode;
        return inlineSignImpl;
    }

    @NotNull
    public InlineSign noArmor() {
        InlineSignImpl inlineSignImpl;
        InlineSignImpl $this$noArmor_u24lambda_u245 = inlineSignImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u245.armor = false;
        return inlineSignImpl;
    }

    @NotNull
    public InlineSign withKeyPassword(@NotNull byte[] password) {
        InlineSignImpl inlineSignImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        InlineSignImpl $this$withKeyPassword_u24lambda_u246 = inlineSignImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addPassphrasePlusRemoveWhitespace(password, $this$withKeyPassword_u24lambda_u246.protector);
        return inlineSignImpl;
    }

    private final DocumentSignatureType modeToSigType(InlineSignAs mode) {
        DocumentSignatureType documentSignatureType;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 3: {
                documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
                break;
            }
            case 2: {
                documentSignatureType = DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
                break;
            }
            case 1: {
                documentSignatureType = DocumentSignatureType.CANONICAL_TEXT_DOCUMENT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return documentSignatureType;
    }

    public static final /* synthetic */ PGPainless access$getApi$p(InlineSignImpl $this) {
        return $this.api;
    }

    public static final /* synthetic */ MatchMakingSecretKeyRingProtector access$getProtector$p(InlineSignImpl $this) {
        return $this.protector;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InlineSignAs.values().length];
            try {
                nArray[InlineSignAs.clearsigned.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineSignAs.text.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineSignAs.binary.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

