/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import sop.exception.SOPGPException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/sop/KeyReader;", "", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "getApi", "()Lorg/pgpainless/PGPainless;", "readPublicKeys", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "certIn", "Ljava/io/InputStream;", "requireContent", "", "readSecretKeys", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "keyInputStream", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nKeyReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyReader.kt\norg/pgpainless/sop/KeyReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1747#2,3:71\n*S KotlinDebug\n*F\n+ 1 KeyReader.kt\norg/pgpainless/sop/KeyReader\n*L\n58#1:71,3\n*E\n"})
public final class KeyReader {
    @NotNull
    private final PGPainless api;

    public KeyReader(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
    }

    public /* synthetic */ KeyReader(PGPainless pGPainless, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pGPainless = PGPainless.Companion.getInstance();
        }
        this(pGPainless);
    }

    @NotNull
    public final PGPainless getApi() {
        return this.api;
    }

    @NotNull
    public final List<OpenPGPKey> readSecretKeys(@NotNull InputStream keyInputStream, boolean requireContent) {
        List list;
        Intrinsics.checkNotNullParameter((Object)keyInputStream, (String)"keyInputStream");
        try {
            list = this.api.readKey().parseKeys(keyInputStream);
        }
        catch (IOException e) {
            block9: {
                block8: {
                    if (e.getMessage() == null) {
                        throw e;
                    }
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.startsWith$default((String)string, (String)"unknown object in stream:", (boolean)false, (int)2, null)) break block8;
                    String string2 = e.getMessage();
                    Intrinsics.checkNotNull((Object)string2);
                    if (StringsKt.startsWith$default((String)string2, (String)"invalid header encountered", (boolean)false, (int)2, null)) break block8;
                    String string3 = e.getMessage();
                    Intrinsics.checkNotNull((Object)string3);
                    if (!StringsKt.startsWith$default((String)string3, (String)"Encountered unexpected packet:", (boolean)false, (int)2, null)) break block9;
                }
                throw new SOPGPException.BadData((Throwable)e);
            }
            throw e;
        }
        List keys2 = list;
        if (requireContent) {
            Intrinsics.checkNotNull((Object)keys2);
            if (CollectionsKt.none((Iterable)keys2)) {
                throw new SOPGPException.BadData((Throwable)new PGPException("No key data found."));
            }
        }
        Intrinsics.checkNotNull((Object)keys2);
        return keys2;
    }

    @NotNull
    public final List<OpenPGPCertificate> readPublicKeys(@NotNull InputStream certIn, boolean requireContent) {
        boolean bl;
        List certs2;
        block13: {
            List list;
            Intrinsics.checkNotNullParameter((Object)certIn, (String)"certIn");
            try {
                list = this.api.readKey().parseKeysOrCertificates(certIn);
            }
            catch (IOException e) {
                block15: {
                    block14: {
                        if (e.getMessage() == null) {
                            throw e;
                        }
                        String string = e.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        if (StringsKt.startsWith$default((String)string, (String)"unknown object in stream:", (boolean)false, (int)2, null)) break block14;
                        String string2 = e.getMessage();
                        Intrinsics.checkNotNull((Object)string2);
                        if (!StringsKt.startsWith$default((String)string2, (String)"invalid header encountered", (boolean)false, (int)2, null)) break block15;
                    }
                    throw new SOPGPException.BadData((Throwable)e);
                }
                throw e;
            }
            catch (PGPRuntimeOperationException e) {
                throw new SOPGPException.BadData((Throwable)e);
            }
            certs2 = list;
            Intrinsics.checkNotNull((Object)certs2);
            Iterable $this$any$iv = certs2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OpenPGPCertificate it = (OpenPGPCertificate)element$iv;
                    boolean bl2 = false;
                    if (!it.isSecretKey()) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new SOPGPException.BadData("Secret key components encountered, while certificates were expected.");
        }
        if (requireContent && certs2.isEmpty()) {
            throw new SOPGPException.BadData("No certificate data found.");
        }
        return certs2;
    }

    public KeyReader() {
        this(null, 1, null);
    }
}

