/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u001eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "()V", "keys", "", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "passphrases", "Lorg/pgpainless/util/Passphrase;", "protector", "Lorg/pgpainless/key/protection/CachingSecretKeyRingProtector;", "addPassphrase", "passphrase", "addSecretKey", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "clear", "", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "getKeyPassword", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "hasPassphraseFor", "", "testPassphrase", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nMatchMakingSecretKeyRingProtector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchMakingSecretKeyRingProtector.kt\norg/pgpainless/sop/MatchMakingSecretKeyRingProtector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1855#2,2:101\n1855#2:103\n1855#2,2:104\n1856#2:106\n1855#2,2:107\n1855#2,2:109\n*S KotlinDebug\n*F\n+ 1 MatchMakingSecretKeyRingProtector.kt\norg/pgpainless/sop/MatchMakingSecretKeyRingProtector\n*L\n40#1:101,2\n60#1:103\n64#1:104,2\n60#1:106\n96#1:107,2\n97#1:109,2\n*E\n"})
public final class MatchMakingSecretKeyRingProtector
implements SecretKeyRingProtector {
    @NotNull
    private final Set<Passphrase> passphrases = new LinkedHashSet();
    @NotNull
    private final Set<PGPSecretKeyRing> keys = new LinkedHashSet();
    @NotNull
    private final CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector();

    @NotNull
    public final MatchMakingSecretKeyRingProtector addPassphrase(@NotNull Passphrase passphrase) {
        MatchMakingSecretKeyRingProtector matchMakingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        MatchMakingSecretKeyRingProtector $this$addPassphrase_u24lambda_u241 = matchMakingSecretKeyRingProtector = this;
        boolean bl = false;
        if (!passphrase.isEmpty() && $this$addPassphrase_u24lambda_u241.passphrases.add(passphrase)) {
            Iterable $this$forEach$iv = $this$addPassphrase_u24lambda_u241.keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PGPSecretKeyRing key2 = (PGPSecretKeyRing)element$iv;
                boolean bl2 = false;
                for (PGPSecretKey subkey : key2) {
                    CachingSecretKeyRingProtector cachingSecretKeyRingProtector = $this$addPassphrase_u24lambda_u241.protector;
                    KeyIdentifier keyIdentifier = subkey.getKeyIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                    if (cachingSecretKeyRingProtector.hasPassphrase(keyIdentifier)) continue;
                    Intrinsics.checkNotNull((Object)subkey);
                    if (!$this$addPassphrase_u24lambda_u241.testPassphrase(passphrase, subkey)) continue;
                    CachingSecretKeyRingProtector cachingSecretKeyRingProtector2 = $this$addPassphrase_u24lambda_u241.protector;
                    KeyIdentifier keyIdentifier2 = subkey.getKeyIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier2, (String)"getKeyIdentifier(...)");
                    cachingSecretKeyRingProtector2.addPassphrase(keyIdentifier2, passphrase);
                }
            }
        }
        return matchMakingSecretKeyRingProtector;
    }

    @NotNull
    public final MatchMakingSecretKeyRingProtector addSecretKey(@NotNull OpenPGPKey key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        PGPSecretKeyRing pGPSecretKeyRing = key2.getPGPSecretKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing, (String)"getPGPSecretKeyRing(...)");
        return this.addSecretKey(pGPSecretKeyRing);
    }

    @NotNull
    public final MatchMakingSecretKeyRingProtector addSecretKey(@NotNull PGPSecretKeyRing key2) {
        MatchMakingSecretKeyRingProtector matchMakingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        MatchMakingSecretKeyRingProtector $this$addSecretKey_u24lambda_u244 = matchMakingSecretKeyRingProtector = this;
        boolean bl = false;
        if ($this$addSecretKey_u24lambda_u244.keys.add(key2)) {
            Iterable $this$forEach$iv = (Iterable)key2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PGPSecretKey subkey = (PGPSecretKey)element$iv;
                boolean bl2 = false;
                if (PGPSecretKeyExtensionsKt.isDecrypted((PGPSecretKey)subkey)) {
                    CachingSecretKeyRingProtector cachingSecretKeyRingProtector = $this$addSecretKey_u24lambda_u244.protector;
                    KeyIdentifier keyIdentifier = subkey.getKeyIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                    cachingSecretKeyRingProtector.addPassphrase(keyIdentifier, Passphrase.Companion.emptyPassphrase());
                    continue;
                }
                Iterable $this$forEach$iv2 = $this$addSecretKey_u24lambda_u244.passphrases;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Passphrase passphrase = (Passphrase)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)subkey);
                    if (!$this$addSecretKey_u24lambda_u244.testPassphrase(passphrase, subkey)) continue;
                    CachingSecretKeyRingProtector cachingSecretKeyRingProtector = $this$addSecretKey_u24lambda_u244.protector;
                    KeyIdentifier keyIdentifier = subkey.getKeyIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                    cachingSecretKeyRingProtector.addPassphrase(keyIdentifier, passphrase);
                }
            }
        }
        return matchMakingSecretKeyRingProtector;
    }

    private final boolean testPassphrase(Passphrase passphrase, PGPSecretKey key2) {
        boolean bl;
        try {
            PGPSecretKeyExtensionsKt.unlock((PGPSecretKey)key2, (Passphrase)passphrase);
            bl = true;
        }
        catch (PGPException e) {
            bl = false;
        }
        return bl;
    }

    public boolean hasPassphraseFor(@NotNull KeyIdentifier keyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        return this.protector.hasPassphrase(keyIdentifier);
    }

    @Nullable
    public PBESecretKeyDecryptor getDecryptor(@NotNull KeyIdentifier keyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        return this.protector.getDecryptor(keyIdentifier);
    }

    @Nullable
    public PBESecretKeyEncryptor getEncryptor(@NotNull PGPPublicKey key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.protector.getEncryptor(key2);
    }

    @Nullable
    public char[] getKeyPassword(@NotNull OpenPGPKey.OpenPGPSecretKey key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.protector.getKeyPassword(key2);
    }

    public final void clear() {
        Passphrase it;
        Iterable $this$forEach$iv = this.passphrases;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Passphrase)element$iv;
            boolean bl = false;
            it.clear();
        }
        $this$forEach$iv = this.keys;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PGPSecretKeyRing)element$iv;
            boolean bl = false;
            this.protector.forgetPassphrase((PGPKeyRing)it);
        }
    }
}

