/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.PasswordHelper;
import org.pgpainless.util.OpenPGPCertificateUtil;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.RevokeKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/sop/RevokeKeyImpl;", "Lsop/operation/RevokeKey;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "armor", "", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "keys", "Lsop/Ready;", "Ljava/io/InputStream;", "noArmor", "withKeyPassword", "password", "", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nRevokeKeyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevokeKeyImpl.kt\norg/pgpainless/sop/RevokeKeyImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1855#2,2:83\n1855#2,2:85\n1#3:87\n*S KotlinDebug\n*F\n+ 1 RevokeKeyImpl.kt\norg/pgpainless/sop/RevokeKeyImpl\n*L\n35#1:83,2\n38#1:85,2\n*E\n"})
public final class RevokeKeyImpl
implements RevokeKey {
    @NotNull
    private final PGPainless api;
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector;
    private boolean armor;

    public RevokeKeyImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.protector = new MatchMakingSecretKeyRingProtector();
        this.armor = true;
    }

    @NotNull
    public Ready keys(@NotNull InputStream keys2) {
        List<OpenPGPKey> list;
        Intrinsics.checkNotNullParameter((Object)keys2, (String)"keys");
        try {
            list = new KeyReader(this.api).readSecretKeys(keys2, true);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData("Cannot decode secret keys.", (Throwable)e);
        }
        List<OpenPGPKey> secretKeys = list;
        Iterable $this$forEach$iv = secretKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl = false;
            this.protector.addSecretKey(it);
        }
        List revocationCertificates = new ArrayList();
        Iterable $this$forEach$iv2 = secretKeys;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            OpenPGPKey it = (OpenPGPKey)element$iv;
            boolean bl = false;
            SecretKeyRingEditor editor = PGPainless.modify$default((PGPainless)this.api, (OpenPGPKey)it, null, (int)2, null);
            try {
                RevocationAttributes attributes = RevocationAttributes.Companion.createKeyRevocation().withReason(RevocationAttributes.Reason.NO_REASON).withoutDescription();
                if (it.getPrimaryKey().getVersion() == 6) {
                    revocationCertificates.add(editor.createMinimalRevocationCertificate((SecretKeyRingProtector)this.protector, attributes));
                    continue;
                }
                OpenPGPCertificate certificate = it.toCertificate();
                OpenPGPSignature revocation = editor.createRevocation((SecretKeyRingProtector)this.protector, attributes);
                PGPKeyRing pGPKeyRing = certificate.getPGPKeyRing();
                PGPSignature pGPSignature = revocation.getSignature();
                Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
                PGPKeyRing pGPKeyRing2 = KeyRingUtils.Companion.injectCertification(pGPKeyRing, pGPSignature);
                Intrinsics.checkNotNullExpressionValue((Object)pGPKeyRing2, (String)"injectCertification(...)");
                revocationCertificates.add(PGPKeyRingExtensionsKt.toOpenPGPCertificate((PGPKeyRing)pGPKeyRing2, (OpenPGPImplementation)this.api.getImplementation()));
            }
            catch (WrongPassphraseException e) {
                throw new SOPGPException.KeyIsProtected("Missing or wrong passphrase for key " + it.getKeyIdentifier(), (Throwable)e);
            }
            catch (PGPException e) {
                throw new RuntimeException("Cannot generate revocation certificate for key " + it.getKeyIdentifier(), e);
            }
        }
        return new Ready(this, revocationCertificates){
            final /* synthetic */ RevokeKeyImpl this$0;
            final /* synthetic */ List<OpenPGPCertificate> $revocationCertificates;
            {
                this.this$0 = $receiver;
                this.$revocationCertificates = $revocationCertificates;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                if (RevokeKeyImpl.access$getArmor$p(this.this$0)) {
                    OpenPGPCertificateUtil.Companion.armor$default((OpenPGPCertificateUtil.Companion)OpenPGPCertificateUtil.Companion, (Collection)this.$revocationCertificates, (OutputStream)outputStream, null, (int)4, null);
                } else {
                    OpenPGPCertificateUtil.Companion.encode$default((OpenPGPCertificateUtil.Companion)OpenPGPCertificateUtil.Companion, (Collection)this.$revocationCertificates, (OutputStream)outputStream, null, (int)4, null);
                }
            }
        };
    }

    @NotNull
    public RevokeKey noArmor() {
        RevokeKeyImpl revokeKeyImpl;
        RevokeKeyImpl $this$noArmor_u24lambda_u242 = revokeKeyImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u242.armor = false;
        return revokeKeyImpl;
    }

    @NotNull
    public RevokeKey withKeyPassword(@NotNull byte[] password) {
        RevokeKeyImpl revokeKeyImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        RevokeKeyImpl $this$withKeyPassword_u24lambda_u243 = revokeKeyImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addPassphrasePlusRemoveWhitespace(password, $this$withKeyPassword_u24lambda_u243.protector);
        return revokeKeyImpl;
    }

    public static final /* synthetic */ boolean access$getArmor$p(RevokeKeyImpl $this) {
        return $this.armor;
    }
}

