/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.sop.SOPImpl;
import sop.ByteArrayAndResult;
import sop.SOP;
import sop.Signatures;
import sop.enums.InlineSignAs;
import sop.enums.SignatureMode;
import sop.exception.SOPGPException;
import sop.operation.DetachedVerify;
import sop.operation.InlineSign;
import sop.testsuite.assertions.VerificationListAssert;

public class InlineDetachTest {
    private static final SOP sop = new SOPImpl();

    @Test
    public void detachCleartextSignedMessage() throws IOException {
        byte[] key = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(key);
        byte[] data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        byte[] cleartextSigned = ((InlineSign)((InlineSign)sop.inlineSign().key(key)).withKeyPassword("sw0rdf1sh")).mode(InlineSignAs.clearsigned).data(data).getBytes();
        ByteArrayAndResult detachedMsg = sop.inlineDetach().message(cleartextSigned).toByteArrayAndResult();
        byte[] message = detachedMsg.getBytes();
        byte[] signature = ((Signatures)detachedMsg.getResult()).getBytes();
        List verificationList = ((DetachedVerify)sop.verify().cert(cert)).signatures(signature).data(message);
        VerificationListAssert.assertThatVerificationList((List)verificationList).hasSingleItem().issuedBy(new OpenPgpV4Fingerprint((PGPKeyRing)secretKey).toString()).hasMode(SignatureMode.text);
        Assertions.assertArrayEquals((byte[])data, (byte[])message);
    }

    @Test
    public void detachInbandSignedMessage() throws IOException {
        byte[] key = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        byte[] data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)sop.inlineSign().key(key)).data(data).getBytes();
        ByteArrayAndResult detachedMsg = sop.inlineDetach().message(inlineSigned).toByteArrayAndResult();
        byte[] message = detachedMsg.getBytes();
        byte[] signature = ((Signatures)detachedMsg.getResult()).getBytes();
        List verificationList = ((DetachedVerify)sop.verify().cert(cert)).signatures(signature).data(message);
        VerificationListAssert.assertThatVerificationList((List)verificationList).hasSingleItem().hasMode(SignatureMode.binary);
        Assertions.assertArrayEquals((byte[])data, (byte[])message);
    }

    @Test
    public void detachOpenPgpMessage() throws IOException {
        Object signature;
        Object next;
        byte[] key = sop.generateKey().userId("Alice <alice@pgpainless.org>").generate().getBytes();
        byte[] cert = sop.extractCert().key(key).getBytes();
        byte[] data = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        byte[] inlineSigned = ((InlineSign)sop.inlineSign().key(key)).data(data).getBytes();
        ByteArrayOutputStream literalDataAndSignatures = new ByteArrayOutputStream();
        ArmoredInputStream armorIn = new ArmoredInputStream((InputStream)new ByteArrayInputStream(inlineSigned));
        PGPObjectFactory objectFactory = OpenPGPImplementation.getInstance().pgpObjectFactory((InputStream)armorIn);
        while ((next = objectFactory.nextObject()) != null) {
            Object litGen;
            if (next instanceof PGPCompressedData) {
                PGPCompressedData compressedData = (PGPCompressedData)next;
                try {
                    objectFactory = OpenPGPImplementation.getInstance().pgpObjectFactory(compressedData.getDataStream());
                    continue;
                }
                catch (PGPException e) {
                    throw new SOPGPException.BadData("Cannot decompress compressed data", (Throwable)e);
                }
            }
            if (next instanceof PGPLiteralData) {
                PGPLiteralData litDat = (PGPLiteralData)next;
                litGen = new PGPLiteralDataGenerator();
                OutputStream litOut = litGen.open((OutputStream)literalDataAndSignatures, (char)litDat.getFormat(), litDat.getFileName(), litDat.getModificationTime(), new byte[8192]);
                Streams.pipeAll((InputStream)litDat.getDataStream(), (OutputStream)litOut);
                litOut.close();
                continue;
            }
            if (!(next instanceof PGPSignatureList)) continue;
            PGPSignatureList signatures = (PGPSignatureList)next;
            litGen = signatures.iterator();
            while (litGen.hasNext()) {
                signature = (PGPSignature)litGen.next();
                signature.encode((OutputStream)literalDataAndSignatures);
            }
        }
        ByteArrayAndResult detachedMsg = sop.inlineDetach().message(literalDataAndSignatures.toByteArray()).toByteArrayAndResult();
        byte[] message = detachedMsg.getBytes();
        signature = ((Signatures)detachedMsg.getResult()).getBytes();
        List verificationList = ((DetachedVerify)sop.verify().cert(cert)).signatures(signature).data(message);
        VerificationListAssert.assertThatVerificationList((List)verificationList).hasSingleItem().hasMode(SignatureMode.binary);
        Assertions.assertArrayEquals((byte[])data, (byte[])message);
    }

    @Test
    public void detachSignaturesFromCompressedMessage() throws PGPException, IOException {
        PGPainless api = PGPainless.getInstance();
        OpenPGPKey key = api.generateKey().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        byte[] cert = key.toCertificate().getEncoded();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        EncryptionStream eOut = api.generateMessage().onOutputStream((OutputStream)bOut).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addInlineSignature((SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys(), key)).overrideCompressionAlgorithm(CompressionAlgorithm.ZIP));
        eOut.write("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        eOut.close();
        ByteArrayAndResult result = sop.inlineDetach().message(bOut.toByteArray()).toByteArrayAndResult();
        byte[] message = result.getBytes();
        byte[] signatures = ((Signatures)result.getResult()).getBytes();
        List verifications = ((DetachedVerify)sop.detachedVerify().cert(cert)).signatures(signatures).data(message);
        Assertions.assertFalse((boolean)verifications.isEmpty());
    }

    @Test
    public void detachMissingSignaturesFails() throws PGPException, IOException {
        PGPainless api = PGPainless.getInstance();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        EncryptionStream eOut = api.generateMessage().onOutputStream((OutputStream)bOut).withOptions(ProducerOptions.noEncryptionNoSigning().overrideCompressionAlgorithm(CompressionAlgorithm.ZIP));
        eOut.write("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        eOut.close();
        Assertions.assertThrows(SOPGPException.BadData.class, () -> sop.inlineDetach().message(bOut.toByteArray()).toByteArrayAndResult());
    }

    @Test
    public void detachBadDataFails() {
        byte[] bytes = "Hello, World\n".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(SOPGPException.BadData.class, () -> sop.inlineDetach().message(bytes).toByteArrayAndResult());
    }
}

