/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.OpenPGPKeyVersion;
import org.pgpainless.sop.SOPImpl;
import sop.SOP;

public class RevokeKeyTest {
    private static SOP sop;

    @BeforeAll
    public static void setup() {
        sop = new SOPImpl();
    }

    @Test
    public void revokeV6CertResultsInMinimalRevCert() throws IOException {
        PGPainless api = PGPainless.getInstance();
        OpenPGPKey v6Key = api.generateKey(OpenPGPKeyVersion.v6).modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        Assertions.assertEquals((int)3, (int)v6Key.getKeys().size());
        byte[] revoked = sop.revokeKey().keys(v6Key.getEncoded()).getBytes();
        OpenPGPCertificate revocationCert = api.readKey().parseCertificate(revoked);
        Assertions.assertEquals((int)1, (int)revocationCert.getKeys().size(), (String)"V6 keys are revoked using a minimal revocation cert, consisting only of the primary key and a rev sig.");
    }
}

