/*
 * Decompiled with CFR 0.152.
 */
package sop.testsuite.pgpainless.operation;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import sop.SOP;
import sop.testsuite.operation.RevokeKeyTest;

public class PGPainlessRevokeKeyTest
extends RevokeKeyTest {
    @ParameterizedTest
    @MethodSource(value={"provideInstances"})
    public void revokeUnprotectedKey(SOP sop) throws IOException {
        super.revokeUnprotectedKey(sop);
        byte[] key = sop.generateKey().generate().getBytes();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        byte[] revokedKey = sop.revokeKey().keys(key).getBytes();
        PGPKeyRing certificate = PGPainless.readKeyRing().keyRing(revokedKey);
        Assertions.assertFalse((boolean)(certificate instanceof PGPSecretKeyRing));
        Assertions.assertTrue((boolean)(certificate instanceof PGPPublicKeyRing));
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)certificate);
        Assertions.assertTrue((boolean)info.getRevocationState().isHardRevocation());
    }
}

