/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.sop.PasswordHelper;
import org.pgpainless.util.OpenPGPCertificateUtil;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.ChangeKeyPassword;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0001H\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/sop/ChangeKeyPasswordImpl;", "Lsop/operation/ChangeKeyPassword;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "armor", "", "newPassphrase", "Lorg/pgpainless/util/Passphrase;", "oldProtector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "keys", "Lsop/Ready;", "Ljava/io/InputStream;", "newKeyPassphrase", "", "noArmor", "oldKeyPassphrase", "oldPassphrase", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nChangeKeyPasswordImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeKeyPasswordImpl.kt\norg/pgpainless/sop/ChangeKeyPasswordImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n1549#2:84\n1620#2,3:85\n1#3:88\n*S KotlinDebug\n*F\n+ 1 ChangeKeyPasswordImpl.kt\norg/pgpainless/sop/ChangeKeyPasswordImpl\n*L\n39#1:80\n39#1:81,3\n56#1:84\n56#1:85,3\n*E\n"})
public final class ChangeKeyPasswordImpl
implements ChangeKeyPassword {
    @NotNull
    private final PGPainless api;
    @NotNull
    private final MatchMakingSecretKeyRingProtector oldProtector;
    @NotNull
    private Passphrase newPassphrase;
    private boolean armor;

    public ChangeKeyPasswordImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.oldProtector = new MatchMakingSecretKeyRingProtector();
        this.newPassphrase = Passphrase.Companion.emptyPassphrase();
        this.armor = true;
    }

    @NotNull
    public Ready keys(@NotNull InputStream keys2) {
        PGPSecretKeyRing it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<OpenPGPKey> list;
        Intrinsics.checkNotNullParameter((Object)keys2, (String)"keys");
        SecretKeyRingProtector newProtector = SecretKeyRingProtector.Companion.unlockAnyKeyWith(this.newPassphrase);
        try {
            list = new KeyReader(this.api).readSecretKeys(keys2, true);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData((Throwable)e);
        }
        List<OpenPGPKey> secretKeys = list;
        Iterable e = secretKeys;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PGPSecretKeyRing pGPSecretKeyRing;
            OpenPGPKey openPGPKey = (OpenPGPKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            this.oldProtector.addSecretKey((OpenPGPKey)it);
            try {
                PGPSecretKeyRing pGPSecretKeyRing2 = it.getPGPSecretKeyRing();
                Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing2, (String)"getPGPSecretKeyRing(...)");
                pGPSecretKeyRing = KeyRingUtils.Companion.changePassphrase(null, pGPSecretKeyRing2, (SecretKeyRingProtector)this.oldProtector, newProtector);
            }
            catch (MissingPassphraseException e2) {
                throw new SOPGPException.KeyIsProtected("Cannot unlock key " + it.getKeyIdentifier(), (Throwable)e2);
            }
            catch (PGPException e3) {
                String string = e3.getMessage();
                boolean bl2 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Exception decrypting key", (boolean)false, (int)2, null) : false;
                if (bl2) {
                    throw new SOPGPException.KeyIsProtected("Cannot unlock key " + it.getKeyIdentifier(), (Throwable)e3);
                }
                throw new RuntimeException("Cannot change passphrase of key " + it.getKeyIdentifier(), e3);
            }
            collection.add(pGPSecretKeyRing);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PGPSecretKeyRing)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.api.toKey(it));
        }
        List updatedSecretKeys = (List)destination$iv$iv;
        return new Ready(this, updatedSecretKeys){
            final /* synthetic */ ChangeKeyPasswordImpl this$0;
            final /* synthetic */ List<OpenPGPKey> $updatedSecretKeys;
            {
                this.this$0 = $receiver;
                this.$updatedSecretKeys = $updatedSecretKeys;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                if (ChangeKeyPasswordImpl.access$getArmor$p(this.this$0)) {
                    OpenPGPCertificateUtil.Companion.armor$default((OpenPGPCertificateUtil.Companion)OpenPGPCertificateUtil.Companion, (Collection)this.$updatedSecretKeys, (OutputStream)outputStream, null, (int)4, null);
                } else {
                    OpenPGPCertificateUtil.Companion.encode$default((OpenPGPCertificateUtil.Companion)OpenPGPCertificateUtil.Companion, (Collection)this.$updatedSecretKeys, (OutputStream)outputStream, null, (int)4, null);
                }
            }
        };
    }

    @NotNull
    public ChangeKeyPassword newKeyPassphrase(@NotNull String newPassphrase) {
        ChangeKeyPasswordImpl changeKeyPasswordImpl;
        Intrinsics.checkNotNullParameter((Object)newPassphrase, (String)"newPassphrase");
        ChangeKeyPasswordImpl $this$newKeyPassphrase_u24lambda_u242 = changeKeyPasswordImpl = this;
        boolean bl = false;
        $this$newKeyPassphrase_u24lambda_u242.newPassphrase = Passphrase.Companion.fromPassword((CharSequence)newPassphrase);
        return changeKeyPasswordImpl;
    }

    @NotNull
    public ChangeKeyPassword noArmor() {
        ChangeKeyPasswordImpl changeKeyPasswordImpl;
        ChangeKeyPasswordImpl $this$noArmor_u24lambda_u243 = changeKeyPasswordImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u243.armor = false;
        return changeKeyPasswordImpl;
    }

    @NotNull
    public ChangeKeyPassword oldKeyPassphrase(@NotNull String oldPassphrase) {
        ChangeKeyPasswordImpl changeKeyPasswordImpl;
        Intrinsics.checkNotNullParameter((Object)oldPassphrase, (String)"oldPassphrase");
        ChangeKeyPasswordImpl $this$oldKeyPassphrase_u24lambda_u244 = changeKeyPasswordImpl = this;
        boolean bl = false;
        PasswordHelper.Companion.addPassphrasePlusRemoveWhitespace(oldPassphrase, $this$oldKeyPassphrase_u24lambda_u244.oldProtector);
        return changeKeyPasswordImpl;
    }

    public static final /* synthetic */ boolean access$getArmor$p(ChangeKeyPasswordImpl $this) {
        return $this.armor;
    }
}

