/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.VerificationHelper;
import sop.ReadyWithResult;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.operation.InlineVerify;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/sop/InlineVerifyImpl;", "Lsop/operation/InlineVerify;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "options", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "cert", "Ljava/io/InputStream;", "data", "Lsop/ReadyWithResult;", "", "Lsop/Verification;", "notAfter", "timestamp", "Ljava/util/Date;", "notBefore", "pgpainless-sop"})
public final class InlineVerifyImpl
implements InlineVerify {
    @NotNull
    private final PGPainless api;
    @NotNull
    private final ConsumerOptions options;

    public InlineVerifyImpl(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.options = ConsumerOptions.Companion.get(this.api);
    }

    @NotNull
    public InlineVerify cert(@NotNull InputStream cert) {
        InlineVerifyImpl inlineVerifyImpl;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        InlineVerifyImpl $this$cert_u24lambda_u240 = inlineVerifyImpl = this;
        boolean bl = false;
        $this$cert_u24lambda_u240.options.addVerificationCerts((Collection)new KeyReader($this$cert_u24lambda_u240.api).readPublicKeys(cert, true));
        return inlineVerifyImpl;
    }

    @NotNull
    public ReadyWithResult<List<Verification>> data(@NotNull InputStream data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (ReadyWithResult)new ReadyWithResult<List<? extends Verification>>(this, data2){
            final /* synthetic */ InlineVerifyImpl this$0;
            final /* synthetic */ InputStream $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<Verification> writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    DecryptionStream verificationStream = InlineVerifyImpl.access$getApi$p(this.this$0).processMessage().onInputStream(this.$data).withOptions(InlineVerifyImpl.access$getOptions$p(this.this$0));
                    Streams.pipeAll((InputStream)((InputStream)verificationStream), (OutputStream)outputStream);
                    verificationStream.close();
                    MessageMetadata result = verificationStream.getMetadata();
                    Iterable iterable = result.isUsingCleartextSignatureFramework() ? result.getVerifiedDetachedSignatures() : result.getVerifiedInlineSignatures();
                    boolean $i$f$map = false;
                    void var7_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        SignatureVerification signatureVerification = (SignatureVerification)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(VerificationHelper.Companion.mapVerification((SignatureVerification)it));
                    }
                    List verifications = (List)destination$iv$iv;
                    if (!((Collection)InlineVerifyImpl.access$getOptions$p(this.this$0).getCertificateSource().getExplicitCertificates()).isEmpty() && verifications.isEmpty()) {
                        throw new SOPGPException.NoSignature(null, 1, null);
                    }
                    return verifications;
                }
                catch (MissingDecryptionMethodException e) {
                    throw new SOPGPException.BadData("Cannot verify encrypted message.", (Throwable)e);
                }
                catch (MalformedOpenPgpMessageException e) {
                    throw new SOPGPException.BadData((Throwable)e);
                }
                catch (PGPException e) {
                    throw new SOPGPException.BadData((Throwable)e);
                }
            }
        };
    }

    @NotNull
    public InlineVerify notAfter(@NotNull Date timestamp) {
        InlineVerifyImpl inlineVerifyImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        InlineVerifyImpl $this$notAfter_u24lambda_u241 = inlineVerifyImpl = this;
        boolean bl = false;
        $this$notAfter_u24lambda_u241.options.verifyNotAfter(timestamp);
        return inlineVerifyImpl;
    }

    @NotNull
    public InlineVerify notBefore(@NotNull Date timestamp) {
        InlineVerifyImpl inlineVerifyImpl;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        InlineVerifyImpl $this$notBefore_u24lambda_u242 = inlineVerifyImpl = this;
        boolean bl = false;
        $this$notBefore_u24lambda_u242.options.verifyNotBefore(timestamp);
        return inlineVerifyImpl;
    }

    public static final /* synthetic */ PGPainless access$getApi$p(InlineVerifyImpl $this) {
        return $this.api;
    }

    public static final /* synthetic */ ConsumerOptions access$getOptions$p(InlineVerifyImpl $this) {
        return $this.options;
    }
}

