/*
 * Decompiled with CFR 0.152.
 */
package org.gnupg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.gnupg.GnuPGDummyExtension;
import org.pgpainless.key.SubkeyIdentifier;

public final class GnuPGDummyKeyUtil {
    private GnuPGDummyKeyUtil() {
    }

    public static Set<SubkeyIdentifier> getIdsOfKeysWithGnuPGS2KDivertedToCard(@Nonnull PGPSecretKeyRing secretKeys) {
        HashSet<SubkeyIdentifier> hardwareBackedKeys = new HashSet<SubkeyIdentifier>();
        for (PGPSecretKey secretKey : secretKeys) {
            S2K s2K = secretKey.getS2K();
            if (s2K == null) continue;
            int type = s2K.getType();
            int mode = s2K.getProtectionMode();
            if (type != 101 || mode != 2) continue;
            SubkeyIdentifier hardwareBackedKey = new SubkeyIdentifier((PGPKeyRing)secretKeys, secretKey.getKeyID());
            hardwareBackedKeys.add(hardwareBackedKey);
        }
        return hardwareBackedKeys;
    }

    public static Builder modify(@Nonnull PGPSecretKeyRing secretKeys) {
        return new Builder(secretKeys);
    }

    @FunctionalInterface
    public static interface KeyFilter {
        public boolean filter(long var1);

        public static KeyFilter any() {
            return keyId -> true;
        }

        public static KeyFilter only(long onlyKeyId) {
            return keyId -> keyId == onlyKeyId;
        }

        public static KeyFilter selected(Collection<Long> ids) {
            return keyId -> ids.contains(keyId);
        }
    }

    public static final class Builder {
        private final PGPSecretKeyRing keys;

        private Builder(@Nonnull PGPSecretKeyRing keys2) {
            this.keys = keys2;
        }

        public PGPSecretKeyRing removePrivateKeys(@Nonnull KeyFilter filter) {
            return this.replacePrivateKeys(GnuPGDummyExtension.NO_PRIVATE_KEY, null, filter);
        }

        public PGPSecretKeyRing divertPrivateKeysToCard(@Nonnull KeyFilter filter) {
            return this.divertPrivateKeysToCard(filter, new byte[16]);
        }

        public PGPSecretKeyRing divertPrivateKeysToCard(@Nonnull KeyFilter filter, @Nullable byte[] cardSerialNumber) {
            if (cardSerialNumber != null && cardSerialNumber.length > 16) {
                throw new IllegalArgumentException("Card serial number length cannot exceed 16 bytes.");
            }
            return this.replacePrivateKeys(GnuPGDummyExtension.DIVERT_TO_CARD, cardSerialNumber, filter);
        }

        private PGPSecretKeyRing replacePrivateKeys(@Nonnull GnuPGDummyExtension extension, @Nullable byte[] serial, @Nonnull KeyFilter filter) {
            byte[] encodedSerial = serial != null ? this.encodeSerial(serial) : null;
            S2K s2k = this.extensionToS2K(extension);
            ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
            for (PGPSecretKey secretKey : this.keys) {
                PGPSecretKey onCard;
                SecretKeyPacket keyPacket;
                if (!filter.filter(secretKey.getKeyID())) {
                    secretKeyList.add(secretKey);
                    continue;
                }
                PublicKeyPacket publicKeyPacket = secretKey.getPublicKey().getPublicKeyPacket();
                if (secretKey.isMasterKey()) {
                    keyPacket = new SecretKeyPacket(publicKeyPacket, 0, 254, s2k, null, encodedSerial);
                    onCard = new PGPSecretKey(keyPacket, secretKey.getPublicKey());
                    secretKeyList.add(onCard);
                    continue;
                }
                keyPacket = new SecretSubkeyPacket(publicKeyPacket, 0, 254, s2k, null, encodedSerial);
                onCard = new PGPSecretKey(keyPacket, secretKey.getPublicKey());
                secretKeyList.add(onCard);
            }
            return new PGPSecretKeyRing(secretKeyList);
        }

        private byte[] encodeSerial(@Nonnull byte[] serial) {
            byte[] encoded = new byte[serial.length + 1];
            encoded[0] = (byte)(serial.length & 0xFF);
            System.arraycopy(serial, 0, encoded, 1, serial.length);
            return encoded;
        }

        private S2K extensionToS2K(@Nonnull GnuPGDummyExtension extension) {
            return S2K.gnuDummyS2K(extension == GnuPGDummyExtension.DIVERT_TO_CARD ? S2K.GNUDummyParams.divertToCard() : S2K.GNUDummyParams.noPrivateKey());
        }
    }
}

