/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.certificate_store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.pgpainless.key.OpenPgpFingerprint;
import pgp.certificate_store.certificate.Certificate;

public class CertificateFactory {
    public static Certificate certificateFromPublicKeyRing(PGPPublicKeyRing publicKeyRing, Long tag) throws IOException {
        byte[] bytes = publicKeyRing.getEncoded();
        String fingerprint = OpenPgpFingerprint.of(publicKeyRing).toString().toLowerCase();
        ArrayList<Long> subkeyIds = new ArrayList<Long>();
        Iterator<PGPPublicKey> keys2 = publicKeyRing.getPublicKeys();
        while (keys2.hasNext()) {
            subkeyIds.add(keys2.next().getKeyID());
        }
        return new Certificate(bytes, fingerprint, subkeyIds, tag);
    }
}

