/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.decryption_verification.cleartext_signatures.InMemoryMultiPassStrategy;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.SessionKey;

public class ConsumerOptions {
    private boolean ignoreMDCErrors = false;
    private boolean forceNonOpenPgpData = false;
    private Date verifyNotBefore = null;
    private Date verifyNotAfter = new Date();
    private final CertificateSource certificates = new CertificateSource();
    private final Set<PGPSignature> detachedSignatures = new HashSet<PGPSignature>();
    private MissingPublicKeyCallback missingCertificateCallback = null;
    private SessionKey sessionKey = null;
    private final Map<SubkeyIdentifier, PublicKeyDataDecryptorFactory> customPublicKeyDataDecryptorFactories = new HashMap<SubkeyIdentifier, PublicKeyDataDecryptorFactory>();
    private final Map<PGPSecretKeyRing, SecretKeyRingProtector> decryptionKeys = new HashMap<PGPSecretKeyRing, SecretKeyRingProtector>();
    private final Set<Passphrase> decryptionPassphrases = new HashSet<Passphrase>();
    private MissingKeyPassphraseStrategy missingKeyPassphraseStrategy = MissingKeyPassphraseStrategy.INTERACTIVE;
    private MultiPassStrategy multiPassStrategy = new InMemoryMultiPassStrategy();

    public static ConsumerOptions get() {
        return new ConsumerOptions();
    }

    public ConsumerOptions verifyNotBefore(Date timestamp2) {
        this.verifyNotBefore = timestamp2;
        return this;
    }

    @Nullable
    public Date getVerifyNotBefore() {
        return this.verifyNotBefore;
    }

    public ConsumerOptions verifyNotAfter(Date timestamp2) {
        this.verifyNotAfter = timestamp2;
        return this;
    }

    public Date getVerifyNotAfter() {
        return this.verifyNotAfter;
    }

    public ConsumerOptions addVerificationCert(PGPPublicKeyRing verificationCert) {
        this.certificates.addCertificate(verificationCert);
        return this;
    }

    public ConsumerOptions addVerificationCerts(PGPPublicKeyRingCollection verificationCerts) {
        for (PGPPublicKeyRing certificate : verificationCerts) {
            this.addVerificationCert(certificate);
        }
        return this;
    }

    public ConsumerOptions addVerificationOfDetachedSignatures(InputStream signatureInputStream) throws IOException, PGPException {
        List<PGPSignature> signatures = SignatureUtils.readSignatures(signatureInputStream);
        return this.addVerificationOfDetachedSignatures(signatures);
    }

    public ConsumerOptions addVerificationOfDetachedSignatures(List<PGPSignature> detachedSignatures) {
        for (PGPSignature signature : detachedSignatures) {
            this.addVerificationOfDetachedSignature(signature);
        }
        return this;
    }

    public ConsumerOptions addVerificationOfDetachedSignature(PGPSignature detachedSignature) {
        this.detachedSignatures.add(detachedSignature);
        return this;
    }

    public ConsumerOptions setMissingCertificateCallback(MissingPublicKeyCallback callback) {
        this.missingCertificateCallback = callback;
        return this;
    }

    public ConsumerOptions setSessionKey(@Nonnull SessionKey sessionKey) {
        this.sessionKey = sessionKey;
        return this;
    }

    @Nullable
    public SessionKey getSessionKey() {
        return this.sessionKey;
    }

    public ConsumerOptions addDecryptionKey(@Nonnull PGPSecretKeyRing key) {
        return this.addDecryptionKey(key, SecretKeyRingProtector.unprotectedKeys());
    }

    public ConsumerOptions addDecryptionKey(@Nonnull PGPSecretKeyRing key, @Nonnull SecretKeyRingProtector keyRingProtector) {
        this.decryptionKeys.put(key, keyRingProtector);
        return this;
    }

    public ConsumerOptions addDecryptionKeys(@Nonnull PGPSecretKeyRingCollection keys2, @Nonnull SecretKeyRingProtector keyRingProtector) {
        for (PGPSecretKeyRing key : keys2) {
            this.addDecryptionKey(key, keyRingProtector);
        }
        return this;
    }

    public ConsumerOptions addDecryptionPassphrase(@Nonnull Passphrase passphrase) {
        this.decryptionPassphrases.add(passphrase);
        return this;
    }

    public ConsumerOptions addCustomDecryptorFactory(@Nonnull CustomPublicKeyDataDecryptorFactory factory) {
        this.customPublicKeyDataDecryptorFactories.put(factory.getSubkeyIdentifier(), factory);
        return this;
    }

    Map<SubkeyIdentifier, PublicKeyDataDecryptorFactory> getCustomDecryptorFactories() {
        return new HashMap<SubkeyIdentifier, PublicKeyDataDecryptorFactory>(this.customPublicKeyDataDecryptorFactories);
    }

    @Nonnull
    public Set<PGPSecretKeyRing> getDecryptionKeys() {
        return Collections.unmodifiableSet(this.decryptionKeys.keySet());
    }

    @Nonnull
    public Set<Passphrase> getDecryptionPassphrases() {
        return Collections.unmodifiableSet(this.decryptionPassphrases);
    }

    @Deprecated
    @Nonnull
    public Set<PGPPublicKeyRing> getCertificates() {
        return this.certificates.getExplicitCertificates();
    }

    @Nonnull
    public CertificateSource getCertificateSource() {
        return this.certificates;
    }

    @Nullable
    public MissingPublicKeyCallback getMissingCertificateCallback() {
        return this.missingCertificateCallback;
    }

    @Nonnull
    public SecretKeyRingProtector getSecretKeyProtector(PGPSecretKeyRing decryptionKeyRing) {
        return this.decryptionKeys.get(decryptionKeyRing);
    }

    @Nonnull
    public Set<PGPSignature> getDetachedSignatures() {
        return Collections.unmodifiableSet(this.detachedSignatures);
    }

    @Deprecated
    public ConsumerOptions setIgnoreMDCErrors(boolean ignoreMDCErrors) {
        this.ignoreMDCErrors = ignoreMDCErrors;
        return this;
    }

    boolean isIgnoreMDCErrors() {
        return this.ignoreMDCErrors;
    }

    public ConsumerOptions forceNonOpenPgpData() {
        this.forceNonOpenPgpData = true;
        return this;
    }

    boolean isForceNonOpenPgpData() {
        return this.forceNonOpenPgpData;
    }

    public ConsumerOptions setMissingKeyPassphraseStrategy(MissingKeyPassphraseStrategy strategy) {
        this.missingKeyPassphraseStrategy = strategy;
        return this;
    }

    MissingKeyPassphraseStrategy getMissingKeyPassphraseStrategy() {
        return this.missingKeyPassphraseStrategy;
    }

    public ConsumerOptions setMultiPassStrategy(@Nonnull MultiPassStrategy multiPassStrategy) {
        this.multiPassStrategy = multiPassStrategy;
        return this;
    }

    public MultiPassStrategy getMultiPassStrategy() {
        return this.multiPassStrategy;
    }

    public static class CertificateSource {
        private Set<PGPPublicKeyRing> explicitCertificates = new HashSet<PGPPublicKeyRing>();

        public void addCertificate(PGPPublicKeyRing certificate) {
            this.explicitCertificates.add(certificate);
        }

        public Set<PGPPublicKeyRing> getExplicitCertificates() {
            return Collections.unmodifiableSet(this.explicitCertificates);
        }

        public PGPPublicKeyRing getCertificate(long keyId) {
            for (PGPPublicKeyRing cert : this.explicitCertificates) {
                if (cert.getPublicKey(keyId) == null) continue;
                return cert;
            }
            return null;
        }
    }
}

