/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.authentication.CertificateAuthenticity;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.wot.PGPNetworkParser;
import org.pgpainless.wot.api.AuthenticateAPI;
import org.pgpainless.wot.api.Binding;
import org.pgpainless.wot.api.IdentifyAPI;
import org.pgpainless.wot.api.LookupAPI;
import org.pgpainless.wot.api.WebOfTrustAPI;
import org.pgpainless.wot.network.EdgeComponent;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.ReferenceTime;
import org.pgpainless.wot.network.Roots;
import org.pgpainless.wot.query.Path;
import pgp.certificate_store.PGPCertificateStore;
import pgp.certificate_store.certificate.Certificate;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/wot/CertificateAuthorityImpl;", "Lorg/pgpainless/authentication/CertificateAuthority;", "network", "Lorg/pgpainless/wot/network/Network;", "trustRoots", "Lorg/pgpainless/wot/network/Roots;", "certificateStore", "Lpgp/certificate_store/PGPCertificateStore;", "(Lorg/pgpainless/wot/network/Network;Lorg/pgpainless/wot/network/Roots;Lpgp/certificate_store/PGPCertificateStore;)V", "authenticateBinding", "Lorg/pgpainless/authentication/CertificateAuthenticity;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "userId", "", "email", "", "referenceTime", "Ljava/util/Date;", "targetAmount", "", "identifyByFingerprint", "", "lookupByUserId", "mapToAuthenticity", "binding", "Lorg/pgpainless/wot/api/Binding;", "readPublicKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "Lorg/pgpainless/wot/network/Fingerprint;", "Companion", "pgpainless-wot"})
@SourceDebugExtension(value={"SMAP\nCertificateAuthorityImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateAuthorityImpl.kt\norg/pgpainless/wot/CertificateAuthorityImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1549#2:100\n1620#2,3:101\n1549#2:104\n1620#2,3:105\n*S KotlinDebug\n*F\n+ 1 CertificateAuthorityImpl.kt\norg/pgpainless/wot/CertificateAuthorityImpl\n*L\n66#1:100\n66#1:101,3\n73#1:104\n73#1:105,3\n*E\n"})
public final class CertificateAuthorityImpl
implements CertificateAuthority {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Network network;
    @NotNull
    private final Roots trustRoots;
    @NotNull
    private final PGPCertificateStore certificateStore;

    public CertificateAuthorityImpl(@NotNull Network network, @NotNull Roots trustRoots2, @NotNull PGPCertificateStore certificateStore) {
        Intrinsics.checkNotNullParameter(network, "network");
        Intrinsics.checkNotNullParameter(trustRoots2, "trustRoots");
        Intrinsics.checkNotNullParameter(certificateStore, "certificateStore");
        this.network = network;
        this.trustRoots = trustRoots2;
        this.certificateStore = certificateStore;
    }

    @Override
    @NotNull
    public CertificateAuthenticity authenticateBinding(@NotNull OpenPgpFingerprint fingerprint, @NotNull String userId, boolean email, @NotNull Date referenceTime, int targetAmount) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
        WebOfTrustAPI api = new WebOfTrustAPI(this.network, this.trustRoots, false, false, targetAmount, ReferenceTime.Companion.timestamp(referenceTime));
        String string = fingerprint.toString();
        Intrinsics.checkNotNullExpressionValue(string, "fingerprint.toString()");
        AuthenticateAPI.Result result = api.authenticate(new Fingerprint(string), userId, email);
        return this.mapToAuthenticity(result.getBinding(), targetAmount);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CertificateAuthenticity> lookupByUserId(@NotNull String userId, boolean email, @NotNull Date referenceTime, int targetAmount) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
        WebOfTrustAPI api = new WebOfTrustAPI(this.network, this.trustRoots, false, false, targetAmount, ReferenceTime.Companion.timestamp(referenceTime));
        LookupAPI.Result result = api.lookup(userId, email);
        Iterable $this$map$iv = result.getBindings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Binding binding = (Binding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapToAuthenticity((Binding)it, targetAmount));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CertificateAuthenticity> identifyByFingerprint(@NotNull OpenPgpFingerprint fingerprint, @NotNull Date referenceTime, int targetAmount) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
        WebOfTrustAPI api = new WebOfTrustAPI(this.network, this.trustRoots, false, false, targetAmount, ReferenceTime.Companion.timestamp(referenceTime));
        String string = fingerprint.toString();
        Intrinsics.checkNotNullExpressionValue(string, "fingerprint.toString()");
        IdentifyAPI.Result result = api.identify(new Fingerprint(string));
        Iterable $this$map$iv = result.getBindings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Binding binding = (Binding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapToAuthenticity((Binding)it, targetAmount));
        }
        return (List)destination$iv$iv;
    }

    private final CertificateAuthenticity mapToAuthenticity(Binding binding, int targetAmount) {
        PGPPublicKeyRing publicKeyRing = this.readPublicKeyRing(binding.getFingerprint());
        Map certificationChains = new LinkedHashMap();
        for (Map.Entry<Path, Integer> entry : binding.getPaths().getItems()) {
            Path path = entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            List links = new ArrayList();
            links.add(new CertificateAuthenticity.ChainLink(this.readPublicKeyRing(path.getRoot().getFingerprint())));
            for (EdgeComponent edge : path.getCertifications()) {
                PGPPublicKeyRing target = this.readPublicKeyRing(edge.getTarget().getFingerprint());
                links.add(new CertificateAuthenticity.ChainLink(target));
            }
            Integer n = amount;
            certificationChains.put(new CertificateAuthenticity.CertificationChain(path.getAmount(), links), n);
        }
        return new CertificateAuthenticity(publicKeyRing, binding.getUserId(), certificationChains, targetAmount);
    }

    private final PGPPublicKeyRing readPublicKeyRing(Fingerprint fingerprint) {
        Certificate certificate = this.certificateStore.getCertificate(fingerprint.toString());
        PGPPublicKeyRing pGPPublicKeyRing = PGPainless.readKeyRing().publicKeyRing(certificate.getInputStream());
        Intrinsics.checkNotNull(pGPPublicKeyRing);
        return pGPPublicKeyRing;
    }

    @JvmStatic
    @NotNull
    public static final CertificateAuthorityImpl webOfTrustFromCertificateStore(@NotNull PGPCertificateStore certificateStore, @NotNull Roots trustRoots2, @NotNull Date referenceTime) {
        return Companion.webOfTrustFromCertificateStore(certificateStore, trustRoots2, referenceTime);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/wot/CertificateAuthorityImpl$Companion;", "", "()V", "webOfTrustFromCertificateStore", "Lorg/pgpainless/wot/CertificateAuthorityImpl;", "certificateStore", "Lpgp/certificate_store/PGPCertificateStore;", "trustRoots", "Lorg/pgpainless/wot/network/Roots;", "referenceTime", "Ljava/util/Date;", "pgpainless-wot"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CertificateAuthorityImpl webOfTrustFromCertificateStore(@NotNull PGPCertificateStore certificateStore, @NotNull Roots trustRoots2, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter(certificateStore, "certificateStore");
            Intrinsics.checkNotNullParameter(trustRoots2, "trustRoots");
            Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
            Network network = PGPNetworkParser.buildNetwork$default(new PGPNetworkParser(certificateStore), null, ReferenceTime.Companion.timestamp(referenceTime), 1, null);
            return new CertificateAuthorityImpl(network, trustRoots2, certificateStore);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

