/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.certificate_store.CertificateFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.parsing.KeyRingReader;
import pgp.certificate_store.PGPCertificateStore;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.certificate.KeyMaterialMerger;
import pgp.certificate_store.exception.BadNameException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J!\u0010\u000e\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016J\u001c\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J&\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/pgpainless/wot/KeyRingCertificateStore;", "Lpgp/certificate_store/PGPCertificateStore;", "baseKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;)V", "baseKeyRings", "", "(Ljava/util/List;)V", "certificates", "", "", "Lpgp/certificate_store/certificate/Certificate;", "getCertificate", "identifier", "getCertificateIfChanged", "tag", "", "(Ljava/lang/String;Ljava/lang/Long;)Lpgp/certificate_store/certificate/Certificate;", "getCertificates", "", "getCertificatesBySubkeyId", "subkeyId", "getFingerprints", "insertCertificate", "data", "Ljava/io/InputStream;", "merge", "Lpgp/certificate_store/certificate/KeyMaterialMerger;", "insertCertificateBySpecialName", "specialName", "pgpainless-wot"})
@SourceDebugExtension(value={"SMAP\nKeyRingCertificateStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyRingCertificateStore.kt\norg/pgpainless/wot/KeyRingCertificateStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1855#2:120\n1855#2,2:121\n1856#2:123\n766#2:124\n857#2,2:125\n1549#2:127\n1620#2,3:128\n*S KotlinDebug\n*F\n+ 1 KeyRingCertificateStore.kt\norg/pgpainless/wot/KeyRingCertificateStore\n*L\n34#1:120\n35#1:121,2\n34#1:123\n60#1:124\n60#1:125,2\n115#1:127\n115#1:128,3\n*E\n"})
public final class KeyRingCertificateStore
implements PGPCertificateStore {
    @NotNull
    private final Map<String, Certificate> certificates;

    public KeyRingCertificateStore(@NotNull List<? extends PGPPublicKeyRingCollection> baseKeyRings) {
        Intrinsics.checkNotNullParameter(baseKeyRings, "baseKeyRings");
        this.certificates = new LinkedHashMap();
        Iterable $this$forEach$iv = baseKeyRings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPPublicKeyRingCollection store = (PGPPublicKeyRingCollection)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = store;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String fingerprint;
                PGPPublicKeyRing it = (PGPPublicKeyRing)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(OpenPgpFingerprint.of(it).toString(), "of(it).toString()");
                Certificate certificate = CertificateFactory.certificateFromPublicKeyRing(it, null);
                Intrinsics.checkNotNullExpressionValue(certificate, "certificate");
                this.certificates.put(fingerprint, certificate);
            }
        }
    }

    public KeyRingCertificateStore(@NotNull PGPPublicKeyRingCollection baseKeyRing) {
        Intrinsics.checkNotNullParameter(baseKeyRing, "baseKeyRing");
        this(CollectionsKt.listOf(baseKeyRing));
    }

    @Override
    @NotNull
    public Certificate getCertificate(@Nullable String identifier) {
        if (identifier == null) {
            throw new BadNameException("Identifier MUST NOT be null.");
        }
        Certificate certificate = this.certificates.get(identifier);
        if (certificate == null) {
            boolean bl = false;
            throw new NoSuchElementException("No certificate for identifier " + identifier + " found.");
        }
        return certificate;
    }

    @Override
    @NotNull
    public Certificate getCertificateIfChanged(@Nullable String identifier, @Nullable Long tag) {
        return this.getCertificate(identifier);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Certificate> getCertificatesBySubkeyId(long subkeyId) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.certificates.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Certificate it = (Certificate)element$iv$iv;
            boolean bl = false;
            if (!it.getSubkeyIds().contains(subkeyId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toMutableList((List)destination$iv$iv).listIterator();
    }

    @Override
    @NotNull
    public Certificate insertCertificate(@Nullable InputStream data, @Nullable KeyMaterialMerger merge) {
        Certificate insert;
        Certificate certificate;
        PGPPublicKeyRing publicKeys;
        KeyRingReader keyRingReader = PGPainless.readKeyRing();
        InputStream inputStream = data;
        Intrinsics.checkNotNull(inputStream);
        PGPPublicKeyRing pGPPublicKeyRing = publicKeys = keyRingReader.publicKeyRing(inputStream);
        Intrinsics.checkNotNull(pGPPublicKeyRing);
        Certificate certificate2 = CertificateFactory.certificateFromPublicKeyRing(pGPPublicKeyRing, null);
        if (merge != null) {
            Certificate certificate3;
            try {
                certificate3 = this.getCertificate(certificate2.getFingerprint());
            }
            catch (NoSuchElementException e) {
                certificate3 = null;
            }
            Certificate existing = certificate3;
            certificate = merge.merge(certificate2, existing).asCertificate();
        } else {
            certificate = insert = certificate2;
        }
        if (insert == null) {
            Intrinsics.checkNotNullExpressionValue(certificate2, "certificate");
            return certificate2;
        }
        Map<String, Certificate> map = this.certificates;
        String string = insert.getFingerprint();
        Intrinsics.checkNotNullExpressionValue(string, "insert.fingerprint");
        map.put(string, insert);
        return insert;
    }

    @Override
    @NotNull
    public Certificate insertCertificateBySpecialName(@Nullable String specialName, @Nullable InputStream data, @Nullable KeyMaterialMerger merge) {
        Certificate insert;
        Certificate certificate;
        PGPPublicKeyRing publicKeys;
        KeyRingReader keyRingReader = PGPainless.readKeyRing();
        InputStream inputStream = data;
        Intrinsics.checkNotNull(inputStream);
        PGPPublicKeyRing pGPPublicKeyRing = publicKeys = keyRingReader.publicKeyRing(inputStream);
        Intrinsics.checkNotNull(pGPPublicKeyRing);
        Certificate certificate2 = CertificateFactory.certificateFromPublicKeyRing(pGPPublicKeyRing, null);
        if (merge != null) {
            Certificate certificate3;
            try {
                String string = specialName;
                Intrinsics.checkNotNull(string);
                certificate3 = this.getCertificate(string);
            }
            catch (NoSuchElementException e) {
                certificate3 = null;
            }
            Certificate existing = certificate3;
            certificate = merge.merge(certificate2, existing).asCertificate();
        } else {
            certificate = insert = certificate2;
        }
        if (insert == null) {
            Intrinsics.checkNotNullExpressionValue(certificate2, "certificate");
            return certificate2;
        }
        String string = specialName;
        Intrinsics.checkNotNull(string);
        this.certificates.put(string, insert);
        return insert;
    }

    @Override
    @NotNull
    public Iterator<Certificate> getCertificates() {
        return this.certificates.values().iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<String> getFingerprints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.certificates.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFingerprint());
        }
        return CollectionsKt.toMutableList((List)destination$iv$iv).listIterator();
    }
}

