/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.cli;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.certificate_store.PGPainlessCertD;
import org.pgpainless.wot.KeyRingCertificateStore;
import org.pgpainless.wot.PGPNetworkParser;
import org.pgpainless.wot.SugarKt;
import org.pgpainless.wot.api.WebOfTrustAPI;
import org.pgpainless.wot.cli.GpgHelper;
import org.pgpainless.wot.cli.WebOfTrustCLI;
import org.pgpainless.wot.cli.converters.ReferenceTimeConverter;
import org.pgpainless.wot.cli.converters.RootConverter;
import org.pgpainless.wot.cli.format.Formatter;
import org.pgpainless.wot.cli.format.SQWOTFormatter;
import org.pgpainless.wot.cli.subcommands.AuthenticateCmd;
import org.pgpainless.wot.cli.subcommands.IdentifyCmd;
import org.pgpainless.wot.cli.subcommands.ListCmd;
import org.pgpainless.wot.cli.subcommands.LookupCmd;
import org.pgpainless.wot.cli.subcommands.PathCmd;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.ReferenceTime;
import org.pgpainless.wot.network.Root;
import org.pgpainless.wot.network.Roots;
import pgp.cert_d.BaseDirectoryProvider;
import pgp.cert_d.PGPCertificateStoreAdapter;
import pgp.cert_d.subkey_lookup.InMemorySubkeyLookupFactory;
import pgp.certificate_store.PGPCertificateStore;
import pgp.certificate_store.certificate.Certificate;
import picocli.CommandLine;

@CommandLine.Command(name="pgpainless-wot", subcommands={AuthenticateCmd.class, IdentifyCmd.class, ListCmd.class, LookupCmd.class, PathCmd.class, CommandLine.HelpCommand.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 ?2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003>?@B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010;\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001e\u0010\u0011\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001e\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020#8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001e\u0010&\u001a\u00020'8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u00103\u001a\u000204\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006A"}, d2={"Lorg/pgpainless/wot/cli/WebOfTrustCLI;", "Ljava/util/concurrent/Callable;", "", "()V", "api", "Lorg/pgpainless/wot/api/WebOfTrustAPI;", "getApi", "()Lorg/pgpainless/wot/api/WebOfTrustAPI;", "optCertificationNetwork", "", "getOptCertificationNetwork", "()Z", "setOptCertificationNetwork", "(Z)V", "optGossip", "getOptGossip", "setOptGossip", "optGpgOwnerTrust", "getOptGpgOwnerTrust", "setOptGpgOwnerTrust", "optKeyRing", "Lorg/pgpainless/wot/cli/WebOfTrustCLI$CertificateSource;", "getOptKeyRing", "()Lorg/pgpainless/wot/cli/WebOfTrustCLI$CertificateSource;", "setOptKeyRing", "(Lorg/pgpainless/wot/cli/WebOfTrustCLI$CertificateSource;)V", "optKnownNotations", "", "", "getOptKnownNotations", "()[Ljava/lang/String;", "setOptKnownNotations", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "optReferenceTime", "Lorg/pgpainless/wot/network/ReferenceTime;", "getOptReferenceTime", "()Lorg/pgpainless/wot/network/ReferenceTime;", "optTrustAmount", "Lorg/pgpainless/wot/cli/WebOfTrustCLI$TrustAmount;", "getOptTrustAmount", "()Lorg/pgpainless/wot/cli/WebOfTrustCLI$TrustAmount;", "setOptTrustAmount", "(Lorg/pgpainless/wot/cli/WebOfTrustCLI$TrustAmount;)V", "optTrustRoot", "", "Lorg/pgpainless/wot/network/Root;", "getOptTrustRoot", "()Ljava/util/List;", "setOptTrustRoot", "(Ljava/util/List;)V", "outputFormatter", "Lorg/pgpainless/wot/cli/format/Formatter;", "getOutputFormatter", "()Lorg/pgpainless/wot/cli/format/Formatter;", "trustRoots", "Lorg/pgpainless/wot/network/Roots;", "getTrustRoots", "()Lorg/pgpainless/wot/network/Roots;", "call", "()Ljava/lang/Integer;", "toString", "CertificateSource", "Companion", "TrustAmount", "pgpainless-wot-cli"})
@SourceDebugExtension(value={"SMAP\nWebOfTrustCLI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebOfTrustCLI.kt\norg/pgpainless/wot/cli/WebOfTrustCLI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class WebOfTrustCLI
implements Callable<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Option(names={"--trust-root", "-r"}, description={"One or more certificates to use as trust-roots."}, paramLabel="FINGERPRINT", converter={RootConverter.class})
    @NotNull
    private List<Root> optTrustRoot = CollectionsKt.emptyList();
    @CommandLine.ArgGroup(exclusive=true)
    @NotNull
    private TrustAmount optTrustAmount = new TrustAmount();
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    public CertificateSource optKeyRing;
    @CommandLine.Option(names={"--gpg-ownertrust"}, description={"Read trust-roots from GnuPGs ownertrust."})
    private boolean optGpgOwnerTrust;
    @CommandLine.Option(names={"--certification-network"}, description={"Treat the web of trust as a certification network instead of an authentication network."})
    private boolean optCertificationNetwork;
    @CommandLine.Option(names={"--gossip"}, description={"Find arbitrary paths by treating all certificates as trust-roots with zero trust."})
    private boolean optGossip;
    @CommandLine.Option(names={"--time"}, description={"Reference time."}, paramLabel="TIMESTAMP", converter={ReferenceTimeConverter.class})
    @NotNull
    private final ReferenceTime optReferenceTime = ReferenceTime.Companion.now();
    @CommandLine.Option(names={"--known-notation"}, description={"Add a notation to the list of known notations."}, paramLabel="NOTATION NAME")
    @NotNull
    private String[] optKnownNotations = new String[0];
    @NotNull
    private final Formatter outputFormatter = new SQWOTFormatter();
    @NotNull
    private static final GpgHelper gpgHelper = new GpgHelper("/usr/bin/gpg");

    @NotNull
    public final List<Root> getOptTrustRoot() {
        return this.optTrustRoot;
    }

    public final void setOptTrustRoot(@NotNull List<Root> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.optTrustRoot = list;
    }

    @NotNull
    public final TrustAmount getOptTrustAmount() {
        return this.optTrustAmount;
    }

    public final void setOptTrustAmount(@NotNull TrustAmount trustAmount) {
        Intrinsics.checkNotNullParameter(trustAmount, "<set-?>");
        this.optTrustAmount = trustAmount;
    }

    @NotNull
    public final CertificateSource getOptKeyRing() {
        CertificateSource certificateSource = this.optKeyRing;
        if (certificateSource != null) {
            return certificateSource;
        }
        Intrinsics.throwUninitializedPropertyAccessException("optKeyRing");
        return null;
    }

    public final void setOptKeyRing(@NotNull CertificateSource certificateSource) {
        Intrinsics.checkNotNullParameter(certificateSource, "<set-?>");
        this.optKeyRing = certificateSource;
    }

    public final boolean getOptGpgOwnerTrust() {
        return this.optGpgOwnerTrust;
    }

    public final void setOptGpgOwnerTrust(boolean bl) {
        this.optGpgOwnerTrust = bl;
    }

    public final boolean getOptCertificationNetwork() {
        return this.optCertificationNetwork;
    }

    public final void setOptCertificationNetwork(boolean bl) {
        this.optCertificationNetwork = bl;
    }

    public final boolean getOptGossip() {
        return this.optGossip;
    }

    public final void setOptGossip(boolean bl) {
        this.optGossip = bl;
    }

    @NotNull
    public final ReferenceTime getOptReferenceTime() {
        return this.optReferenceTime;
    }

    @NotNull
    public final String[] getOptKnownNotations() {
        return this.optKnownNotations;
    }

    public final void setOptKnownNotations(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "<set-?>");
        this.optKnownNotations = stringArray;
    }

    @NotNull
    public final Formatter getOutputFormatter() {
        return this.outputFormatter;
    }

    private final Roots getTrustRoots() {
        List<Root> it = SugarKt.letIf(SugarKt.letIf(this.optTrustRoot, this.getOptKeyRing().getOptGpg() || this.optGpgOwnerTrust, (Function1)trustRoots.1.INSTANCE), this.getOptKeyRing().getOptPgpCertD() != null, (Function1)new Function1<List<? extends Root>, List<? extends Root>>(this){
            final /* synthetic */ WebOfTrustCLI this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Root> invoke(@NotNull List<Root> $this$letIf) {
                List<Root> list;
                Intrinsics.checkNotNullParameter($this$letIf, "$this$letIf");
                try {
                    Certificate rootCert = this.this$0.getOptKeyRing().getGet().getCertificate("trust-root");
                    Collection collection = $this$letIf;
                    String string = rootCert.getFingerprint();
                    Intrinsics.checkNotNullExpressionValue(string, "rootCert.fingerprint");
                    list = CollectionsKt.plus(collection, new Root(new Fingerprint(string), Integer.MAX_VALUE));
                }
                catch (NoSuchElementException e) {
                    list = $this$letIf;
                }
                return list;
            }
        });
        boolean bl = false;
        return new Roots(it);
    }

    @NotNull
    public final WebOfTrustAPI getApi() {
        Network network = PGPNetworkParser.buildNetwork$default(new PGPNetworkParser(this.getOptKeyRing().getGet()), null, this.optReferenceTime, 1, null);
        return new WebOfTrustAPI(network, this.getTrustRoots(), this.optGossip, this.optCertificationNetwork, this.optTrustAmount.get(this.optCertificationNetwork), this.optReferenceTime);
    }

    @Override
    @NotNull
    public Integer call() {
        if (!(!((Collection)this.optTrustRoot).isEmpty())) {
            boolean bl = false;
            String string = "Expected at least one trust-root.";
            throw new IllegalArgumentException(string.toString());
        }
        for (String notation : this.optKnownNotations) {
            PGPainless.getPolicy().getNotationRegistry().addKnownNotation(notation);
        }
        return 0;
    }

    @NotNull
    public String toString() {
        String string;
        if (this.getOptKeyRing().getOptGpg()) {
            string = "gpg";
        } else {
            string = this.getOptKeyRing().getOptPgpCertD();
            if (string == null) {
                String string2;
                Object[] objectArray = this.getOptKeyRing().getOptKeyring();
                if (objectArray != null) {
                    String string3 = Arrays.toString(objectArray);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "toString(this)");
                } else {
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = "null";
                }
            }
        }
        String source = string;
        StringBuilder stringBuilder = new StringBuilder().append("trustroot=").append(this.getTrustRoots()).append(", source=").append(source).append(", gossip=").append(this.optGossip).append(", amount=").append(this.optTrustAmount.get(this.optCertificationNetwork)).append(", referenceTime=").append(this.optReferenceTime.getTimestamp()).append(", notations=");
        String string4 = Arrays.toString(this.optKnownNotations);
        Intrinsics.checkNotNullExpressionValue(string4, "toString(this)");
        return stringBuilder.append(string4).toString();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @JvmStatic
    public static final int execute(@NotNull String[] args2) {
        return Companion.execute(args2);
    }

    @NotNull
    public static final GpgHelper getGpgHelper() {
        return Companion.getGpgHelper();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/pgpainless/wot/cli/WebOfTrustCLI$CertificateSource;", "", "()V", "get", "Lpgp/certificate_store/PGPCertificateStore;", "getGet", "()Lpgp/certificate_store/PGPCertificateStore;", "optGpg", "", "getOptGpg", "()Z", "setOptGpg", "(Z)V", "optKeyring", "", "Ljava/io/File;", "getOptKeyring", "()[Ljava/io/File;", "setOptKeyring", "([Ljava/io/File;)V", "[Ljava/io/File;", "optPgpCertD", "", "getOptPgpCertD", "()Ljava/lang/String;", "setOptPgpCertD", "(Ljava/lang/String;)V", "pgpainless-wot-cli"})
    @SourceDebugExtension(value={"SMAP\nWebOfTrustCLI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebOfTrustCLI.kt\norg/pgpainless/wot/cli/WebOfTrustCLI$CertificateSource\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,217:1\n11335#2:218\n11670#2,3:219\n*S KotlinDebug\n*F\n+ 1 WebOfTrustCLI.kt\norg/pgpainless/wot/cli/WebOfTrustCLI$CertificateSource\n*L\n126#1:218\n126#1:219,3\n*E\n"})
    public static final class CertificateSource {
        @CommandLine.Option(names={"--keyring", "-k"}, required=true, description={"Specify a keyring file."}, paramLabel="FILE")
        @Nullable
        private File[] optKeyring;
        @CommandLine.Option(names={"--cert-d"}, description={"Specify a pgp-cert-d base directory. Leave empty to fallback to the default pgp-cert-d location."}, arity="0..1", paramLabel="PATH", fallbackValue="")
        @Nullable
        private String optPgpCertD;
        @CommandLine.Option(names={"--gpg"}, description={"Read trust roots and keyring from GnuPG."})
        private boolean optGpg;

        @Nullable
        public final File[] getOptKeyring() {
            return this.optKeyring;
        }

        public final void setOptKeyring(@Nullable File[] fileArray) {
            this.optKeyring = fileArray;
        }

        @Nullable
        public final String getOptPgpCertD() {
            return this.optPgpCertD;
        }

        public final void setOptPgpCertD(@Nullable String string) {
            this.optPgpCertD = string;
        }

        public final boolean getOptGpg() {
            return this.optGpg;
        }

        public final void setOptGpg(boolean bl) {
            this.optGpg = bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PGPCertificateStore getGet() {
            if (this.optGpg) {
                return Companion.getGpgHelper().readGpgKeyRing();
            }
            if (this.optKeyring != null) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNull(this.optKeyring);
                File[] $this$map$iv = this.optKeyring;
                boolean $i$f$map = false;
                File[] fileArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var9_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    PGPPublicKeyRingCollection pGPPublicKeyRingCollection = PGPainless.readKeyRing().publicKeyRingCollection(new FileInputStream((File)it));
                    Intrinsics.checkNotNullExpressionValue(pGPPublicKeyRingCollection, "readKeyRing().publicKeyR\u2026lection(it.inputStream())");
                    collection.add(pGPPublicKeyRingCollection);
                }
                List list = (List)destination$iv$iv;
                return new KeyRingCertificateStore(list);
            }
            if (Intrinsics.areEqual(this.optPgpCertD, "")) {
                File certDFile = BaseDirectoryProvider.getDefaultBaseDir();
                PGPainlessCertD certD = PGPainlessCertD.fileBased(certDFile, new InMemorySubkeyLookupFactory());
                return new PGPCertificateStoreAdapter(certD);
            }
            String string = this.optPgpCertD;
            Intrinsics.checkNotNull(string);
            PGPainlessCertD certD = PGPainlessCertD.fileBased(new File(string), new InMemorySubkeyLookupFactory());
            return new PGPCertificateStoreAdapter(certD);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0002\u0010\u0010R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/wot/cli/WebOfTrustCLI$Companion;", "", "()V", "gpgHelper", "Lorg/pgpainless/wot/cli/GpgHelper;", "getGpgHelper$annotations", "getGpgHelper", "()Lorg/pgpainless/wot/cli/GpgHelper;", "execute", "", "args", "", "", "([Ljava/lang/String;)I", "main", "", "([Ljava/lang/String;)V", "pgpainless-wot-cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            System.exit(this.execute(args2));
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        @JvmStatic
        public final int execute(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            return new CommandLine(new WebOfTrustCLI()).execute(Arrays.copyOf(args2, args2.length));
        }

        @NotNull
        public final GpgHelper getGpgHelper() {
            return gpgHelper;
        }

        @JvmStatic
        public static /* synthetic */ void getGpgHelper$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000bR\"\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001e\u0010\u0013\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/wot/cli/WebOfTrustCLI$TrustAmount;", "", "()V", "optAmount", "", "getOptAmount", "()Ljava/lang/Integer;", "setOptAmount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "optDouble", "", "getOptDouble", "()Z", "setOptDouble", "(Z)V", "optFull", "getOptFull", "setOptFull", "optPartial", "getOptPartial", "setOptPartial", "get", "certificationNetwork", "pgpainless-wot-cli"})
    public static final class TrustAmount {
        @CommandLine.Option(names={"--trust-amount", "-a"}, description={"The required amount of trust."}, paramLabel="AMOUNT")
        @Nullable
        private Integer optAmount;
        @CommandLine.Option(names={"--partial"}, description={"Equivalent to -a 40."})
        private boolean optPartial;
        @CommandLine.Option(names={"--full"}, description={"Equivalent to -a 120."})
        private boolean optFull;
        @CommandLine.Option(names={"--double"}, description={"Equivalent to -a 240."})
        private boolean optDouble;

        @Nullable
        public final Integer getOptAmount() {
            return this.optAmount;
        }

        public final void setOptAmount(@Nullable Integer n) {
            this.optAmount = n;
        }

        public final boolean getOptPartial() {
            return this.optPartial;
        }

        public final void setOptPartial(boolean bl) {
            this.optPartial = bl;
        }

        public final boolean getOptFull() {
            return this.optFull;
        }

        public final void setOptFull(boolean bl) {
            this.optFull = bl;
        }

        public final boolean getOptDouble() {
            return this.optDouble;
        }

        public final void setOptDouble(boolean bl) {
            this.optDouble = bl;
        }

        public final int get(boolean certificationNetwork) {
            int n;
            if (this.optAmount != null) {
                Integer n2 = this.optAmount;
                Intrinsics.checkNotNull(n2);
                n = n2;
            } else {
                n = this.optPartial ? 40 : (this.optFull ? 120 : (this.optDouble ? 240 : (certificationNetwork ? 1200 : 120)));
            }
            return n;
        }
    }
}

