/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.cli.subcommands;

import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.api.LookupAPI;
import org.pgpainless.wot.cli.WebOfTrustCLI;
import picocli.CommandLine;

@CommandLine.Command(name="lookup", description={"Lookup authentic certificates by finding bindings for a given user ID."})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/wot/cli/subcommands/LookupCmd;", "Ljava/util/concurrent/Callable;", "", "()V", "email", "", "getEmail", "()Z", "setEmail", "(Z)V", "parent", "Lorg/pgpainless/wot/cli/WebOfTrustCLI;", "getParent", "()Lorg/pgpainless/wot/cli/WebOfTrustCLI;", "setParent", "(Lorg/pgpainless/wot/cli/WebOfTrustCLI;)V", "userId", "", "getUserId", "()Ljava/lang/String;", "setUserId", "(Ljava/lang/String;)V", "call", "()Ljava/lang/Integer;", "pgpainless-wot-cli"})
public final class LookupCmd
implements Callable<Integer> {
    @CommandLine.ParentCommand
    public WebOfTrustCLI parent;
    @CommandLine.Option(names={"--email"}, description={"Consider all user-IDs that contain the given email address."})
    private boolean email;
    @CommandLine.Parameters(index="0", description={"User-ID"}, paramLabel="USERID")
    public String userId;

    @NotNull
    public final WebOfTrustCLI getParent() {
        WebOfTrustCLI webOfTrustCLI = this.parent;
        if (webOfTrustCLI != null) {
            return webOfTrustCLI;
        }
        Intrinsics.throwUninitializedPropertyAccessException("parent");
        return null;
    }

    public final void setParent(@NotNull WebOfTrustCLI webOfTrustCLI) {
        Intrinsics.checkNotNullParameter(webOfTrustCLI, "<set-?>");
        this.parent = webOfTrustCLI;
    }

    public final boolean getEmail() {
        return this.email;
    }

    public final void setEmail(boolean bl) {
        this.email = bl;
    }

    @NotNull
    public final String getUserId() {
        String string = this.userId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("userId");
        return null;
    }

    public final void setUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.userId = string;
    }

    @Override
    @NotNull
    public Integer call() {
        LookupAPI.Result result = this.getParent().getApi().lookup(this.getUserId(), this.email);
        System.out.print((Object)this.getParent().getOutputFormatter().format(result));
        return result.getAcceptable() ? 0 : 1;
    }
}

