/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0096\u0002J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0002J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\u0002H\u0016J\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\b\u001a\u00020\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/wot/network/Depth;", "", "", "limit", "(I)V", "compareTo", "other", "decrease", "value", "equals", "", "", "hashCode", "isUnconstrained", "min", "toString", "", "Companion", "wot-dijkstra"})
public final class Depth
implements Comparable<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int limit;

    private Depth(int limit) {
        this.limit = limit;
    }

    public final boolean isUnconstrained() {
        return this.limit == 255;
    }

    public final int value() {
        return this.limit;
    }

    @NotNull
    public final Depth decrease(int value) {
        Depth depth;
        if (this.isUnconstrained()) {
            depth = Companion.unconstrained();
        } else if (this.limit >= value) {
            depth = Companion.limited(this.limit - value);
        } else {
            throw new IllegalArgumentException("Depth cannot be decreased.");
        }
        return depth;
    }

    @NotNull
    public final Depth min(@NotNull Depth other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.limit > other.limit ? other : this;
    }

    @Override
    public int compareTo(int other) {
        return this.isUnconstrained() ? 1 : Intrinsics.compare(this.limit, other);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Depth)) {
            return false;
        }
        return this.limit == ((Depth)other).limit;
    }

    @NotNull
    public String toString() {
        return this.isUnconstrained() ? "unconstrained" : String.valueOf(this.limit);
    }

    public int hashCode() {
        return this.limit;
    }

    @JvmStatic
    @NotNull
    public static final Depth unconstrained() {
        return Companion.unconstrained();
    }

    @JvmStatic
    @NotNull
    public static final Depth limited(int limit) {
        return Companion.limited(limit);
    }

    @JvmStatic
    @NotNull
    public static final Depth auto(int limit) {
        return Companion.auto(limit);
    }

    public /* synthetic */ Depth(int limit, DefaultConstructorMarker $constructor_marker) {
        this(limit);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/wot/network/Depth$Companion;", "", "()V", "auto", "Lorg/pgpainless/wot/network/Depth;", "limit", "", "limited", "unconstrained", "wot-dijkstra"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Depth unconstrained() {
            return new Depth(255, null);
        }

        @JvmStatic
        @NotNull
        public final Depth limited(int limit) {
            if (!(0 <= limit ? limit < 255 : false)) {
                boolean bl = false;
                String string = "Trust depth MUST be a value between 0 and 254.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Depth(limit, null);
        }

        @JvmStatic
        @NotNull
        public final Depth auto(int limit) {
            if (!(0 <= limit ? limit < 256 : false)) {
                boolean bl = false;
                String string = "Trust depth MUST be a value between 0 and 255.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Depth(limit, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

