/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.network.EdgeComponent;
import org.pgpainless.wot.network.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0000J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\"\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0005\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/wot/network/Edge;", "", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "components", "", "", "", "Lorg/pgpainless/wot/network/EdgeComponent;", "(Lorg/pgpainless/wot/network/Node;Lorg/pgpainless/wot/network/Node;Ljava/util/Map;)V", "_components", "", "", "getComponents", "()Ljava/util/Map;", "getIssuer", "()Lorg/pgpainless/wot/network/Node;", "getTarget", "add", "", "component", "merge", "other", "toString", "Companion", "wot-dijkstra"})
@SourceDebugExtension(value={"SMAP\nEdge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Edge.kt\norg/pgpainless/wot/network/Edge\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,114:1\n215#2:115\n216#2:118\n125#2:127\n152#2,3:128\n1855#3,2:116\n1#4:119\n361#5,7:120\n*S KotlinDebug\n*F\n+ 1 Edge.kt\norg/pgpainless/wot/network/Edge\n*L\n23#1:115\n23#1:118\n112#1:127\n112#1:128,3\n24#1:116,2\n92#1:120,7\n*E\n"})
public final class Edge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Node issuer;
    @NotNull
    private final Node target;
    @NotNull
    private final Map<String, List<EdgeComponent>> _components;

    public Edge(@NotNull Node issuer, @NotNull Node target, @NotNull Map<String, ? extends List<EdgeComponent>> components) {
        Intrinsics.checkNotNullParameter(issuer, "issuer");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(components, "components");
        this.issuer = issuer;
        this.target = target;
        Map<String, ? extends List<EdgeComponent>> $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<EdgeComponent>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ? extends List<EdgeComponent>> element$iv;
            Map.Entry<String, ? extends List<EdgeComponent>> entry = element$iv = iterator2.next();
            boolean bl = false;
            List<EdgeComponent> certifications = entry.getValue();
            Iterable $this$forEach$iv2 = certifications;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                EdgeComponent it = (EdgeComponent)element$iv2;
                boolean bl2 = false;
                this.add(it);
            }
        }
        this._components = new LinkedHashMap();
    }

    @NotNull
    public final Node getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final Node getTarget() {
        return this.target;
    }

    @NotNull
    public final Map<String, List<EdgeComponent>> getComponents() {
        return MapsKt.toMutableMap(this._components);
    }

    public final void merge(@NotNull Edge other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (Intrinsics.areEqual(other, this)) {
            return;
        }
        if (!Intrinsics.areEqual(this.issuer.getFingerprint(), other.issuer.getFingerprint())) {
            boolean $i$a$-require-Edge$merge$32 = false;
            String $i$a$-require-Edge$merge$32 = "Issuer fingerprint mismatch.";
            throw new IllegalArgumentException($i$a$-require-Edge$merge$32.toString());
        }
        if (!Intrinsics.areEqual(this.target.getFingerprint(), other.target.getFingerprint())) {
            boolean $i$a$-require-Edge$merge$42 = false;
            String $i$a$-require-Edge$merge$42 = "Target fingerprint mismatch.";
            throw new IllegalArgumentException($i$a$-require-Edge$merge$42.toString());
        }
        for (String userId : other.getComponents().keySet()) {
            List<EdgeComponent> list = other.getComponents().get(userId);
            Intrinsics.checkNotNull(list);
            for (EdgeComponent certification : list) {
                this.add(certification);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull EdgeComponent component) {
        List certificationsForUserId;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(component, "component");
        if (!Intrinsics.areEqual(this.issuer.getFingerprint(), component.getIssuer().getFingerprint())) {
            boolean $i$a$-require-Edge$add$32 = false;
            String $i$a$-require-Edge$add$32 = "Issuer fingerprint mismatch.";
            throw new IllegalArgumentException($i$a$-require-Edge$add$32.toString());
        }
        if (!Intrinsics.areEqual(this.target.getFingerprint(), component.getTarget().getFingerprint())) {
            boolean $i$a$-require-Edge$add$42 = false;
            String $i$a$-require-Edge$add$42 = "Target fingerprint mismatch.";
            throw new IllegalArgumentException($i$a$-require-Edge$add$42.toString());
        }
        Map<String, List<EdgeComponent>> $i$a$-require-Edge$add$42 = this._components;
        String key$iv = component.getUserId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((certificationsForUserId = (List)object).isEmpty()) {
            certificationsForUserId.add(component);
            return;
        }
        EdgeComponent existing = (EdgeComponent)certificationsForUserId.get(0);
        if (existing.getCreationTime().before(component.getCreationTime())) {
            certificationsForUserId.clear();
        }
        if (!existing.getCreationTime().after(component.getCreationTime())) {
            certificationsForUserId.add(component);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        Map<String, List<EdgeComponent>> $this$map$iv = this.getComponents();
        boolean $i$f$map = false;
        Map<String, List<EdgeComponent>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((List)it.getValue());
        }
        return CollectionsKt.joinToString$default(CollectionsKt.flatten((List)destination$iv$iv), "\n", null, null, 0, null, null, 62, null);
    }

    @JvmStatic
    @NotNull
    public static final Edge empty(@NotNull Node issuer, @NotNull Node target) {
        return Companion.empty(issuer, target);
    }

    @JvmStatic
    @NotNull
    public static final Edge fromCertification(@NotNull EdgeComponent certification) {
        return Companion.fromCertification(certification);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/wot/network/Edge$Companion;", "", "()V", "empty", "Lorg/pgpainless/wot/network/Edge;", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "fromCertification", "certification", "Lorg/pgpainless/wot/network/EdgeComponent;", "wot-dijkstra"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Edge empty(@NotNull Node issuer, @NotNull Node target) {
            Intrinsics.checkNotNullParameter(issuer, "issuer");
            Intrinsics.checkNotNullParameter(target, "target");
            return new Edge(issuer, target, new HashMap());
        }

        @JvmStatic
        @NotNull
        public final Edge fromCertification(@NotNull EdgeComponent certification) {
            Intrinsics.checkNotNullParameter(certification, "certification");
            Edge set = this.empty(certification.getIssuer(), certification.getTarget());
            set.add(certification);
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

