/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.wot.network.Depth;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010(\u001a\u00020\u000bH\u00c6\u0003J\t\u0010)\u001a\u00020\rH\u00c6\u0003J\t\u0010*\u001a\u00020\u000fH\u00c6\u0003J\t\u0010+\u001a\u00020\u0011H\u00c6\u0003Jg\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\rH\u00d6\u0001J\b\u00100\u001a\u00020\u0006H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lorg/pgpainless/wot/network/EdgeComponent;", "", "issuer", "Lorg/pgpainless/wot/network/Node;", "target", "userId", "", "creationTime", "Ljava/util/Date;", "expirationTime", "exportable", "", "trustAmount", "", "trustDepth", "Lorg/pgpainless/wot/network/Depth;", "regexes", "Lorg/pgpainless/wot/network/RegexSet;", "(Lorg/pgpainless/wot/network/Node;Lorg/pgpainless/wot/network/Node;Ljava/lang/String;Ljava/util/Date;Ljava/util/Date;ZILorg/pgpainless/wot/network/Depth;Lorg/pgpainless/wot/network/RegexSet;)V", "getCreationTime", "()Ljava/util/Date;", "getExpirationTime", "getExportable", "()Z", "getIssuer", "()Lorg/pgpainless/wot/network/Node;", "getRegexes", "()Lorg/pgpainless/wot/network/RegexSet;", "getTarget", "getTrustAmount", "()I", "getTrustDepth", "()Lorg/pgpainless/wot/network/Depth;", "getUserId", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "wot-dijkstra"})
public final class EdgeComponent {
    @NotNull
    private final Node issuer;
    @NotNull
    private final Node target;
    @Nullable
    private final String userId;
    @NotNull
    private final Date creationTime;
    @Nullable
    private final Date expirationTime;
    private final boolean exportable;
    private final int trustAmount;
    @NotNull
    private final Depth trustDepth;
    @NotNull
    private final RegexSet regexes;

    public EdgeComponent(@NotNull Node issuer, @NotNull Node target, @Nullable String userId, @NotNull Date creationTime, @Nullable Date expirationTime, boolean exportable, int trustAmount, @NotNull Depth trustDepth, @NotNull RegexSet regexes) {
        Intrinsics.checkNotNullParameter(issuer, "issuer");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(creationTime, "creationTime");
        Intrinsics.checkNotNullParameter(trustDepth, "trustDepth");
        Intrinsics.checkNotNullParameter(regexes, "regexes");
        this.issuer = issuer;
        this.target = target;
        this.userId = userId;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.exportable = exportable;
        this.trustAmount = trustAmount;
        this.trustDepth = trustDepth;
        this.regexes = regexes;
    }

    @NotNull
    public final Node getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final Node getTarget() {
        return this.target;
    }

    @Nullable
    public final String getUserId() {
        return this.userId;
    }

    @NotNull
    public final Date getCreationTime() {
        return this.creationTime;
    }

    @Nullable
    public final Date getExpirationTime() {
        return this.expirationTime;
    }

    public final boolean getExportable() {
        return this.exportable;
    }

    public final int getTrustAmount() {
        return this.trustAmount;
    }

    @NotNull
    public final Depth getTrustDepth() {
        return this.trustDepth;
    }

    @NotNull
    public final RegexSet getRegexes() {
        return this.regexes;
    }

    @NotNull
    public String toString() {
        String string;
        if (this.trustDepth.compareTo(0) > 0) {
            String scope = this.regexes.getRegexStrings().isEmpty() ? "" : ", scope: " + this.regexes;
            string = this.issuer.getFingerprint() + " delegates to " + this.target.getFingerprint() + " [" + this.trustAmount + ", depth " + this.trustDepth + scope + ']';
        } else {
            string = this.issuer.getFingerprint() + " certifies binding: " + this.userId + " <-> " + this.target.getFingerprint() + " [" + this.trustAmount + ']';
        }
        return string;
    }

    @NotNull
    public final Node component1() {
        return this.issuer;
    }

    @NotNull
    public final Node component2() {
        return this.target;
    }

    @Nullable
    public final String component3() {
        return this.userId;
    }

    @NotNull
    public final Date component4() {
        return this.creationTime;
    }

    @Nullable
    public final Date component5() {
        return this.expirationTime;
    }

    public final boolean component6() {
        return this.exportable;
    }

    public final int component7() {
        return this.trustAmount;
    }

    @NotNull
    public final Depth component8() {
        return this.trustDepth;
    }

    @NotNull
    public final RegexSet component9() {
        return this.regexes;
    }

    @NotNull
    public final EdgeComponent copy(@NotNull Node issuer, @NotNull Node target, @Nullable String userId, @NotNull Date creationTime, @Nullable Date expirationTime, boolean exportable, int trustAmount, @NotNull Depth trustDepth, @NotNull RegexSet regexes) {
        Intrinsics.checkNotNullParameter(issuer, "issuer");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(creationTime, "creationTime");
        Intrinsics.checkNotNullParameter(trustDepth, "trustDepth");
        Intrinsics.checkNotNullParameter(regexes, "regexes");
        return new EdgeComponent(issuer, target, userId, creationTime, expirationTime, exportable, trustAmount, trustDepth, regexes);
    }

    public static /* synthetic */ EdgeComponent copy$default(EdgeComponent edgeComponent, Node node, Node node2, String string, Date date, Date date2, boolean bl, int n, Depth depth, RegexSet regexSet, int n2, Object object) {
        if ((n2 & 1) != 0) {
            node = edgeComponent.issuer;
        }
        if ((n2 & 2) != 0) {
            node2 = edgeComponent.target;
        }
        if ((n2 & 4) != 0) {
            string = edgeComponent.userId;
        }
        if ((n2 & 8) != 0) {
            date = edgeComponent.creationTime;
        }
        if ((n2 & 0x10) != 0) {
            date2 = edgeComponent.expirationTime;
        }
        if ((n2 & 0x20) != 0) {
            bl = edgeComponent.exportable;
        }
        if ((n2 & 0x40) != 0) {
            n = edgeComponent.trustAmount;
        }
        if ((n2 & 0x80) != 0) {
            depth = edgeComponent.trustDepth;
        }
        if ((n2 & 0x100) != 0) {
            regexSet = edgeComponent.regexes;
        }
        return edgeComponent.copy(node, node2, string, date, date2, bl, n, depth, regexSet);
    }

    public int hashCode() {
        int result = this.issuer.hashCode();
        result = result * 31 + this.target.hashCode();
        result = result * 31 + (this.userId == null ? 0 : this.userId.hashCode());
        result = result * 31 + this.creationTime.hashCode();
        result = result * 31 + (this.expirationTime == null ? 0 : this.expirationTime.hashCode());
        int n = this.exportable ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + Integer.hashCode(this.trustAmount);
        result = result * 31 + this.trustDepth.hashCode();
        result = result * 31 + this.regexes.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EdgeComponent)) {
            return false;
        }
        EdgeComponent edgeComponent = (EdgeComponent)other;
        if (!Intrinsics.areEqual(this.issuer, edgeComponent.issuer)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.target, edgeComponent.target)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userId, edgeComponent.userId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.creationTime, edgeComponent.creationTime)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.expirationTime, edgeComponent.expirationTime)) {
            return false;
        }
        if (this.exportable != edgeComponent.exportable) {
            return false;
        }
        if (this.trustAmount != edgeComponent.trustAmount) {
            return false;
        }
        if (!Intrinsics.areEqual(this.trustDepth, edgeComponent.trustDepth)) {
            return false;
        }
        return Intrinsics.areEqual(this.regexes, edgeComponent.regexes);
    }
}

