/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.EdgeComponent;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.ReferenceTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cBU\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/wot/network/Network;", "", "nodes", "", "Lorg/pgpainless/wot/network/Fingerprint;", "Lorg/pgpainless/wot/network/Node;", "edges", "", "Lorg/pgpainless/wot/network/Edge;", "reverseEdges", "referenceTime", "Lorg/pgpainless/wot/network/ReferenceTime;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lorg/pgpainless/wot/network/ReferenceTime;)V", "getEdges", "()Ljava/util/Map;", "getNodes", "numberOfEdges", "", "getNumberOfEdges", "()I", "numberOfSignatures", "getNumberOfSignatures", "getReferenceTime", "()Lorg/pgpainless/wot/network/ReferenceTime;", "getReverseEdges", "toString", "", "Builder", "Companion", "wot-dijkstra"})
@SourceDebugExtension(value={"SMAP\nNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1360#3:110\n1446#3,5:111\n*S KotlinDebug\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network\n*L\n53#1:110\n53#1:111,5\n*E\n"})
public final class Network {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Fingerprint, Node> nodes;
    @NotNull
    private final Map<Fingerprint, List<Edge>> edges;
    @NotNull
    private final Map<Fingerprint, List<Edge>> reverseEdges;
    @NotNull
    private final ReferenceTime referenceTime;

    public Network(@NotNull Map<Fingerprint, Node> nodes, @NotNull Map<Fingerprint, ? extends List<Edge>> edges, @NotNull Map<Fingerprint, ? extends List<Edge>> reverseEdges, @NotNull ReferenceTime referenceTime) {
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        Intrinsics.checkNotNullParameter(edges, "edges");
        Intrinsics.checkNotNullParameter(reverseEdges, "reverseEdges");
        Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
        this.nodes = nodes;
        this.edges = edges;
        this.reverseEdges = reverseEdges;
        this.referenceTime = referenceTime;
    }

    @NotNull
    public final Map<Fingerprint, Node> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final Map<Fingerprint, List<Edge>> getEdges() {
        return this.edges;
    }

    @NotNull
    public final Map<Fingerprint, List<Edge>> getReverseEdges() {
        return this.reverseEdges;
    }

    @NotNull
    public final ReferenceTime getReferenceTime() {
        return this.referenceTime;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNumberOfEdges() {
        Iterable iterable = this.edges.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            List list = (List)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.size();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNumberOfSignatures() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.flatten((Iterable)this.edges.values());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Edge it = (Edge)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getComponents().values();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it;
            List $i$f$flatMapTo2 = (List)e;
            int n2 = n;
            boolean bl = false;
            int n3 = it.size();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Network with " + this.nodes.size() + " nodes, " + this.getNumberOfEdges() + " edges:\n");
        for (Fingerprint issuer : this.nodes.keySet()) {
            List<Edge> outEdges;
            if (this.edges.get(issuer) == null) continue;
            for (Edge edge : outEdges) {
                StringBuilder stringBuilder = sb.append(edge);
                Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Network empty(@NotNull ReferenceTime referenceTime) {
        return Companion.empty(referenceTime);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\rR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/pgpainless/wot/network/Network$Builder;", "", "()V", "nodes", "", "Lorg/pgpainless/wot/network/Fingerprint;", "Lorg/pgpainless/wot/network/Node;", "getNodes", "()Ljava/util/Map;", "protoEdges", "Lkotlin/Pair;", "Lorg/pgpainless/wot/network/Edge;", "referenceTime", "Lorg/pgpainless/wot/network/ReferenceTime;", "addEdge", "edge", "Lorg/pgpainless/wot/network/EdgeComponent;", "addNode", "node", "build", "Lorg/pgpainless/wot/network/Network;", "setReferenceTime", "time", "wot-dijkstra"})
    @SourceDebugExtension(value={"SMAP\nNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network$Builder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,108:1\n361#2,7:109\n361#2,7:117\n361#2,7:124\n215#3:116\n216#3:131\n*S KotlinDebug\n*F\n+ 1 Network.kt\norg/pgpainless/wot/network/Network$Builder\n*L\n80#1:109,7\n96#1:117,7\n100#1:124,7\n95#1:116\n95#1:131\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Map<Fingerprint, Node> nodes = new LinkedHashMap();
        @NotNull
        private final Map<Pair<Fingerprint, Fingerprint>, Edge> protoEdges = new LinkedHashMap();
        @NotNull
        private ReferenceTime referenceTime = ReferenceTime.Companion.now();

        @NotNull
        public final Map<Fingerprint, Node> getNodes() {
            return this.nodes;
        }

        @NotNull
        public final Builder addNode(@NotNull Node node) {
            Intrinsics.checkNotNullParameter(node, "node");
            this.nodes.put(node.getFingerprint(), node);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder addEdge(@NotNull EdgeComponent edge) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(edge, "edge");
            Map<Pair<Fingerprint, Fingerprint>, Edge> map = this.protoEdges;
            Pair<Fingerprint, Fingerprint> key$iv = new Pair<Fingerprint, Fingerprint>(edge.getIssuer().getFingerprint(), edge.getTarget().getFingerprint());
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Edge answer$iv = Edge.Companion.empty(edge.getIssuer(), edge.getTarget());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Edge)object).add(edge);
            return this;
        }

        @NotNull
        public final Builder setReferenceTime(@NotNull ReferenceTime time) {
            Intrinsics.checkNotNullParameter(time, "time");
            this.referenceTime = time;
            return this;
        }

        @NotNull
        public final Network build() {
            Map edges = new LinkedHashMap();
            Map revEdges = new LinkedHashMap();
            Map<Pair<Fingerprint, Fingerprint>, Edge> $this$forEach$iv = this.protoEdges;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Pair<Fingerprint, Fingerprint>, Edge>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                List answer$iv;
                Map $this$getOrPut$iv;
                Map.Entry<Pair<Fingerprint, Fingerprint>, Edge> element$iv;
                Map.Entry<Pair<Fingerprint, Fingerprint>, Edge> entry = element$iv = iterator2.next();
                boolean bl = false;
                Pair<Fingerprint, Fingerprint> pair = entry.getKey();
                Edge certificationSet = entry.getValue();
                Map map = edges;
                Fingerprint key$iv = pair.getFirst();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(certificationSet);
                $this$getOrPut$iv = revEdges;
                key$iv = pair.getSecond();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(certificationSet);
            }
            return new Network(this.nodes, edges, revEdges, this.referenceTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/wot/network/Network$Companion;", "", "()V", "builder", "Lorg/pgpainless/wot/network/Network$Builder;", "empty", "Lorg/pgpainless/wot/network/Network;", "referenceTime", "Lorg/pgpainless/wot/network/ReferenceTime;", "wot-dijkstra"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Network empty(@NotNull ReferenceTime referenceTime) {
            Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
            return new Network(new HashMap(), new HashMap(), new HashMap(), referenceTime);
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

