/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.RevocationState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tH\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\nH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/wot/network/Node;", "", "fingerprint", "Lorg/pgpainless/wot/network/Fingerprint;", "expirationTime", "Ljava/util/Date;", "revocationState", "Lorg/pgpainless/wot/network/RevocationState;", "userIds", "", "", "(Lorg/pgpainless/wot/network/Fingerprint;Ljava/util/Date;Lorg/pgpainless/wot/network/RevocationState;Ljava/util/Map;)V", "getExpirationTime", "()Ljava/util/Date;", "getFingerprint", "()Lorg/pgpainless/wot/network/Fingerprint;", "getRevocationState", "()Lorg/pgpainless/wot/network/RevocationState;", "getUserIds", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "wot-dijkstra"})
public final class Node {
    @NotNull
    private final Fingerprint fingerprint;
    @Nullable
    private final Date expirationTime;
    @NotNull
    private final RevocationState revocationState;
    @NotNull
    private final Map<String, RevocationState> userIds;

    public Node(@NotNull Fingerprint fingerprint, @Nullable Date expirationTime, @NotNull RevocationState revocationState, @NotNull Map<String, RevocationState> userIds) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        Intrinsics.checkNotNullParameter(revocationState, "revocationState");
        Intrinsics.checkNotNullParameter(userIds, "userIds");
        this.fingerprint = fingerprint;
        this.expirationTime = expirationTime;
        this.revocationState = revocationState;
        this.userIds = userIds;
    }

    public /* synthetic */ Node(Fingerprint fingerprint, Date date, RevocationState revocationState, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            date = null;
        }
        if ((n & 4) != 0) {
            revocationState = RevocationState.Companion.notRevoked();
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        this(fingerprint, date, revocationState, map);
    }

    @NotNull
    public final Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    public final Date getExpirationTime() {
        return this.expirationTime;
    }

    @NotNull
    public final RevocationState getRevocationState() {
        return this.revocationState;
    }

    @NotNull
    public final Map<String, RevocationState> getUserIds() {
        return this.userIds;
    }

    @NotNull
    public String toString() {
        return this.userIds.isEmpty() ? String.valueOf(this.fingerprint) : this.fingerprint + " (" + (String)CollectionsKt.first((Iterable)this.userIds.keySet()) + ')';
    }

    @NotNull
    public final Fingerprint component1() {
        return this.fingerprint;
    }

    @Nullable
    public final Date component2() {
        return this.expirationTime;
    }

    @NotNull
    public final RevocationState component3() {
        return this.revocationState;
    }

    @NotNull
    public final Map<String, RevocationState> component4() {
        return this.userIds;
    }

    @NotNull
    public final Node copy(@NotNull Fingerprint fingerprint, @Nullable Date expirationTime, @NotNull RevocationState revocationState, @NotNull Map<String, RevocationState> userIds) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        Intrinsics.checkNotNullParameter(revocationState, "revocationState");
        Intrinsics.checkNotNullParameter(userIds, "userIds");
        return new Node(fingerprint, expirationTime, revocationState, userIds);
    }

    public static /* synthetic */ Node copy$default(Node node, Fingerprint fingerprint, Date date, RevocationState revocationState, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            fingerprint = node.fingerprint;
        }
        if ((n & 2) != 0) {
            date = node.expirationTime;
        }
        if ((n & 4) != 0) {
            revocationState = node.revocationState;
        }
        if ((n & 8) != 0) {
            map = node.userIds;
        }
        return node.copy(fingerprint, date, revocationState, map);
    }

    public int hashCode() {
        int result = this.fingerprint.hashCode();
        result = result * 31 + (this.expirationTime == null ? 0 : this.expirationTime.hashCode());
        result = result * 31 + this.revocationState.hashCode();
        result = result * 31 + ((Object)this.userIds).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        Node node = (Node)other;
        if (!Intrinsics.areEqual(this.fingerprint, node.fingerprint)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.expirationTime, node.expirationTime)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.revocationState, node.revocationState)) {
            return false;
        }
        return Intrinsics.areEqual(this.userIds, node.userIds);
    }
}

