/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.network.Depth;
import org.pgpainless.wot.network.EdgeComponent;
import org.pgpainless.wot.network.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/pgpainless/wot/query/Path;", "", "root", "Lorg/pgpainless/wot/network/Node;", "(Lorg/pgpainless/wot/network/Node;)V", "edges", "", "Lorg/pgpainless/wot/network/EdgeComponent;", "residualDepth", "Lorg/pgpainless/wot/network/Depth;", "(Lorg/pgpainless/wot/network/Node;Ljava/util/List;Lorg/pgpainless/wot/network/Depth;)V", "amount", "", "getAmount", "()I", "certificates", "", "getCertificates", "()Ljava/util/List;", "certifications", "getCertifications", "length", "getLength", "getResidualDepth", "()Lorg/pgpainless/wot/network/Depth;", "setResidualDepth", "(Lorg/pgpainless/wot/network/Depth;)V", "getRoot", "()Lorg/pgpainless/wot/network/Node;", "target", "getTarget", "append", "", "nComponent", "certificationNetwork", "", "toString", "", "wot-dijkstra"})
@SourceDebugExtension(value={"SMAP\nPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path.kt\norg/pgpainless/wot/query/Path\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1549#3:147\n1620#3,3:148\n*S KotlinDebug\n*F\n+ 1 Path.kt\norg/pgpainless/wot/query/Path\n*L\n143#1:147\n143#1:148,3\n*E\n"})
public final class Path {
    @NotNull
    private final Node root;
    @NotNull
    private final List<EdgeComponent> edges;
    @NotNull
    private Depth residualDepth;

    public Path(@NotNull Node root, @NotNull List<EdgeComponent> edges, @NotNull Depth residualDepth) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(edges, "edges");
        Intrinsics.checkNotNullParameter(residualDepth, "residualDepth");
        this.root = root;
        this.edges = edges;
        this.residualDepth = residualDepth;
    }

    @NotNull
    public final Node getRoot() {
        return this.root;
    }

    @NotNull
    public final Depth getResidualDepth() {
        return this.residualDepth;
    }

    public final void setResidualDepth(@NotNull Depth depth) {
        Intrinsics.checkNotNullParameter(depth, "<set-?>");
        this.residualDepth = depth;
    }

    public Path(@NotNull Node root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this(root, new ArrayList(), Depth.Companion.unconstrained());
    }

    @NotNull
    public final Node getTarget() {
        return this.edges.isEmpty() ? this.root : CollectionsKt.last(this.edges).getTarget();
    }

    @NotNull
    public final List<Node> getCertificates() {
        Node[] nodeArray = new Node[]{this.root};
        List<Node> certs = CollectionsKt.mutableListOf(nodeArray);
        for (EdgeComponent certification : this.edges) {
            certs.add(certification.getTarget());
        }
        return certs;
    }

    public final int getLength() {
        return this.edges.size() + 1;
    }

    @NotNull
    public final List<EdgeComponent> getCertifications() {
        return CollectionsKt.toList((Iterable)this.edges);
    }

    /*
     * WARNING - void declaration
     */
    public final int getAmount() {
        int n;
        if (this.edges.isEmpty()) {
            n = 120;
        } else {
            void var1_1;
            int min = 255;
            for (EdgeComponent edge : this.edges) {
                min = Math.min(min, edge.getTrustAmount());
            }
            n = var1_1;
        }
        return n;
    }

    public final void append(@NotNull EdgeComponent nComponent) {
        Intrinsics.checkNotNullParameter(nComponent, "nComponent");
        this.append(nComponent, false);
    }

    public final void append(@NotNull EdgeComponent nComponent, boolean certificationNetwork) {
        Intrinsics.checkNotNullParameter(nComponent, "nComponent");
        if (!Intrinsics.areEqual(this.getTarget().getFingerprint(), nComponent.getIssuer().getFingerprint())) {
            boolean $i$a$-require-Path$append$42 = false;
            String $i$a$-require-Path$append$42 = "Cannot append edge to path: Path's tail is not issuer of the edge.";
            throw new IllegalArgumentException($i$a$-require-Path$append$42.toString());
        }
        if (!(certificationNetwork || this.residualDepth.compareTo(0) > 0)) {
            boolean bl = false;
            String string = "Not enough depth.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean cyclic = false;
        if (this.edges.size() > 0 && Intrinsics.areEqual(this.root.getFingerprint(), nComponent.getTarget().getFingerprint())) {
            cyclic = true;
        }
        if (this.edges.size() == 0 && Intrinsics.areEqual(this.root.getFingerprint(), nComponent.getTarget().getFingerprint()) && nComponent.getUserId() == null) {
            cyclic = true;
        }
        Iterator<EdgeComponent> iterator2 = this.edges.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            EdgeComponent component = iterator2.next();
            if (cyclic) break;
            if (!Intrinsics.areEqual(nComponent.getTarget().getFingerprint(), component.getTarget().getFingerprint())) continue;
            cyclic = CollectionsKt.getLastIndex(this.edges) != i ? true : Intrinsics.areEqual(nComponent.getUserId(), component.getUserId());
        }
        if (!(!cyclic)) {
            boolean bl = false;
            String string = "Adding the edge to the path would create a cycle.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!certificationNetwork) {
            this.residualDepth = nComponent.getTrustDepth().min(this.residualDepth.decrease(1));
        }
        this.edges.add(nComponent);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.edges;
        StringBuilder stringBuilder = new StringBuilder().append('{').append(this.root.getFingerprint()).append("} => {");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EdgeComponent edgeComponent = (EdgeComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTarget());
        }
        return stringBuilder.append(CollectionsKt.joinToString$default((List)destination$iv$iv, " -> ", null, null, 0, null, null, 62, null)).append("} (residual {").append(this.residualDepth).append("})").toString();
    }
}

