/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.network.EdgeComponent;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.Root;
import org.pgpainless.wot.network.Roots;
import org.pgpainless.wot.query.Cost;
import org.pgpainless.wot.query.ForwardPointer;
import org.pgpainless.wot.query.PairPriorityQueue;
import org.pgpainless.wot.query.Path;
import org.pgpainless.wot.query.Paths;
import org.pgpainless.wot.query.Query;
import org.pgpainless.wot.query.WotNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJJ\u0010\u001c\u001a6\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001d0\u0013j\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001d`\u00162\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010JT\u0010\u001c\u001a6\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001d0\u0013j\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001d`\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u009c\u0001\u0010 \u001a6\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001d0\u0013j\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001d`\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\r\u001a\u00020\u000e2\"\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\"0\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\"`\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/pgpainless/wot/query/Query;", "", "rawNetwork", "Lorg/pgpainless/wot/network/Network;", "roots", "Lorg/pgpainless/wot/network/Roots;", "certificationNetwork", "", "(Lorg/pgpainless/wot/network/Network;Lorg/pgpainless/wot/network/Roots;Z)V", "logger", "Lorg/slf4j/Logger;", "assemblePath", "Lorg/pgpainless/wot/query/Path;", "target", "Lorg/pgpainless/wot/network/Node;", "targetUserid", "", "issuer", "bestNextNode", "Ljava/util/HashMap;", "Lorg/pgpainless/wot/network/Fingerprint;", "Lorg/pgpainless/wot/query/ForwardPointer;", "Lkotlin/collections/HashMap;", "authenticate", "Lorg/pgpainless/wot/query/Paths;", "targetFpr", "targetTrustAmount", "", "backwardPropagate", "Lkotlin/Pair;", "network", "Lorg/pgpainless/wot/query/WotNetwork;", "reconstructPaths", "dist", "Lorg/pgpainless/wot/query/Cost;", "wot-dijkstra"})
@SourceDebugExtension(value={"SMAP\nQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Query.kt\norg/pgpainless/wot/query/Query\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n766#2:294\n857#2,2:295\n1855#2,2:297\n1603#2,9:299\n1855#2:308\n1856#2:310\n1612#2:311\n766#2:312\n857#2,2:313\n766#2:315\n857#2,2:316\n1855#2,2:318\n1#3:309\n*S KotlinDebug\n*F\n+ 1 Query.kt\norg/pgpainless/wot/query/Query\n*L\n43#1:294\n43#1:295,2\n44#1:297,2\n66#1:299,9\n66#1:308\n66#1:310\n66#1:311\n246#1:312\n246#1:313,2\n248#1:315\n248#1:316,2\n249#1:318,2\n66#1:309\n*E\n"})
public final class Query {
    @NotNull
    private final Network rawNetwork;
    @NotNull
    private final Roots roots;
    private final boolean certificationNetwork;
    @NotNull
    private final Logger logger;

    public Query(@NotNull Network rawNetwork, @NotNull Roots roots, boolean certificationNetwork) {
        Intrinsics.checkNotNullParameter(rawNetwork, "rawNetwork");
        Intrinsics.checkNotNullParameter(roots, "roots");
        this.rawNetwork = rawNetwork;
        this.roots = roots;
        this.certificationNetwork = certificationNetwork;
        Logger logger = LoggerFactory.getLogger(Query.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(Query::class.java)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Paths authenticate(@NotNull Fingerprint targetFpr, @NotNull String targetUserid, int targetTrustAmount) {
        Intrinsics.checkNotNullParameter(targetFpr, "targetFpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        Object[] objectArray = new Object[]{targetFpr, targetUserid, this.roots};
        this.logger.debug("Authenticating <{}, '{}'>\nRoots: {}", objectArray);
        WotNetwork network = new WotNetwork(this.rawNetwork, this.certificationNetwork);
        if (!this.certificationNetwork) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = this.roots.roots();
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Root it = (Root)element$iv$iv;
                boolean bl = false;
                if (!(it.getAmount() != 120)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Iterable element$iv : $this$forEach$iv) {
                Root it = (Root)((Object)element$iv);
                boolean bl2 = false;
                network.capCertificate(it.getFingerprint(), it.getAmount());
            }
        }
        Paths paths = new Paths();
        while (paths.getAmount() < targetTrustAmount) {
            boolean bl;
            void $this$mapNotNullTo$iv$iv;
            Function1[] $this$mapNotNull$iv;
            Iterable element$iv;
            HashMap<Fingerprint, Pair<Path, Integer>> authPaths = this.backwardPropagate(network, targetFpr, targetUserid);
            element$iv = this.roots.fingerprints();
            boolean $i$f$mapNotNull = false;
            void bl2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Pair<Path, Integer> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl3 = false;
                Fingerprint it = (Fingerprint)element$iv$iv;
                boolean bl4 = false;
                if (authPaths.get(it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = new Function1[]{authenticate.bestPath.2.INSTANCE, authenticate.bestPath.3.INSTANCE, authenticate.bestPath.4.INSTANCE};
            Pair bestPath2 = (Pair)CollectionsKt.maxWithOrNull((List)destination$iv$iv, ComparisonsKt.compareBy($this$mapNotNull$iv));
            if (bestPath2 == null) break;
            Path path = (Path)bestPath2.component1();
            int amount = ((Number)bestPath2.component2()).intValue();
            boolean bl6 = bl = path.getLength() > 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            network.suppressPath(path, amount);
            paths.add(path, amount);
        }
        return paths;
    }

    @NotNull
    public final HashMap<Fingerprint, Pair<Path, Integer>> backwardPropagate(@NotNull Fingerprint targetFpr, @NotNull String targetUserid) {
        Intrinsics.checkNotNullParameter(targetFpr, "targetFpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        WotNetwork network = new WotNetwork(this.rawNetwork, false);
        return this.backwardPropagate(network, targetFpr, targetUserid);
    }

    private final HashMap<Fingerprint, Pair<Path, Integer>> backwardPropagate(WotNetwork network, Fingerprint targetFpr, String targetUserid) {
        Object object;
        Cost cost;
        int selfSigAmount;
        EdgeComponent selfSig;
        Object[] objectArray = new Object[]{targetFpr, targetUserid, this.roots};
        this.logger.debug("Query.backwardPropagate <{}, '{}'>\nRoots: {}", objectArray);
        Node node = network.isValidTarget(targetFpr, targetUserid);
        if (node == null) {
            return new HashMap<Fingerprint, Pair<Path, Integer>>();
        }
        Node target = node;
        HashMap<Fingerprint, ForwardPointer> prev = new HashMap<Fingerprint, ForwardPointer>();
        HashMap<Fingerprint, Cost> dist = new HashMap<Fingerprint, Cost>();
        PairPriorityQueue<Fingerprint, Comparable> queue = new PairPriorityQueue<Fingerprint, Comparable>();
        EdgeComponent edgeComponent = selfSig = network.getSelfSig(targetFpr, targetUserid);
        int n = selfSigAmount = edgeComponent != null ? network.getEffectiveTrustAmount(edgeComponent) : 0;
        if (selfSig != null && selfSigAmount > 0) {
            cost = new Cost(1, selfSigAmount);
            ((Map)prev).put(targetFpr, new ForwardPointer(selfSig));
            ((Map)dist).put(targetFpr, cost);
            queue.insertOrUpdate(targetFpr, cost);
        } else {
            cost = new Cost(0, 120);
            ((Map)prev).put(targetFpr, new ForwardPointer(null));
            ((Map)dist).put(targetFpr, cost);
            queue.insertOrUpdate(targetFpr, cost);
        }
        while ((object = queue.pop()) != null && (object = (Fingerprint)((Pair)object).getFirst()) != null) {
            Node signee;
            Cost signeeCost;
            ForwardPointer signeeFp;
            Object signeeFpr = object;
            this.logger.debug("Processing signee {}", signeeFpr);
            Root root = this.roots.get((Fingerprint)signeeFpr);
            if (root != null && root.getAmount() >= 120) {
                this.logger.debug("  Skipping signee that is a fully trusted root");
                continue;
            }
            Intrinsics.checkNotNull(network.nodeByFpr((Fingerprint)signeeFpr));
            Intrinsics.checkNotNull(prev.get(signeeFpr));
            Intrinsics.checkNotNull(dist.get(signeeFpr));
            EdgeComponent edgeComponent2 = signeeFp.getNext();
            this.logger.debug("  Current forward pointer: {}", (Object)(edgeComponent2 != null ? edgeComponent2.getTarget() : null));
            this.logger.debug("  Current cost to target: {}", (Object)signeeCost);
            int curMinLen = Math.max(0, signeeCost.getLength() - 1);
            List<EdgeComponent> ecs = network.certificationsForSignee((Fingerprint)signeeFpr, targetUserid, curMinLen);
            this.logger.debug("  Checking {} certifications for {}:", (Object)ecs.size(), (Object)signee.toString());
            for (EdgeComponent ec : ecs) {
                Cost cost2;
                this.logger.debug("    Certification by {}", (Object)ec.getIssuer().getFingerprint());
                int amount = network.getEffectiveTrustAmount(ec);
                if (amount == 0) {
                    this.logger.debug("      Skipping (effective trust amount is 0)");
                    continue;
                }
                if (Intrinsics.areEqual(signeeFpr, targetFpr) && !Intrinsics.areEqual(ec.getUserId(), targetUserid) && signeeCost.getLength() == 0) {
                    this.logger.debug("      Certification is for the wrong user id ({})", (Object)ec.getUserId());
                    continue;
                }
                if (Intrinsics.areEqual(ec.getUserId(), targetUserid)) {
                    cost2 = new Cost(1, amount);
                } else {
                    if (!this.certificationNetwork && ec.getTrustDepth().compareTo(signeeCost.getLength()) < 0) {
                        this.logger.debug("      Certification does not allow enough depth ({}, needed: {}), skipping", (Object)ec.getTrustDepth(), (Object)signeeCost.getLength());
                        continue;
                    }
                    cost2 = signeeCost.extendBy(amount);
                }
                Cost altCost = cost2;
                this.logger.debug("      Cost to target via {}: {}", (Object)ec.getTarget().getFingerprint(), (Object)altCost);
                Fingerprint issuerFpr = ec.getIssuer().getFingerprint();
                Cost currentCost = dist.get(issuerFpr);
                if (currentCost == null || altCost.compareTo(currentCost) < 0) {
                    this.logger.debug("      Setting forward pointer for {}: {}", (Object)ec.getIssuer(), (Object)ec.getTarget());
                    if (currentCost != null) {
                        this.logger.debug("        (Replaces previous path with cost {})", (Object)currentCost);
                    }
                    ((Map)prev).put(issuerFpr, new ForwardPointer(ec));
                    ((Map)dist).put(issuerFpr, altCost);
                }
                if (currentCost != null) continue;
                this.logger.debug("      Queuing node {}", (Object)ec.getIssuer());
                queue.insertOrUpdate(issuerFpr, altCost);
            }
        }
        return this.reconstructPaths(network, targetUserid, prev, target, dist);
    }

    /*
     * Unable to fully structure code
     */
    private final HashMap<Fingerprint, Pair<Path, Integer>> reconstructPaths(WotNetwork network, String targetUserid, HashMap<Fingerprint, ForwardPointer> bestNextNode, Node target, HashMap<Fingerprint, Cost> dist) {
        paths = new HashMap<Fingerprint, Pair<Path, Integer>>();
        v0 = bestNextNode.entrySet();
        Intrinsics.checkNotNullExpressionValue(v0, "bestNextNode.entries");
        var7_7 = v0;
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filter-Query$reconstructPaths$1 = false;
            if (this.roots.roots().isEmpty()) ** GOTO lbl-1000
            v1 = it.getKey();
            Intrinsics.checkNotNullExpressionValue(v1, "it.key");
            if (this.roots.isRoot((Fingerprint)v1)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filter-Query$reconstructPaths$2 = false;
            if (!(((ForwardPointer)it.getValue()).getNext() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            var11_12 = (Map.Entry)element$iv;
            $i$a$-forEach-Query$reconstructPaths$3 = false;
            Intrinsics.checkNotNullExpressionValue(var11_12, "(issuerFpr, fp)");
            issuerFpr = (Fingerprint)var11_12.getKey();
            fp = (ForwardPointer)var11_12.getValue();
            v3 = fp.getNext();
            Intrinsics.checkNotNull(v3);
            issuer = v3.getIssuer();
            Intrinsics.checkNotNullExpressionValue(issuerFpr, "issuerFpr");
            this.logger.trace("Recovering path starting at {}", (Object)network.nodeByFpr(issuerFpr));
            path = this.assemblePath(target, targetUserid, issuer, bestNextNode);
            v4 = dist.get(issuer.getFingerprint());
            Intrinsics.checkNotNull(v4);
            amount = v4.getAmount();
            var18_21 = new Object[]{target.getFingerprint(), targetUserid, path};
            this.logger.debug("Authenticated <{}, {}>:\n{}", var18_21);
            ((Map)paths).put(issuerFpr, new Pair<Path, Integer>(path, amount));
        }
        return paths;
    }

    private final Path assemblePath(Node target, String targetUserid, Node issuer, HashMap<Fingerprint, ForwardPointer> bestNextNode) {
        boolean bl;
        ForwardPointer forwardPointer = bestNextNode.get(issuer.getFingerprint());
        Intrinsics.checkNotNull(forwardPointer);
        ForwardPointer fp = forwardPointer;
        Path p = new Path(issuer);
        while (fp.getNext() != null) {
            EdgeComponent ec;
            p.append(ec, this.certificationNetwork);
            if (Intrinsics.areEqual(ec.getUserId(), targetUserid)) break;
            Intrinsics.checkNotNull(bestNextNode.get(ec.getTarget().getFingerprint()));
        }
        boolean bl2 = bl = !((Collection)p.getCertifications()).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object[] objectArray = new Object[]{issuer.getFingerprint(), targetUserid, target.getFingerprint(), CollectionsKt.joinToString$default(CollectionsKt.withIndex((Iterable)p.getCertifications()), "\n  ", null, null, 0, null, assemblePath.1.INSTANCE, 30, null)};
        this.logger.trace("\nAssembled path from {} to <{} <-> {}>:\n  {}", objectArray);
        return p;
    }
}

