/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.wot.network.Depth;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.EdgeComponent;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RegexSet;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.query.Path;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\nJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0013J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nR*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\f\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\r\u0012\u0004\u0012\u00020\n0\bj\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\r\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/pgpainless/wot/query/WotNetwork;", "", "network", "Lorg/pgpainless/wot/network/Network;", "certificationNetwork", "", "(Lorg/pgpainless/wot/network/Network;Z)V", "capCertificate", "Ljava/util/HashMap;", "Lorg/pgpainless/wot/network/Fingerprint;", "", "Lkotlin/collections/HashMap;", "suppressPath", "Lkotlin/Pair;", "", "fingerprint", "amount", "certificationsForSignee", "", "Lorg/pgpainless/wot/network/EdgeComponent;", "fpr", "targetUserid", "", "curLen", "getEffectiveTrustAmount", "ec", "getSelfSig", "targetFpr", "isValidTarget", "Lorg/pgpainless/wot/network/Node;", "nodeByFpr", "path", "Lorg/pgpainless/wot/query/Path;", "amountToSuppress", "wot-dijkstra"})
@SourceDebugExtension(value={"SMAP\nWotNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WotNetwork.kt\norg/pgpainless/wot/query/WotNetwork\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,148:1\n1549#2:149\n1620#2,2:150\n1622#2:156\n766#2:157\n857#2,2:158\n125#3:152\n152#3,3:153\n*S KotlinDebug\n*F\n+ 1 WotNetwork.kt\norg/pgpainless/wot/query/WotNetwork\n*L\n51#1:149\n51#1:150,2\n51#1:156\n55#1:157\n55#1:158,2\n52#1:152\n52#1:153,3\n*E\n"})
public final class WotNetwork {
    @NotNull
    private final Network network;
    private final boolean certificationNetwork;
    @NotNull
    private final HashMap<Fingerprint, Integer> capCertificate;
    @NotNull
    private final HashMap<Pair<Fingerprint, Fingerprint>, Integer> suppressPath;

    public WotNetwork(@NotNull Network network, boolean certificationNetwork) {
        Intrinsics.checkNotNullParameter(network, "network");
        this.network = network;
        this.certificationNetwork = certificationNetwork;
        this.capCertificate = new HashMap();
        this.suppressPath = new HashMap();
    }

    @Nullable
    public final Node nodeByFpr(@NotNull Fingerprint fpr) {
        Intrinsics.checkNotNullParameter(fpr, "fpr");
        return this.network.getNodes().get(fpr);
    }

    @Nullable
    public final EdgeComponent getSelfSig(@NotNull Fingerprint targetFpr, @NotNull String targetUserid) {
        Intrinsics.checkNotNullParameter(targetFpr, "targetFpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        Node target = this.nodeByFpr(targetFpr);
        Object object = target;
        if ((object != null && (object = ((Node)object).getUserIds()) != null ? (RevocationState)object.get(targetUserid) : null) != null) {
            return new EdgeComponent(target, target, targetUserid, this.network.getReferenceTime().getTimestamp(), null, true, 120, Depth.Companion.limited(0), RegexSet.Companion.wildcard());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EdgeComponent> certificationsForSignee(@NotNull Fingerprint fpr, @NotNull String targetUserid, int curLen) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fpr, "fpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        List<Edge> list = this.network.getReverseEdges().get(fpr);
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<Edge> edges = list;
        Iterable $this$map$iv = edges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void edge;
            Edge edge2 = (Edge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<String, List<EdgeComponent>> $this$map$iv2 = edge.getComponents();
            boolean $i$f$map2 = false;
            Map<String, List<EdgeComponent>> map = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = iterator2.next();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add((List)it.getValue());
            }
            collection.add(CollectionsKt.flatten((List)destination$iv$iv2));
        }
        $this$map$iv = CollectionsKt.flatten((List)destination$iv$iv);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EdgeComponent it = (EdgeComponent)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !this.certificationNetwork ? it.getTrustDepth().compareTo(curLen) >= 0 && it.getRegexes().matches(targetUserid) : true;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ec = (List)destination$iv$iv;
        return ec;
    }

    @Nullable
    public final Node isValidTarget(@NotNull Fingerprint targetFpr, @NotNull String targetUserid) {
        Intrinsics.checkNotNullParameter(targetFpr, "targetFpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        Node node = this.nodeByFpr(targetFpr);
        if (node == null) {
            return null;
        }
        Node target = node;
        if (target.getExpirationTime() != null && target.getExpirationTime().compareTo(this.network.getReferenceTime().getTimestamp()) <= 0) {
            return null;
        }
        if (target.getRevocationState().isEffective(this.network.getReferenceTime())) {
            return null;
        }
        RevocationState targetUa = target.getUserIds().get(targetUserid);
        if (targetUa != null && targetUa.isEffective(this.network.getReferenceTime())) {
            return null;
        }
        return target;
    }

    public final int getEffectiveTrustAmount(@NotNull EdgeComponent ec) {
        int amount;
        block2: {
            Integer it;
            Intrinsics.checkNotNullParameter(ec, "ec");
            amount = 0;
            amount = ec.getTrustAmount();
            Integer n = this.capCertificate.get(ec.getIssuer().getFingerprint());
            if (n != null) {
                it = n;
                boolean bl = false;
                if (it < amount) {
                    amount = it;
                }
            }
            Integer n2 = this.suppressPath.get(new Pair<Fingerprint, Fingerprint>(ec.getIssuer().getFingerprint(), ec.getTarget().getFingerprint()));
            if (n2 == null) break block2;
            it = n2;
            boolean bl = false;
            amount = amount > it ? (amount -= it.intValue()) : 0;
        }
        return amount;
    }

    public final void capCertificate(@NotNull Fingerprint fingerprint, int amount) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        Integer n = amount;
        ((Map)this.capCertificate).put(fingerprint, n);
    }

    public final void suppressPath(@NotNull Path path, int amountToSuppress) {
        boolean bl;
        Intrinsics.checkNotNullParameter(path, "path");
        if (amountToSuppress == 0) {
            return;
        }
        boolean bl2 = bl = amountToSuppress <= 120;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (EdgeComponent c : path.getCertifications()) {
            int curAmount;
            int newAmount;
            boolean bl3;
            Integer n = this.suppressPath.get(new Pair<Fingerprint, Fingerprint>(c.getIssuer().getFingerprint(), c.getTarget().getFingerprint()));
            if (n == null) {
                n = 0;
            }
            boolean bl4 = bl3 = (newAmount = (curAmount = ((Number)n).intValue()) + amountToSuppress) <= 120;
            if (_Assertions.ENABLED && !bl3) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Integer n2 = newAmount;
            ((Map)this.suppressPath).put(new Pair<Fingerprint, Fingerprint>(c.getIssuer().getFingerprint(), c.getTarget().getFingerprint()), n2);
        }
    }
}

