/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import pgp.cert_d.PGPCertificateDirectory;
import pgp.cert_d.SpecialNames;
import pgp.certificate_store.PGPCertificateStore;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.certificate.KeyMaterialMerger;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;

public class PGPCertificateStoreAdapter
implements PGPCertificateStore {
    private final PGPCertificateDirectory directory;

    public PGPCertificateStoreAdapter(PGPCertificateDirectory directory) {
        this.directory = directory;
    }

    @Override
    public Certificate getCertificate(String identifier) throws IOException, BadNameException, BadDataException {
        if (SpecialNames.lookupSpecialName(identifier) != null) {
            return this.directory.getBySpecialName(identifier);
        }
        return this.directory.getByFingerprint(identifier.toLowerCase());
    }

    @Override
    public Certificate getCertificateIfChanged(String identifier, Long tag) throws IOException, BadNameException, BadDataException {
        if (SpecialNames.lookupSpecialName(identifier) != null) {
            return this.directory.getBySpecialNameIfChanged(identifier, tag);
        }
        return this.directory.getByFingerprintIfChanged(identifier.toLowerCase(), tag);
    }

    @Override
    public Iterator<Certificate> getCertificatesBySubkeyId(long subkeyId) throws IOException, BadDataException {
        Set<String> fingerprints = this.directory.getCertificateFingerprintsForSubkeyId(subkeyId);
        HashSet<Certificate> certificates = new HashSet<Certificate>();
        for (String fingerprint : fingerprints) {
            try {
                certificates.add(this.directory.getByFingerprint(fingerprint));
            }
            catch (BadNameException e) {
                throw new RuntimeException(e);
            }
        }
        return certificates.iterator();
    }

    @Override
    public Certificate insertCertificate(InputStream data, KeyMaterialMerger merge) throws IOException, InterruptedException, BadDataException {
        Certificate certificate = this.directory.insert(data, merge);
        return certificate;
    }

    @Override
    public Certificate insertCertificateBySpecialName(String specialName, InputStream data, KeyMaterialMerger merge) throws IOException, InterruptedException, BadDataException, BadNameException {
        return this.directory.insertWithSpecialName(specialName, data, merge);
    }

    @Override
    public Iterator<Certificate> getCertificates() {
        return this.directory.items();
    }

    @Override
    public Iterator<String> getFingerprints() {
        return this.directory.fingerprints();
    }
}

