/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d.backend;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import pgp.cert_d.PGPCertificateDirectory;
import pgp.cert_d.SpecialNames;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.certificate.Key;
import pgp.certificate_store.certificate.KeyMaterial;
import pgp.certificate_store.certificate.KeyMaterialMerger;
import pgp.certificate_store.certificate.KeyMaterialReaderBackend;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;
import pgp.certificate_store.exception.NotAStoreException;

public class FileBasedCertificateDirectoryBackend
implements PGPCertificateDirectory.Backend {
    private final File baseDirectory;
    private final PGPCertificateDirectory.LockingMechanism lock;
    private final FilenameResolver resolver;
    private final KeyMaterialReaderBackend reader;

    public FileBasedCertificateDirectoryBackend(File baseDirectory, KeyMaterialReaderBackend reader) throws NotAStoreException {
        this.baseDirectory = baseDirectory;
        this.resolver = new FilenameResolver(baseDirectory);
        if (!baseDirectory.exists()) {
            if (!baseDirectory.mkdirs()) {
                throw new NotAStoreException("Cannot create base directory '" + this.resolver.getBaseDirectory().getAbsolutePath() + "'");
            }
        } else if (baseDirectory.isFile()) {
            throw new NotAStoreException("Base directory '" + this.resolver.getBaseDirectory().getAbsolutePath() + "' appears to be a file.");
        }
        this.lock = FileLockingMechanism.defaultDirectoryFileLock(baseDirectory);
        this.reader = reader;
    }

    @Override
    public PGPCertificateDirectory.LockingMechanism getLock() {
        return this.lock;
    }

    @Override
    public Certificate readByFingerprint(String fingerprint) throws BadNameException, IOException, BadDataException {
        File certFile = this.resolver.getCertFileByFingerprint(fingerprint);
        if (!certFile.exists()) {
            return null;
        }
        FileInputStream fileIn = new FileInputStream(certFile);
        BufferedInputStream bufferedIn = new BufferedInputStream(fileIn);
        long tag = this.getTagForFingerprint(fingerprint);
        Certificate certificate = this.reader.read(bufferedIn, tag).asCertificate();
        if (!certificate.getFingerprint().equals(fingerprint)) {
            throw new BadDataException();
        }
        return certificate;
    }

    @Override
    public KeyMaterial readBySpecialName(String specialName) throws BadNameException, IOException, BadDataException {
        File certFile = this.resolver.getCertFileBySpecialName(specialName);
        if (!certFile.exists()) {
            return null;
        }
        long tag = this.getTagForSpecialName(specialName);
        FileInputStream fileIn = new FileInputStream(certFile);
        BufferedInputStream bufferedIn = new BufferedInputStream(fileIn);
        KeyMaterial keyMaterial = this.reader.read(bufferedIn, tag);
        return keyMaterial;
    }

    @Override
    public Iterator<Certificate> readItems() {
        return new Iterator<Certificate>(){
            private final List<Lazy<Certificate>> certificateQueue = Collections.synchronizedList(new ArrayList());
            {
                File[] subdirectories = FileBasedCertificateDirectoryBackend.this.baseDirectory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().matches("^[a-f0-9]{2}$");
                    }
                });
                if (subdirectories == null) {
                    subdirectories = new File[]{};
                }
                for (final File subdirectory : subdirectories) {
                    File[] files = subdirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isFile() && file.getName().matches("^[a-f0-9]{38}$");
                        }
                    });
                    if (files == null) {
                        files = new File[]{};
                    }
                    for (final File certFile : files) {
                        this.certificateQueue.add(new Lazy<Certificate>(){

                            @Override
                            Certificate get() throws BadDataException {
                                try {
                                    long tag = FileBasedCertificateDirectoryBackend.this.getTag(certFile);
                                    Certificate certificate = FileBasedCertificateDirectoryBackend.this.reader.read(new FileInputStream(certFile), tag).asCertificate();
                                    if (!(subdirectory.getName() + certFile.getName()).equals(certificate.getFingerprint())) {
                                        throw new BadDataException();
                                    }
                                    return certificate;
                                }
                                catch (IOException e) {
                                    throw new AssertionError((Object)"File got deleted.");
                                }
                            }
                        });
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return !this.certificateQueue.isEmpty();
            }

            @Override
            public Certificate next() {
                try {
                    return this.certificateQueue.remove(0).get();
                }
                catch (BadDataException e) {
                    throw new AssertionError((Object)("Could not retrieve item: " + e.getMessage()));
                }
            }
        };
    }

    @Override
    public KeyMaterial doInsertTrustRoot(InputStream data, KeyMaterialMerger merge) throws BadDataException, IOException {
        File certFile;
        KeyMaterial existingCertificate;
        KeyMaterial newCertificate = this.reader.read(data, null);
        try {
            existingCertificate = this.readBySpecialName("trust-root");
            certFile = this.resolver.getCertFileBySpecialName("trust-root");
        }
        catch (BadNameException e) {
            throw new BadDataException();
        }
        if (existingCertificate != null) {
            newCertificate = merge.merge(newCertificate, existingCertificate);
        }
        long tag = this.writeToFile(newCertificate.getInputStream(), certFile);
        newCertificate = newCertificate instanceof Key ? new Key((Key)newCertificate, tag) : new Certificate((Certificate)newCertificate, tag);
        return newCertificate;
    }

    @Override
    public Certificate doInsert(InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException {
        File certFile;
        Certificate existingCertificate;
        KeyMaterial newCertificate = this.reader.read(data, null);
        try {
            existingCertificate = this.readByFingerprint(newCertificate.getFingerprint());
            certFile = this.resolver.getCertFileByFingerprint(newCertificate.getFingerprint());
        }
        catch (BadNameException e) {
            throw new BadDataException();
        }
        if (existingCertificate != null) {
            newCertificate = merge.merge(newCertificate, existingCertificate);
        }
        long tag = this.writeToFile(newCertificate.getInputStream(), certFile);
        return new Certificate(newCertificate.asCertificate(), tag);
    }

    @Override
    public Certificate doInsertWithSpecialName(String specialName, InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException, BadNameException {
        File certFile;
        KeyMaterial existingCertificate;
        KeyMaterial newCertificate = this.reader.read(data, null);
        try {
            existingCertificate = this.readBySpecialName(specialName);
            certFile = this.resolver.getCertFileBySpecialName(specialName);
        }
        catch (BadNameException e) {
            throw new BadDataException();
        }
        if (existingCertificate != null) {
            newCertificate = merge.merge(newCertificate, existingCertificate);
        }
        long tag = this.writeToFile(newCertificate.getInputStream(), certFile);
        return new Certificate(newCertificate.asCertificate(), tag);
    }

    @Override
    public Long getTagForFingerprint(String fingerprint) throws BadNameException, IOException {
        File file = this.resolver.getCertFileByFingerprint(fingerprint);
        return this.getTag(file);
    }

    @Override
    public Long getTagForSpecialName(String specialName) throws BadNameException, IOException {
        File file = this.resolver.getCertFileBySpecialName(specialName);
        return this.getTag(file);
    }

    private Long getTag(File file) throws IOException {
        if (!file.exists()) {
            throw new NoSuchElementException();
        }
        Path path = file.toPath();
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        int fileId = attrs.fileKey().hashCode();
        long lastMod = attrs.lastModifiedTime().toMillis();
        return lastMod + 11L * (long)fileId;
    }

    private long writeToFile(InputStream inputStream, File certFile) throws IOException {
        int read;
        certFile.getParentFile().mkdirs();
        if (!certFile.exists() && !certFile.createNewFile()) {
            throw new IOException("Could not create cert file " + certFile.getAbsolutePath());
        }
        FileOutputStream fileOut = new FileOutputStream(certFile);
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer)) != -1) {
            fileOut.write(buffer, 0, read);
        }
        inputStream.close();
        fileOut.close();
        return this.getTag(certFile);
    }

    public static class FilenameResolver {
        private final File baseDirectory;
        private final Pattern openPgpFingerprint = Pattern.compile("^[a-f0-9]{40}([a-f0-9]{24})?$");

        public FilenameResolver(File baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        public File getBaseDirectory() {
            return this.baseDirectory;
        }

        public File getCertFileByFingerprint(String fingerprint) throws BadNameException {
            if (!this.isFingerprint(fingerprint)) {
                throw new BadNameException();
            }
            File subdirectory = new File(this.getBaseDirectory(), fingerprint.substring(0, 2));
            File file = new File(subdirectory, fingerprint.substring(2));
            return file;
        }

        public File getCertFileBySpecialName(String specialName) throws BadNameException {
            if (!this.isSpecialName(specialName)) {
                throw new BadNameException(String.format("%s is not a known special name", specialName));
            }
            return new File(this.getBaseDirectory(), specialName);
        }

        private boolean isFingerprint(String fingerprint) {
            return this.openPgpFingerprint.matcher(fingerprint).matches();
        }

        private boolean isSpecialName(String specialName) {
            return SpecialNames.lookupSpecialName(specialName) != null;
        }
    }

    private static class FileLockingMechanism
    implements PGPCertificateDirectory.LockingMechanism {
        private final File lockFile;
        private RandomAccessFile randomAccessFile;
        private FileLock fileLock;

        FileLockingMechanism(File lockFile) {
            this.lockFile = lockFile;
        }

        public static FileLockingMechanism defaultDirectoryFileLock(File baseDirectory) {
            return new FileLockingMechanism(new File(baseDirectory, "writelock"));
        }

        @Override
        public synchronized void lockDirectory() throws IOException, InterruptedException {
            if (this.randomAccessFile != null) {
                this.wait();
            }
            try {
                this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
            }
            catch (FileNotFoundException e) {
                this.lockFile.createNewFile();
                this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
            }
            this.fileLock = this.randomAccessFile.getChannel().lock();
        }

        @Override
        public synchronized boolean tryLockDirectory() throws IOException {
            if (this.randomAccessFile != null) {
                return false;
            }
            try {
                this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
            }
            catch (FileNotFoundException e) {
                this.lockFile.createNewFile();
                this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
            }
            try {
                this.fileLock = this.randomAccessFile.getChannel().tryLock();
                if (this.fileLock == null) {
                    this.randomAccessFile.close();
                    this.randomAccessFile = null;
                    return false;
                }
            }
            catch (OverlappingFileLockException e) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
                return false;
            }
            return true;
        }

        @Override
        public boolean isLocked() {
            return this.randomAccessFile != null;
        }

        @Override
        public synchronized void releaseDirectory() throws IOException {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            if (this.lockFile.exists()) {
                this.lockFile.delete();
            }
            this.notify();
        }
    }

    private static abstract class Lazy<E> {
        private Lazy() {
        }

        abstract E get() throws BadDataException;
    }
}

