/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.certificate_store;

import java.io.File;
import org.pgpainless.certificate_store.KeyMaterialReader;
import pgp.cert_d.BaseDirectoryProvider;
import pgp.cert_d.PGPCertificateDirectory;
import pgp.cert_d.backend.FileBasedCertificateDirectoryBackend;
import pgp.cert_d.backend.InMemoryCertificateDirectoryBackend;
import pgp.cert_d.subkey_lookup.InMemorySubkeyLookup;
import pgp.cert_d.subkey_lookup.SubkeyLookup;
import pgp.cert_d.subkey_lookup.SubkeyLookupFactory;
import pgp.certificate_store.exception.NotAStoreException;

public class PGPainlessCertD
extends PGPCertificateDirectory {
    private static final KeyMaterialReader keyMaterialReader = new KeyMaterialReader();

    public PGPainlessCertD(PGPCertificateDirectory.Backend backend, SubkeyLookup subkeyLookup) {
        super(backend, subkeyLookup);
    }

    public static PGPainlessCertD inMemory() {
        InMemoryCertificateDirectoryBackend backend = new InMemoryCertificateDirectoryBackend(keyMaterialReader);
        InMemorySubkeyLookup subkeyLookup = new InMemorySubkeyLookup();
        return new PGPainlessCertD(backend, subkeyLookup);
    }

    public static PGPainlessCertD fileBased(SubkeyLookupFactory subkeyLookupFactory) throws NotAStoreException {
        return PGPainlessCertD.fileBased(BaseDirectoryProvider.getDefaultBaseDir(), subkeyLookupFactory);
    }

    public static PGPainlessCertD fileBased(File baseDirectory, SubkeyLookupFactory subkeyLookupFactory) throws NotAStoreException {
        FileBasedCertificateDirectoryBackend backend = new FileBasedCertificateDirectoryBackend(baseDirectory, keyMaterialReader);
        SubkeyLookup subkeyLookup = subkeyLookupFactory.createFileBasedInstance(baseDirectory);
        return new PGPainlessCertD(backend, subkeyLookup);
    }
}

