/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection.fixes;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;

public final class S2KUsageFix {
    private S2KUsageFix() {
    }

    public static PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(PGPSecretKeyRing keys2, SecretKeyRingProtector protector) throws PGPException {
        return S2KUsageFix.replaceUsageChecksumWithUsageSha1(keys2, protector, false);
    }

    public static PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(PGPSecretKeyRing keys2, SecretKeyRingProtector protector, boolean skipKeysWithMissingPassphrase) throws PGPException {
        PGPDigestCalculator digestCalculator = ImplementationFactory.getInstance().getPGPDigestCalculator(HashAlgorithm.SHA1);
        for (PGPSecretKey key : keys2) {
            if (key.getS2KUsage() != 255) continue;
            long keyId = key.getKeyID();
            PBESecretKeyEncryptor encryptor = protector.getEncryptor(keyId);
            if (encryptor == null) {
                if (skipKeysWithMissingPassphrase) continue;
                throw new WrongPassphraseException("Missing passphrase for key with ID " + Long.toHexString(keyId));
            }
            PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(key, protector);
            PGPSecretKey fixedKey = new PGPSecretKey(privateKey, key.getPublicKey(), digestCalculator, key.isMasterKey(), protector.getEncryptor(keyId));
            keys2 = PGPSecretKeyRing.insertSecretKey(keys2, fixedKey);
        }
        return keys2;
    }
}

