/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    @Nonnull
    public static <I> List<I> iteratorToList(@Nonnull Iterator<I> iterator2) {
        ArrayList<I> items = new ArrayList<I>();
        while (iterator2.hasNext()) {
            I item = iterator2.next();
            items.add(item);
        }
        return items;
    }

    @Nonnull
    public static <T> T[] concat(@Nonnull T t, @Nonnull T[] ts) {
        Object[] concat = (Object[])Array.newInstance(t.getClass(), ts.length + 1);
        concat[0] = t;
        System.arraycopy(ts, 0, concat, 1, ts.length);
        return concat;
    }

    public static <T> boolean contains(@Nonnull T[] ts, @Nonnull T t) {
        for (T i : ts) {
            if (!i.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> void addAll(@Nonnull Iterator<T> iterator2, @Nonnull Collection<T> collection) {
        while (iterator2.hasNext()) {
            collection.add(iterator2.next());
        }
    }
}

