/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MultiMap<K, V> {
    private final Map<K, Set<V>> map;

    public MultiMap() {
        this.map = new HashMap<K, Set<V>>();
    }

    public MultiMap(@Nonnull MultiMap<K, V> other) {
        this.map = new HashMap<K, Set<V>>();
        for (K k : other.map.keySet()) {
            this.map.put(k, new LinkedHashSet(other.map.get(k)));
        }
    }

    public MultiMap(@Nonnull Map<K, Set<V>> content) {
        this.map = new HashMap<K, Set<Set<V>>>(content);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K o) {
        return this.map.containsKey(o);
    }

    public boolean containsValue(V o) {
        for (Set<V> values2 : this.map.values()) {
            if (!values2.contains(o)) continue;
            return true;
        }
        return false;
    }

    public Set<V> get(K o) {
        return this.map.get(o);
    }

    public void put(K k, V v) {
        Set<V> values2 = this.map.get(k);
        if (values2 == null) {
            values2 = new LinkedHashSet<V>();
            this.map.put(k, values2);
        }
        values2.add(v);
    }

    public void put(K k, Set<V> vs) {
        for (V v : vs) {
            this.put(k, v);
        }
    }

    public void removeAll(K o) {
        this.map.remove(o);
    }

    public void remove(K o, V v) {
        Set<V> vs = this.map.get(o);
        if (vs == null) {
            return;
        }
        vs.remove(v);
    }

    public void putAll(MultiMap<K, V> other) {
        for (K key : other.keySet()) {
            this.put(key, other.get(key));
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<Set<V>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    public Set<V> flatten() {
        LinkedHashSet<V> flattened = new LinkedHashSet<V>();
        for (Set<V> items : this.map.values()) {
            flattened.addAll(items);
        }
        return flattened;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return this.map.equals(((MultiMap)o).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

