/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.consumer.SignatureValidator;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.wot.PGPNetworkParser;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.util.CertificationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pgp.cert_d.PGPCertificateDirectory;
import pgp.cert_d.PGPCertificateStoreAdapter;
import pgp.certificate_store.PGPCertificateStore;
import pgp.certificate_store.certificate.Certificate;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/wot/PGPNetworkParser;", "", "certificateDirectory", "Lpgp/cert_d/PGPCertificateDirectory;", "(Lpgp/cert_d/PGPCertificateDirectory;)V", "certificateStore", "Lpgp/certificate_store/PGPCertificateStore;", "(Lpgp/certificate_store/PGPCertificateStore;)V", "buildNetwork", "Lorg/pgpainless/wot/network/Network;", "policy", "Lorg/pgpainless/policy/Policy;", "referenceTime", "Ljava/util/Date;", "getAllCertificatesFromTheStore", "Lkotlin/sequences/Sequence;", "Lpgp/certificate_store/certificate/Certificate;", "Companion", "PGPNetworkFactory", "pgpainless-wot"})
public final class PGPNetworkParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPCertificateStore certificateStore;

    public PGPNetworkParser(@NotNull PGPCertificateStore certificateStore) {
        Intrinsics.checkNotNullParameter(certificateStore, "certificateStore");
        this.certificateStore = certificateStore;
    }

    public PGPNetworkParser(@NotNull PGPCertificateDirectory certificateDirectory) {
        Intrinsics.checkNotNullParameter(certificateDirectory, "certificateDirectory");
        this(new PGPCertificateStoreAdapter(certificateDirectory));
    }

    @NotNull
    public final Network buildNetwork(@NotNull Policy policy, @NotNull Date referenceTime) {
        Intrinsics.checkNotNullParameter(policy, "policy");
        Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
        Sequence<Certificate> certificates = this.getAllCertificatesFromTheStore();
        PGPNetworkFactory networkFactory = PGPNetworkFactory.Companion.fromCertificates(certificates, policy, referenceTime);
        return networkFactory.buildNetwork();
    }

    public static /* synthetic */ Network buildNetwork$default(PGPNetworkParser pGPNetworkParser, Policy policy, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            Policy policy2 = PGPainless.getPolicy();
            Intrinsics.checkNotNullExpressionValue(policy2, "getPolicy()");
            policy = policy2;
        }
        if ((n & 2) != 0) {
            date = new Date();
        }
        return pGPNetworkParser.buildNetwork(policy, date);
    }

    private final Sequence<Certificate> getAllCertificatesFromTheStore() {
        Sequence<Certificate> sequence;
        Certificate trustRoot = null;
        try {
            trustRoot = this.certificateStore.getCertificate("trust-root");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (trustRoot == null) {
            Iterator<Certificate> iterator2 = this.certificateStore.getCertificates();
            Intrinsics.checkNotNullExpressionValue(iterator2, "certificateStore.certificates");
            sequence = SequencesKt.asSequence(iterator2);
        } else {
            Certificate[] certificateArray = new Certificate[]{trustRoot};
            Sequence<Certificate> sequence2 = SequencesKt.sequenceOf(certificateArray);
            Iterator<Certificate> iterator3 = this.certificateStore.getCertificates();
            Intrinsics.checkNotNullExpressionValue(iterator3, "certificateStore.certificates");
            sequence = SequencesKt.plus(sequence2, SequencesKt.asSequence(iterator3));
        }
        Sequence<Certificate> certificates = sequence;
        return certificates;
    }

    @JvmStatic
    @NotNull
    public static final RevocationState RevocationState(@Nullable PGPSignature revocation) {
        return Companion.RevocationState(revocation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/wot/PGPNetworkParser$Companion;", "", "()V", "RevocationState", "Lorg/pgpainless/wot/network/RevocationState;", "revocation", "Lorg/bouncycastle/openpgp/PGPSignature;", "pgpainless-wot"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RevocationState RevocationState(@Nullable PGPSignature revocation) {
            RevocationState revocationState;
            if (revocation == null) {
                return RevocationState.Companion.notRevoked();
            }
            RevocationReason revocationReason = SignatureSubpacketsUtil.getRevocationReason(revocation);
            if (revocationReason == null) {
                return RevocationState.Companion.hardRevoked();
            }
            RevocationReason revocationReason2 = revocationReason;
            if (RevocationAttributes.Reason.isHardRevocation(revocationReason2.getRevocationReason())) {
                revocationState = RevocationState.Companion.hardRevoked();
            } else {
                Date date = revocation.getCreationTime();
                Intrinsics.checkNotNullExpressionValue(date, "revocation.creationTime");
                revocationState = RevocationState.Companion.softRevoked(date);
            }
            return revocationState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J(\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010'\u001a\u00020%H\u0002J.\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u0006R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/pgpainless/wot/PGPNetworkParser$PGPNetworkFactory;", "", "validatedCertificates", "", "Lorg/pgpainless/key/info/KeyRingInfo;", "policy", "Lorg/pgpainless/policy/Policy;", "referenceTime", "Ljava/util/Date;", "(Ljava/util/List;Lorg/pgpainless/policy/Policy;Ljava/util/Date;)V", "byFingerprint", "", "Lorg/pgpainless/wot/network/Identifier;", "byKeyId", "", "", "networkBuilder", "Lorg/pgpainless/wot/network/Network$Builder;", "nodeMap", "Lorg/pgpainless/wot/network/Node;", "Fingerprint", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "buildNetwork", "Lorg/pgpainless/wot/network/Network;", "indexAsNode", "", "cert", "indexIncomingEdges", "validatedTarget", "processCertificationOnUserId", "targetPrimaryKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "target", "userId", "", "certification", "Lorg/bouncycastle/openpgp/PGPSignature;", "processDelegation", "delegation", "verifyCommonSignatureCriteria", "", "issuer", "signature", "signingKey", "signedKey", "Companion", "pgpainless-wot"})
    @SourceDebugExtension(value={"SMAP\nPGPNetworkParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPNetworkParser.kt\norg/pgpainless/wot/PGPNetworkParser$PGPNetworkFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,397:1\n1855#2,2:398\n1855#2,2:400\n1271#2,2:411\n1285#2,4:413\n1855#2,2:417\n32#3:402\n33#3:410\n361#4,7:403\n*S KotlinDebug\n*F\n+ 1 PGPNetworkParser.kt\norg/pgpainless/wot/PGPNetworkParser$PGPNetworkFactory\n*L\n104#1:398,2\n105#1:400,2\n137#1:411,2\n137#1:413,4\n173#1:417,2\n132#1:402\n132#1:410\n133#1:403,7\n*E\n"})
    private static final class PGPNetworkFactory {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Policy policy;
        @NotNull
        private final Date referenceTime;
        @NotNull
        private final Network.Builder networkBuilder;
        @NotNull
        private final Map<Identifier, KeyRingInfo> byFingerprint;
        @NotNull
        private final Map<Long, List<KeyRingInfo>> byKeyId;
        @NotNull
        private final Map<Identifier, Node> nodeMap;
        private static final Logger LOGGER = LoggerFactory.getLogger(PGPNetworkFactory.class);

        private PGPNetworkFactory(List<? extends KeyRingInfo> validatedCertificates, Policy policy, Date referenceTime) {
            KeyRingInfo it;
            this.policy = policy;
            this.referenceTime = referenceTime;
            this.networkBuilder = Network.Companion.builder();
            this.byFingerprint = new HashMap();
            this.byKeyId = new HashMap();
            this.nodeMap = new HashMap();
            Iterable $this$forEach$iv = validatedCertificates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KeyRingInfo)element$iv;
                boolean bl = false;
                this.indexAsNode(it);
            }
            $this$forEach$iv = validatedCertificates;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KeyRingInfo)element$iv;
                boolean bl = false;
                this.indexIncomingEdges(it);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void indexAsNode(KeyRingInfo cert) {
            Date date;
            try {
                date = cert.getExpirationDateForUse(KeyFlag.CERTIFY_OTHER);
            }
            catch (NoSuchElementException e) {
                LOGGER.warn("Could not deduce expiration time of " + cert.getFingerprint() + ". Possibly hard revoked cert or illegal algorithms? Skip certificate.");
                return;
            }
            Date expirationDate = date;
            OpenPgpFingerprint openPgpFingerprint = cert.getFingerprint();
            Intrinsics.checkNotNullExpressionValue(openPgpFingerprint, "cert.fingerprint");
            Identifier certFingerprint = this.Fingerprint(openPgpFingerprint);
            this.byFingerprint.putIfAbsent(certFingerprint, cert);
            Iterator<PGPPublicKey> iterator2 = cert.getKeys().getPublicKeys();
            Intrinsics.checkNotNullExpressionValue(iterator2, "cert.keys.publicKeys");
            Iterator<PGPPublicKey> $this$forEach$iv = iterator2;
            boolean $i$f$forEach = false;
            Iterator<PGPPublicKey> iterator3 = $this$forEach$iv;
            while (iterator3.hasNext()) {
                Object object;
                void $this$getOrPut$iv;
                PGPPublicKey element$iv;
                PGPPublicKey it = element$iv = iterator3.next();
                boolean bl = false;
                Map<Long, List<KeyRingInfo>> map = this.byKeyId;
                Long key$iv = it.getKeyID();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(cert);
            }
            List<String> list = cert.getUserIds();
            Intrinsics.checkNotNullExpressionValue(list, "cert.userIds");
            Iterable $this$associateWith$iv = list;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String $i$f$getOrPut = (String)element$iv$iv;
                Object e = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                RevocationState revocationState = Companion.RevocationState(cert.getUserIdRevocation((CharSequence)it));
                map.put(e, revocationState);
            }
            Map userIds = result$iv;
            Node node = new Node(certFingerprint, expirationDate, Companion.RevocationState(cert.getRevocationSelfSignature()), userIds);
            this.nodeMap.put(certFingerprint, node);
            this.networkBuilder.addNode(node);
        }

        private final void indexIncomingEdges(KeyRingInfo validatedTarget) {
            PGPPublicKeyRing pGPPublicKeyRing = KeyRingUtils.publicKeys(validatedTarget.getKeys());
            Intrinsics.checkNotNullExpressionValue(pGPPublicKeyRing, "publicKeys(validatedTarget.keys)");
            PGPPublicKeyRing validatedTargetKeyRing = pGPPublicKeyRing;
            OpenPgpFingerprint openPgpFingerprint = OpenPgpFingerprint.of(validatedTargetKeyRing);
            Intrinsics.checkNotNullExpressionValue(openPgpFingerprint, "of(validatedTargetKeyRing)");
            Identifier targetFingerprint = this.Fingerprint(openPgpFingerprint);
            PGPPublicKey pGPPublicKey = validatedTargetKeyRing.getPublicKey();
            Intrinsics.checkNotNull(pGPPublicKey);
            PGPPublicKey targetPrimaryKey = pGPPublicKey;
            Node node = this.nodeMap.get(targetFingerprint);
            if (node == null) {
                return;
            }
            Node target = node;
            List<PGPSignature> list = SignatureUtils.getDelegations(validatedTargetKeyRing);
            Intrinsics.checkNotNullExpressionValue(list, "getDelegations(validatedTargetKeyRing)");
            List<PGPSignature> delegations = list;
            for (PGPSignature delegation : delegations) {
                Intrinsics.checkNotNullExpressionValue(delegation, "delegation");
                this.processDelegation(targetPrimaryKey, target, delegation);
            }
            Iterator<String> userIds = targetPrimaryKey.getUserIDs();
            while (userIds.hasNext()) {
                List<PGPSignature> userIdSigs;
                String userId = userIds.next();
                Intrinsics.checkNotNullExpressionValue(SignatureUtils.get3rdPartyCertificationsFor(userId, validatedTargetKeyRing), "get3rdPartyCertification\u2026, validatedTargetKeyRing)");
                Iterable $this$forEach$iv = userIdSigs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PGPSignature it = (PGPSignature)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(userId, "userId");
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    this.processCertificationOnUserId(targetPrimaryKey, target, userId, it);
                }
            }
        }

        private final void processDelegation(PGPPublicKey targetPrimaryKey, Node target, PGPSignature delegation) {
            List<KeyRingInfo> list = this.byKeyId.get(delegation.getKeyID());
            if (list == null) {
                return;
            }
            List<KeyRingInfo> issuerCandidates = list;
            for (KeyRingInfo candidate : issuerCandidates) {
                PGPPublicKeyRing issuerKeyRing;
                Intrinsics.checkNotNullExpressionValue(KeyRingUtils.publicKeys(candidate.getKeys()), "publicKeys(candidate.keys)");
                OpenPgpFingerprint openPgpFingerprint = OpenPgpFingerprint.of(issuerKeyRing);
                Intrinsics.checkNotNullExpressionValue(openPgpFingerprint, "of(issuerKeyRing)");
                Identifier issuerFingerprint = this.Fingerprint(openPgpFingerprint);
                Intrinsics.checkNotNull(issuerKeyRing.getPublicKey(delegation.getKeyID()));
                Intrinsics.checkNotNull(this.nodeMap.get(issuerFingerprint));
                try {
                    Node issuer;
                    PGPPublicKey issuerSigningKey;
                    SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.KEY_REVOCATION, SignatureType.DIRECT_KEY};
                    SignatureValidator.signatureIsOfType(signatureTypeArray).verify(delegation);
                    this.verifyCommonSignatureCriteria(candidate, delegation, issuerSigningKey, targetPrimaryKey, this.policy);
                    SignatureValidator.correctSignatureOverKey(issuerSigningKey, targetPrimaryKey).verify(delegation);
                    this.networkBuilder.addEdge(CertificationFactory.Companion.fromDelegation(issuer, target, delegation));
                    return;
                }
                catch (SignatureValidationException e) {
                    OpenPgpFingerprint targetFingerprint = OpenPgpFingerprint.of(targetPrimaryKey);
                    LOGGER.warn("Cannot verify signature by " + issuerFingerprint + " on cert of " + targetFingerprint, e);
                }
            }
        }

        private final void processCertificationOnUserId(PGPPublicKey targetPrimaryKey, Node target, String userId, PGPSignature certification) {
            List<KeyRingInfo> list = this.byKeyId.get(certification.getKeyID());
            if (list == null) {
                return;
            }
            List<KeyRingInfo> issuerCandidates = list;
            for (KeyRingInfo candidate : issuerCandidates) {
                PGPPublicKeyRing issuerKeyRing;
                Intrinsics.checkNotNullExpressionValue(KeyRingUtils.publicKeys(candidate.getKeys()), "publicKeys(candidate.keys)");
                OpenPgpFingerprint openPgpFingerprint = OpenPgpFingerprint.of(issuerKeyRing);
                Intrinsics.checkNotNullExpressionValue(openPgpFingerprint, "of(issuerKeyRing)");
                Identifier issuerFingerprint = this.Fingerprint(openPgpFingerprint);
                Intrinsics.checkNotNull(issuerKeyRing.getPublicKey(certification.getKeyID()));
                Intrinsics.checkNotNull(this.nodeMap.get(issuerFingerprint));
                try {
                    Node issuer;
                    PGPPublicKey issuerSigningKey;
                    SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.CERTIFICATION_REVOCATION, SignatureType.GENERIC_CERTIFICATION, SignatureType.NO_CERTIFICATION, SignatureType.CASUAL_CERTIFICATION, SignatureType.POSITIVE_CERTIFICATION};
                    SignatureValidator.signatureIsOfType(signatureTypeArray).verify(certification);
                    this.verifyCommonSignatureCriteria(candidate, certification, issuerSigningKey, targetPrimaryKey, this.policy);
                    SignatureValidator.correctSignatureOverUserId(userId, targetPrimaryKey, issuerSigningKey).verify(certification);
                    this.networkBuilder.addEdge(CertificationFactory.Companion.fromCertification(issuer, target, userId, certification));
                    return;
                }
                catch (SignatureValidationException e) {
                    LOGGER.warn("Cannot verify signature for '" + userId + "' by " + issuerFingerprint + " on cert of " + target.getFingerprint(), e);
                }
            }
        }

        public final boolean verifyCommonSignatureCriteria(@NotNull KeyRingInfo issuer, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey, @NotNull Policy policy) {
            Date exp;
            Intrinsics.checkNotNullParameter(issuer, "issuer");
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter(signingKey, "signingKey");
            Intrinsics.checkNotNullParameter(signedKey, "signedKey");
            Intrinsics.checkNotNullParameter(policy, "policy");
            SignatureValidator.signatureIsNotMalformed(signingKey).verify(signature);
            if (signature.getVersion() >= 4) {
                SignatureValidator.signatureDoesNotHaveCriticalUnknownNotations(policy.getNotationRegistry()).verify(signature);
                SignatureValidator.signatureDoesNotHaveCriticalUnknownSubpackets().verify(signature);
            }
            SignatureValidator.signatureIsEffective(this.referenceTime).verify(signature);
            if (Intrinsics.areEqual(issuer.getRevocationState(), org.pgpainless.algorithm.RevocationState.hardRevoked())) {
                throw new SignatureValidationException("Signature is invalid because certificate " + issuer.getFingerprint() + " is hard revoked.");
            }
            if (issuer.getRevocationState().isSoftRevocation()) {
                SignatureValidator.signatureWasCreatedInBounds(issuer.getCreationDate(), issuer.getRevocationDate()).verify(signature);
            }
            if ((exp = issuer.getPrimaryKeyExpirationDate()) != null) {
                SignatureValidator.signatureWasCreatedInBounds(issuer.getCreationDate(), exp).verify(signature);
            }
            SignatureValidator.signatureUsesAcceptableHashAlgorithm(policy).verify(signature);
            SignatureValidator.signatureUsesAcceptablePublicKeyAlgorithm(policy, signingKey).verify(signature);
            SignatureValidator.signatureDoesNotPredateSignee(signedKey).verify(signature);
            return true;
        }

        private final Identifier Fingerprint(OpenPgpFingerprint fingerprint) {
            String string = fingerprint.toString();
            Intrinsics.checkNotNullExpressionValue(string, "fingerprint.toString()");
            return new Identifier(string);
        }

        @NotNull
        public final Network buildNetwork() {
            return this.networkBuilder.build();
        }

        @JvmStatic
        @NotNull
        public static final PGPNetworkFactory fromCertificates(@NotNull Sequence<? extends Certificate> certificates, @NotNull Policy policy, @NotNull Date referenceTime) {
            return Companion.fromCertificates(certificates, policy, referenceTime);
        }

        @JvmStatic
        @NotNull
        public static final PGPNetworkFactory fromValidCertificates(@NotNull List<? extends KeyRingInfo> certificates, @NotNull Policy policy, @NotNull Date referenceTime) {
            return Companion.fromValidCertificates(certificates, policy, referenceTime);
        }

        @JvmStatic
        private static final List<KeyRingInfo> parseValidCertificates(Sequence<? extends Certificate> certificates, Policy policy, Date referenceTime) {
            return PGPNetworkFactory.Companion.parseValidCertificates(certificates, policy, referenceTime);
        }

        public /* synthetic */ PGPNetworkFactory(List validatedCertificates, Policy policy, Date referenceTime, DefaultConstructorMarker $constructor_marker) {
            this(validatedCertificates, policy, referenceTime);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J&\u0010\u0010\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0014"}, d2={"Lorg/pgpainless/wot/PGPNetworkParser$PGPNetworkFactory$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER$annotations", "fromCertificates", "Lorg/pgpainless/wot/PGPNetworkParser$PGPNetworkFactory;", "certificates", "Lkotlin/sequences/Sequence;", "Lpgp/certificate_store/certificate/Certificate;", "policy", "Lorg/pgpainless/policy/Policy;", "referenceTime", "Ljava/util/Date;", "fromValidCertificates", "", "Lorg/pgpainless/key/info/KeyRingInfo;", "parseValidCertificates", "pgpainless-wot"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            private static /* synthetic */ void getLOGGER$annotations() {
            }

            @JvmStatic
            @NotNull
            public final PGPNetworkFactory fromCertificates(@NotNull Sequence<? extends Certificate> certificates, @NotNull Policy policy, @NotNull Date referenceTime) {
                Intrinsics.checkNotNullParameter(certificates, "certificates");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                return this.fromValidCertificates(this.parseValidCertificates(certificates, policy, referenceTime), policy, referenceTime);
            }

            @JvmStatic
            @NotNull
            public final PGPNetworkFactory fromValidCertificates(@NotNull List<? extends KeyRingInfo> certificates, @NotNull Policy policy, @NotNull Date referenceTime) {
                Intrinsics.checkNotNullParameter(certificates, "certificates");
                Intrinsics.checkNotNullParameter(policy, "policy");
                Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
                return new PGPNetworkFactory(certificates, policy, referenceTime, null);
            }

            @JvmStatic
            private final List<KeyRingInfo> parseValidCertificates(Sequence<? extends Certificate> certificates, Policy policy, Date referenceTime) {
                return SequencesKt.toList(SequencesKt.map(SequencesKt.mapNotNull(certificates, parseValidCertificates.1.INSTANCE), (Function1)new Function1<PGPPublicKeyRing, KeyRingInfo>(policy, referenceTime){
                    final /* synthetic */ Policy $policy;
                    final /* synthetic */ Date $referenceTime;
                    {
                        this.$policy = $policy;
                        this.$referenceTime = $referenceTime;
                        super(1);
                    }

                    @NotNull
                    public final KeyRingInfo invoke(@NotNull PGPPublicKeyRing it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return new KeyRingInfo(it, this.$policy, this.$referenceTime);
                    }
                }));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

