/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.cli;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.wot.KeyRingCertificateStore;
import org.pgpainless.wot.cli.GpgHelper;
import org.pgpainless.wot.network.TrustRoot;
import pgp.certificate_store.PGPCertificateStore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/pgpainless/wot/cli/GpgHelper;", "", "executable", "", "(Ljava/lang/String;)V", "getExecutable", "()Ljava/lang/String;", "readGpgKeyRing", "Lpgp/certificate_store/PGPCertificateStore;", "readGpgOwnertrust", "", "Lorg/pgpainless/wot/network/TrustRoot;", "pgpainless-wot-cli"})
public final class GpgHelper {
    @NotNull
    private final String executable;

    public GpgHelper(@NotNull String executable) {
        Intrinsics.checkNotNullParameter(executable, "executable");
        this.executable = executable;
    }

    @NotNull
    public final String getExecutable() {
        return this.executable;
    }

    @NotNull
    public final PGPCertificateStore readGpgKeyRing() {
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = PGPainless.readKeyRing().publicKeyRingCollection(Runtime.getRuntime().exec(this.executable + " --export").getInputStream());
        Intrinsics.checkNotNullExpressionValue(pGPPublicKeyRingCollection, "readKeyRing().publicKeyR\u2026inputStream\n            )");
        return new KeyRingCertificateStore(pGPPublicKeyRingCollection);
    }

    @NotNull
    public final List<TrustRoot> readGpgOwnertrust() {
        InputStream inputStream = Runtime.getRuntime().exec(this.executable + " --export-ownertrust").getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "getRuntime()\n        .ex\u2026st\")\n        .inputStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filterNot(SequencesKt.map(SequencesKt.map(SequencesKt.filterNot(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)TextStreamsKt.readLines(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), readGpgOwnertrust.1.INSTANCE), readGpgOwnertrust.2.INSTANCE), readGpgOwnertrust.3.INSTANCE), readGpgOwnertrust.4.INSTANCE), readGpgOwnertrust.5.INSTANCE), readGpgOwnertrust.6.INSTANCE));
    }
}

