/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.cli.format;

import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.api.AuthenticateAPI;
import org.pgpainless.wot.api.AuthenticationLevel;
import org.pgpainless.wot.api.Binding;
import org.pgpainless.wot.api.IdentifyAPI;
import org.pgpainless.wot.api.ListAPI;
import org.pgpainless.wot.api.LookupAPI;
import org.pgpainless.wot.cli.format.Formatter;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.query.Path;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/wot/cli/format/SQWOTFormatter;", "Lorg/pgpainless/wot/cli/format/Formatter;", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "certDegree", "", "amount", "", "format", "binding", "Lorg/pgpainless/wot/api/Binding;", "amountMin", "amountReference", "introducerDegree", "introducerType", "edge", "Lorg/pgpainless/wot/network/Edge$Component;", "pgpainless-wot-cli"})
public final class SQWOTFormatter
implements Formatter {
    @NotNull
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    @NotNull
    public String format(@NotNull Binding binding, int amountMin, int amountReference) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(binding, "binding");
        int percentage = binding.percentage(amountReference);
        int bAmount = binding.getPaths().getAmount();
        String authLevel = bAmount >= AuthenticationLevel.Doubly.getAmount() ? "doubly" : (bAmount >= AuthenticationLevel.Fully.getAmount() ? "fully" : (bAmount >= AuthenticationLevel.Partially.getAmount() ? "partially" : (bAmount > 0 ? "marginally" : "not")));
        String checkmark = binding.getPaths().getAmount() >= amountMin ? "[\u2713] " : "[ ] ";
        List<Path> pathList = binding.getPaths().getPaths();
        boolean singlePath = pathList.size() == 1;
        String indent = StringsKt.repeat(" ", singlePath ? 2 : 4);
        StringBuilder $this$format_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$format_u24lambda_u240.append(checkmark);
        StringBuilder stringBuilder2 = $this$format_u24lambda_u240.append(binding.getFingerprint() + ' ' + binding.getUserId() + ": " + authLevel + " authenticated (" + percentage + "%)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        Iterator<Path> iterator2 = pathList.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int pIndex = n++;
            Path path = iterator2.next();
            if (!singlePath) {
                StringBuilder stringBuilder3 = $this$format_u24lambda_u240.append("  Path #" + (pIndex + 1) + " of " + pathList.size() + ", trust amount " + path.getAmount() + ':');
                Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
            }
            String originUserId = path.getRoot().getUserIds().isEmpty() ? "" : (Intrinsics.areEqual(path.getRoot().getFingerprint(), path.getTarget().getFingerprint()) ? " \"" + (String)CollectionsKt.first((Iterable)path.getRoot().getUserIds().keySet()) + '\"' : " (\"" + (String)CollectionsKt.first((Iterable)path.getRoot().getUserIds().keySet()) + "\")");
            $this$format_u24lambda_u240.append(indent);
            StringBuilder stringBuilder4 = $this$format_u24lambda_u240.append("\u25ef " + path.getRoot().getFingerprint() + originUserId);
            Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
            Iterator<Edge.Component> iterator3 = path.getCertifications().iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                int eIndex = n2++;
                Edge.Component edge = iterator3.next();
                String targetUserId = !(edge instanceof Edge.Certification) ? "" : (eIndex == CollectionsKt.getLastIndex(path.getCertifications()) ? " \"" + ((Edge.Certification)edge).getUserId() + '\"' : " (\"" + ((Edge.Certification)edge).getUserId() + "\")");
                $this$format_u24lambda_u240.append(indent);
                StringBuilder stringBuilder5 = $this$format_u24lambda_u240.append("\u2502   " + this.certDegree(edge.getTrustAmount()) + " the following " + (eIndex == CollectionsKt.getLastIndex(path.getCertifications()) ? "binding" : "certificate") + " on " + this.dateFormat.format(edge.getCreationTime()) + (edge.getExpirationTime() == null ? "" : " (expiry: " + this.dateFormat.format(edge.getExpirationTime()) + ')') + this.introducerType(edge));
                Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append('\\n')");
                $this$format_u24lambda_u240.append(indent);
                $this$format_u24lambda_u240.append(eIndex != CollectionsKt.getLastIndex(path.getCertifications()) ? "\u251c " : "\u2514 ");
                StringBuilder stringBuilder6 = $this$format_u24lambda_u240.append(edge.getTarget().getFingerprint() + targetUserId);
                Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append('\\n')");
            }
            if (pIndex == CollectionsKt.getLastIndex(pathList)) continue;
            Intrinsics.checkNotNullExpressionValue($this$format_u24lambda_u240.append('\n'), "append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String introducerDegree(int amount) {
        int n = amount;
        return (1 <= n ? n < 120 : false) ? "partially" : (amount <= 0 ? "not" : "fully");
    }

    private final String introducerType(Edge.Component edge) {
        StringBuilder stringBuilder;
        if (edge.getTrustDepth().compareTo(0) <= 0) {
            return "";
        }
        StringBuilder $this$introducerType_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$introducerType_u24lambda_u241.append(" as a ");
        if (edge.getTrustAmount() < AuthenticationLevel.Fully.getAmount()) {
            $this$introducerType_u24lambda_u241.append("partially trusted (" + edge.getTrustAmount() + " of 120) ");
        } else {
            $this$introducerType_u24lambda_u241.append("fully trusted ");
        }
        if (edge.getTrustDepth().getValue() == 1) {
            $this$introducerType_u24lambda_u241.append("introducer (depth: " + edge.getTrustDepth() + ')');
        } else {
            $this$introducerType_u24lambda_u241.append("meta-introducer (depth: " + edge.getTrustDepth() + ')');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String certDegree(int amount) {
        return amount >= AuthenticationLevel.Fully.getAmount() ? "certified" : "partially certified (amount: " + amount + " of 120)";
    }

    @Override
    @NotNull
    public String format(@NotNull AuthenticateAPI.Result authenticateResult) {
        return Formatter.DefaultImpls.format((Formatter)this, authenticateResult);
    }

    @Override
    @NotNull
    public String format(@NotNull IdentifyAPI.Result identifyResult) {
        return Formatter.DefaultImpls.format((Formatter)this, identifyResult);
    }

    @Override
    @NotNull
    public String format(@NotNull ListAPI.Result listResult) {
        return Formatter.DefaultImpls.format((Formatter)this, listResult);
    }

    @Override
    @NotNull
    public String format(@NotNull LookupAPI.Result lookupResult) {
        return Formatter.DefaultImpls.format((Formatter)this, lookupResult);
    }
}

