/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.cli.subcommands;

import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.wot.api.IdentifyAPI;
import org.pgpainless.wot.cli.WebOfTrustCLI;
import org.pgpainless.wot.cli.converters.FingerprintConverter;
import org.pgpainless.wot.network.Identifier;
import picocli.CommandLine;

@CommandLine.Command(name="identify", description={"Identify a certificate via its fingerprint by determining the authenticity of its user IDs."})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/wot/cli/subcommands/IdentifyCmd;", "Ljava/util/concurrent/Callable;", "", "()V", "fingerprint", "Lorg/pgpainless/wot/network/Identifier;", "getFingerprint", "()Lorg/pgpainless/wot/network/Identifier;", "setFingerprint", "(Lorg/pgpainless/wot/network/Identifier;)V", "parent", "Lorg/pgpainless/wot/cli/WebOfTrustCLI;", "getParent", "()Lorg/pgpainless/wot/cli/WebOfTrustCLI;", "setParent", "(Lorg/pgpainless/wot/cli/WebOfTrustCLI;)V", "call", "()Ljava/lang/Integer;", "pgpainless-wot-cli"})
public final class IdentifyCmd
implements Callable<Integer> {
    @CommandLine.ParentCommand
    public WebOfTrustCLI parent;
    @CommandLine.Parameters(index="0", description={"Certificate fingerprint."}, paramLabel="FINGERPRINT", converter={FingerprintConverter.class})
    public Identifier fingerprint;

    @NotNull
    public final WebOfTrustCLI getParent() {
        WebOfTrustCLI webOfTrustCLI = this.parent;
        if (webOfTrustCLI != null) {
            return webOfTrustCLI;
        }
        Intrinsics.throwUninitializedPropertyAccessException("parent");
        return null;
    }

    public final void setParent(@NotNull WebOfTrustCLI webOfTrustCLI) {
        Intrinsics.checkNotNullParameter(webOfTrustCLI, "<set-?>");
        this.parent = webOfTrustCLI;
    }

    @NotNull
    public final Identifier getFingerprint() {
        Identifier identifier = this.fingerprint;
        if (identifier != null) {
            return identifier;
        }
        Intrinsics.throwUninitializedPropertyAccessException("fingerprint");
        return null;
    }

    public final void setFingerprint(@NotNull Identifier identifier) {
        Intrinsics.checkNotNullParameter(identifier, "<set-?>");
        this.fingerprint = identifier;
    }

    @Override
    @NotNull
    public Integer call() {
        IdentifyAPI.Result result = this.getParent().getApi().identify(this.getFingerprint());
        System.out.print((Object)this.getParent().getOutputFormatter().format(result));
        return result.getAcceptable() ? 0 : 1;
    }
}

