/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/wot/network/Identifier;", "", "fingerprint", "", "(Ljava/lang/String;)V", "getFingerprint", "()Ljava/lang/String;", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "wot-generic"})
public final class Identifier
implements Comparable<Identifier> {
    @NotNull
    private final String fingerprint;

    public Identifier(@NotNull String fingerprint) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        String string = fingerprint.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        this.fingerprint = string;
    }

    @NotNull
    public final String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public int compareTo(@NotNull Identifier other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.fingerprint.compareTo(other.fingerprint);
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return Intrinsics.areEqual(object != null ? object.toString() : null, this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.fingerprint.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string;
    }
}

