/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/wot/network/RevocationState;", "", "type", "Lorg/pgpainless/wot/network/RevocationState$Type;", "timestamp", "Ljava/util/Date;", "(Lorg/pgpainless/wot/network/RevocationState$Type;Ljava/util/Date;)V", "getTimestamp", "()Ljava/util/Date;", "getType", "()Lorg/pgpainless/wot/network/RevocationState$Type;", "isEffective", "", "referenceTime", "isHardRevocation", "isNotRevoked", "isSoftRevocation", "Companion", "Type", "wot-generic"})
public final class RevocationState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @Nullable
    private final Date timestamp;

    private RevocationState(Type type, Date timestamp) {
        this.type = type;
        this.timestamp = timestamp;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @Nullable
    public final Date getTimestamp() {
        return this.timestamp;
    }

    public final boolean isHardRevocation() {
        return this.type == Type.Hard;
    }

    public final boolean isSoftRevocation() {
        return this.type == Type.Soft;
    }

    public final boolean isNotRevoked() {
        return this.type == Type.None;
    }

    public final boolean isEffective(@NotNull Date referenceTime) {
        Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
        if (this.isHardRevocation()) {
            return true;
        }
        if (this.isSoftRevocation()) {
            if (referenceTime.after(this.timestamp)) {
                return true;
            }
            long l = referenceTime.getTime() / (long)1000;
            Date date = this.timestamp;
            Intrinsics.checkNotNull(date);
            return Math.abs(l - date.getTime() / (long)1000) == 0L;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final RevocationState notRevoked() {
        return Companion.notRevoked();
    }

    @JvmStatic
    @NotNull
    public static final RevocationState softRevoked(@NotNull Date timestamp) {
        return Companion.softRevoked(timestamp);
    }

    @JvmStatic
    @NotNull
    public static final RevocationState hardRevoked() {
        return Companion.hardRevoked();
    }

    public /* synthetic */ RevocationState(Type type, Date timestamp, DefaultConstructorMarker $constructor_marker) {
        this(type, timestamp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/wot/network/RevocationState$Companion;", "", "()V", "hardRevoked", "Lorg/pgpainless/wot/network/RevocationState;", "notRevoked", "softRevoked", "timestamp", "Ljava/util/Date;", "wot-generic"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RevocationState notRevoked() {
            return new RevocationState(Type.None, null, null);
        }

        @JvmStatic
        @NotNull
        public final RevocationState softRevoked(@NotNull Date timestamp) {
            Intrinsics.checkNotNullParameter(timestamp, "timestamp");
            return new RevocationState(Type.Soft, timestamp, null);
        }

        @JvmStatic
        @NotNull
        public final RevocationState hardRevoked() {
            return new RevocationState(Type.Hard, null, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/pgpainless/wot/network/RevocationState$Type;", "", "(Ljava/lang/String;I)V", "Soft", "Hard", "None", "wot-generic"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Soft = new Type();
        public static final /* enum */ Type Hard = new Type();
        public static final /* enum */ Type None = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Soft, Type.Hard, Type.None};
        }
    }
}

