/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0096\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/wot/network/TrustDepth;", "", "", "value", "(I)V", "getValue", "()I", "compareTo", "other", "isUnlimited", "", "min", "reduce", "trustDepth", "toString", "", "Companion", "wot-generic"})
public final class TrustDepth
implements Comparable<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;

    public final int getValue() {
        return this.value;
    }

    private TrustDepth(int value) {
        int n;
        if (value < 0) {
            throw new IllegalArgumentException("Trust Depth cannot be smaller than 0.");
        }
        if (value < 255) {
            n = value;
        } else if (value == 255) {
            n = 255;
        } else {
            throw new IllegalArgumentException("Trust Depth cannot be larger than 255.");
        }
        this.value = n;
    }

    public final boolean isUnlimited() {
        return this.value == 255;
    }

    @NotNull
    public final TrustDepth reduce(int trustDepth) {
        if (this.isUnlimited()) {
            return Companion.unlimited();
        }
        if (!(this.value - trustDepth >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Companion.limited(this.value - trustDepth);
    }

    @NotNull
    public final TrustDepth min(@NotNull TrustDepth other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Pair<Boolean, Boolean> pair = TuplesKt.to(this.isUnlimited(), other.isUnlimited());
        return Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true)) ? this : (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false)) ? other : (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true)) ? this : (this.compareTo(other.value) < 1 ? this : other)));
    }

    @Override
    public int compareTo(int other) {
        if (this.isUnlimited()) {
            return 1;
        }
        return Intrinsics.compare(this.value, other);
    }

    @NotNull
    public String toString() {
        if (this.isUnlimited()) {
            return "unconstrained";
        }
        return String.valueOf(this.value);
    }

    @JvmStatic
    @NotNull
    public static final TrustDepth unlimited() {
        return Companion.unlimited();
    }

    @JvmStatic
    @NotNull
    public static final TrustDepth limited(int value) {
        return Companion.limited(value);
    }

    @JvmStatic
    @NotNull
    public static final TrustDepth auto(int value) {
        return Companion.auto(value);
    }

    public /* synthetic */ TrustDepth(int value, DefaultConstructorMarker $constructor_marker) {
        this(value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/wot/network/TrustDepth$Companion;", "", "()V", "auto", "Lorg/pgpainless/wot/network/TrustDepth;", "value", "", "limited", "unlimited", "wot-generic"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TrustDepth unlimited() {
            return new TrustDepth(255, null);
        }

        @JvmStatic
        @NotNull
        public final TrustDepth limited(int value) {
            if (!(value >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(value < 255)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new TrustDepth(value, null);
        }

        @JvmStatic
        @NotNull
        public final TrustDepth auto(int value) {
            return new TrustDepth(value, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

