/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\fJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0015J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u000e\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u0004\u0012\u00020\f0\nj\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/pgpainless/wot/network/WotNetwork;", "", "network", "Lorg/pgpainless/wot/network/Network;", "certificationNetwork", "", "referenceTime", "Ljava/util/Date;", "(Lorg/pgpainless/wot/network/Network;ZLjava/util/Date;)V", "capCertificate", "Ljava/util/HashMap;", "Lorg/pgpainless/wot/network/Identifier;", "", "Lkotlin/collections/HashMap;", "suppressPath", "Lkotlin/Pair;", "", "fingerprint", "amount", "certificationsForSignee", "", "Lorg/pgpainless/wot/network/Edge$Component;", "fpr", "targetUserid", "", "curLen", "getEffectiveTrustAmount", "ec", "getSelfSig", "targetFpr", "isValidTarget", "Lorg/pgpainless/wot/network/Node;", "nodeByFpr", "path", "Lorg/pgpainless/wot/query/Path;", "amountToSuppress", "wot-dijkstra"})
@SourceDebugExtension(value={"SMAP\nWotNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WotNetwork.kt\norg/pgpainless/wot/network/WotNetwork\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n515#2:154\n500#2,6:155\n125#3:161\n152#3,3:162\n125#3:168\n152#3,3:169\n1549#4:165\n1620#4,2:166\n1622#4:172\n766#4:173\n857#4,2:174\n*S KotlinDebug\n*F\n+ 1 WotNetwork.kt\norg/pgpainless/wot/network/WotNetwork\n*L\n54#1:154\n54#1:155,6\n54#1:161\n54#1:162,3\n57#1:168\n57#1:169,3\n56#1:165\n56#1:166,2\n56#1:172\n60#1:173\n60#1:174,2\n*E\n"})
public final class WotNetwork {
    @NotNull
    private final Network network;
    private final boolean certificationNetwork;
    @NotNull
    private final Date referenceTime;
    @NotNull
    private final HashMap<Identifier, Integer> capCertificate;
    @NotNull
    private final HashMap<Pair<Identifier, Identifier>, Integer> suppressPath;

    public WotNetwork(@NotNull Network network, boolean certificationNetwork, @NotNull Date referenceTime) {
        Intrinsics.checkNotNullParameter(network, "network");
        Intrinsics.checkNotNullParameter(referenceTime, "referenceTime");
        this.network = network;
        this.certificationNetwork = certificationNetwork;
        this.referenceTime = referenceTime;
        this.capCertificate = new HashMap();
        this.suppressPath = new HashMap();
    }

    @Nullable
    public final Node nodeByFpr(@NotNull Identifier fpr) {
        Intrinsics.checkNotNullParameter(fpr, "fpr");
        return this.network.getNodes().get(fpr);
    }

    @Nullable
    public final Edge.Component getSelfSig(@NotNull Identifier targetFpr, @NotNull String targetUserid) {
        Intrinsics.checkNotNullParameter(targetFpr, "targetFpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        Node target = this.nodeByFpr(targetFpr);
        Object object = target;
        if ((object != null && (object = ((Node)object).getUserIds()) != null ? (RevocationState)object.get(targetUserid) : null) != null) {
            return new Edge.Certification(target, target, targetUserid, this.referenceTime, null, true, 120, TrustDepth.Companion.limited(0), null, 256, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Edge.Component> certificationsForSignee(@NotNull Identifier fpr, @NotNull String targetUserid, int curLen) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(fpr, "fpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        Map $this$filter$iv2 = this.network.getEdges();
        boolean $i$f$filter = false;
        Map map = $this$filter$iv2;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(((Pair)it.getKey()).getSecond(), fpr)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv2 = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            it = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((Edge)it.getValue());
        }
        List edges = (List)destination$iv$iv;
        Iterable $this$map$iv2 = edges;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            void edge;
            Edge bl = (Edge)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            Map<String, List<Edge.Component>> $this$map$iv3 = edge.components();
            boolean $i$f$map3 = false;
            Map<String, List<Edge.Component>> map2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo3 = false;
            Iterator iterator3 = $this$mapTo$iv$iv3.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it2;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = iterator3.next();
                Collection collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add((List)it2.getValue());
            }
            object.add(CollectionsKt.flatten((List)destination$iv$iv3));
        }
        $this$map$iv2 = CollectionsKt.flatten((List)destination$iv$iv2);
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Edge.Component it3 = (Edge.Component)element$iv$iv;
            boolean bl = false;
            boolean bl4 = !this.certificationNetwork ? it3.getTrustDepth().compareTo(curLen) >= 0 && it3.getRegexes().matches(targetUserid) : true;
            if (!bl4) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List ec = (List)destination$iv$iv2;
        return ec;
    }

    @Nullable
    public final Node isValidTarget(@NotNull Identifier targetFpr, @NotNull String targetUserid) {
        Intrinsics.checkNotNullParameter(targetFpr, "targetFpr");
        Intrinsics.checkNotNullParameter(targetUserid, "targetUserid");
        Node node = this.nodeByFpr(targetFpr);
        if (node == null) {
            return null;
        }
        Node target = node;
        if (target.getExpirationTime() != null) {
            Date date = target.getExpirationTime();
            Intrinsics.checkNotNull(date);
            if (date.compareTo(this.referenceTime) <= 0) {
                return null;
            }
        }
        if (target.getRevocationState().isEffective(this.referenceTime)) {
            return null;
        }
        RevocationState targetUa = target.getUserIds().get(targetUserid);
        if (targetUa != null && targetUa.isEffective(this.referenceTime)) {
            return null;
        }
        return target;
    }

    public final int getEffectiveTrustAmount(@NotNull Edge.Component ec) {
        int amount;
        block2: {
            Integer it;
            Intrinsics.checkNotNullParameter(ec, "ec");
            amount = 0;
            amount = ec.getTrustAmount();
            Integer n = this.capCertificate.get(ec.getIssuer().getFingerprint());
            if (n != null) {
                it = n;
                boolean bl = false;
                if (it < amount) {
                    amount = it;
                }
            }
            Integer n2 = this.suppressPath.get(new Pair<Identifier, Identifier>(ec.getIssuer().getFingerprint(), ec.getTarget().getFingerprint()));
            if (n2 == null) break block2;
            it = n2;
            boolean bl = false;
            amount = amount > it ? (amount -= it.intValue()) : 0;
        }
        return amount;
    }

    public final void capCertificate(@NotNull Identifier fingerprint, int amount) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        Integer n = amount;
        ((Map)this.capCertificate).put(fingerprint, n);
    }

    public final void suppressPath(@NotNull Path path, int amountToSuppress) {
        boolean bl;
        Intrinsics.checkNotNullParameter(path, "path");
        if (amountToSuppress == 0) {
            return;
        }
        boolean bl2 = bl = amountToSuppress <= 120;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (Edge.Component c : path.getCertifications()) {
            int curAmount;
            int newAmount;
            boolean bl3;
            Integer n = this.suppressPath.get(new Pair<Identifier, Identifier>(c.getIssuer().getFingerprint(), c.getTarget().getFingerprint()));
            if (n == null) {
                n = 0;
            }
            boolean bl4 = bl3 = (newAmount = (curAmount = ((Number)n).intValue()) + amountToSuppress) <= 120;
            if (_Assertions.ENABLED && !bl3) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Integer n2 = newAmount;
            ((Map)this.suppressPath).put(new Pair<Identifier, Identifier>(c.getIssuer().getFingerprint(), c.getTarget().getFingerprint()), n2);
        }
    }
}

