/*
 * Decompiled with CFR 0.152.
 */
package pgp.cert_d;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import pgp.cert_d.ReadOnlyPGPCertificateDirectory;
import pgp.cert_d.WritingPGPCertificateDirectory;
import pgp.cert_d.subkey_lookup.SubkeyLookup;
import pgp.certificate_store.certificate.Certificate;
import pgp.certificate_store.certificate.KeyMaterial;
import pgp.certificate_store.certificate.KeyMaterialMerger;
import pgp.certificate_store.exception.BadDataException;
import pgp.certificate_store.exception.BadNameException;

public class PGPCertificateDirectory
implements ReadOnlyPGPCertificateDirectory,
WritingPGPCertificateDirectory,
SubkeyLookup {
    final Backend backend;
    final SubkeyLookup subkeyLookup;
    private final Pattern openPgpV4FingerprintPattern = Pattern.compile("^[a-f0-9]{40}$");

    public PGPCertificateDirectory(Backend backend, SubkeyLookup subkeyLookup) {
        this.backend = backend;
        this.subkeyLookup = subkeyLookup;
    }

    @Override
    public Certificate getByFingerprint(String fingerprint) throws BadDataException, BadNameException, IOException {
        if (!this.openPgpV4FingerprintPattern.matcher(fingerprint).matches()) {
            throw new BadNameException();
        }
        Certificate certificate = this.backend.readByFingerprint(fingerprint);
        if (certificate == null) {
            throw new NoSuchElementException();
        }
        return certificate;
    }

    @Override
    public Certificate getByFingerprintIfChanged(String fingerprint, long tag) throws IOException, BadNameException, BadDataException {
        if (!Objects.equals(tag, this.backend.getTagForFingerprint(fingerprint))) {
            return this.getByFingerprint(fingerprint);
        }
        return null;
    }

    @Override
    public Certificate getBySpecialName(String specialName) throws BadNameException, BadDataException, IOException {
        KeyMaterial keyMaterial = this.backend.readBySpecialName(specialName);
        if (keyMaterial != null) {
            return keyMaterial.asCertificate();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Certificate getBySpecialNameIfChanged(String specialName, long tag) throws IOException, BadNameException, BadDataException {
        if (!Objects.equals(tag, this.backend.getTagForSpecialName(specialName))) {
            return this.getBySpecialName(specialName);
        }
        return null;
    }

    @Override
    public Certificate getTrustRootCertificate() throws IOException, BadDataException {
        try {
            return this.getBySpecialName("trust-root");
        }
        catch (BadNameException e) {
            throw new AssertionError((Object)"'trust-root' is an implementation MUST");
        }
    }

    @Override
    public Certificate getTrustRootCertificateIfChanged(long tag) throws IOException, BadDataException {
        try {
            return this.getBySpecialNameIfChanged("trust-root", tag);
        }
        catch (BadNameException e) {
            throw new AssertionError((Object)"'trust-root' is an implementation MUST");
        }
    }

    @Override
    public Iterator<Certificate> items() {
        return this.backend.readItems();
    }

    @Override
    public Iterator<String> fingerprints() {
        final Iterator<Certificate> certs = this.items();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return certs.hasNext();
            }

            @Override
            public String next() {
                return ((Certificate)certs.next()).getFingerprint();
            }
        };
    }

    @Override
    public KeyMaterial getTrustRoot() throws IOException, BadDataException {
        try {
            KeyMaterial keyMaterial = this.backend.readBySpecialName("trust-root");
            if (keyMaterial == null) {
                throw new NoSuchElementException();
            }
            return keyMaterial;
        }
        catch (BadNameException e) {
            throw new AssertionError((Object)"'trust-root' is implementation MUST");
        }
    }

    @Override
    public KeyMaterial insertTrustRoot(InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException, InterruptedException {
        this.backend.getLock().lockDirectory();
        KeyMaterial inserted = this.backend.doInsertTrustRoot(data, merge);
        this.subkeyLookup.storeCertificateSubkeyIds(inserted.getFingerprint(), inserted.getSubkeyIds());
        this.backend.getLock().releaseDirectory();
        return inserted;
    }

    @Override
    public KeyMaterial tryInsertTrustRoot(InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException {
        if (!this.backend.getLock().tryLockDirectory()) {
            return null;
        }
        KeyMaterial inserted = this.backend.doInsertTrustRoot(data, merge);
        this.subkeyLookup.storeCertificateSubkeyIds(inserted.getFingerprint(), inserted.getSubkeyIds());
        this.backend.getLock().releaseDirectory();
        return inserted;
    }

    @Override
    public Certificate insert(InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException, InterruptedException {
        this.backend.getLock().lockDirectory();
        Certificate inserted = this.backend.doInsert(data, merge);
        this.subkeyLookup.storeCertificateSubkeyIds(inserted.getFingerprint(), inserted.getSubkeyIds());
        this.backend.getLock().releaseDirectory();
        return inserted;
    }

    @Override
    public Certificate tryInsert(InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException {
        if (!this.backend.getLock().tryLockDirectory()) {
            return null;
        }
        Certificate inserted = this.backend.doInsert(data, merge);
        this.subkeyLookup.storeCertificateSubkeyIds(inserted.getFingerprint(), inserted.getSubkeyIds());
        this.backend.getLock().releaseDirectory();
        return inserted;
    }

    @Override
    public Certificate insertWithSpecialName(String specialName, InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException, BadNameException, InterruptedException {
        this.backend.getLock().lockDirectory();
        Certificate inserted = this.backend.doInsertWithSpecialName(specialName, data, merge);
        this.subkeyLookup.storeCertificateSubkeyIds(inserted.getFingerprint(), inserted.getSubkeyIds());
        this.backend.getLock().releaseDirectory();
        return inserted;
    }

    @Override
    public Certificate tryInsertWithSpecialName(String specialName, InputStream data, KeyMaterialMerger merge) throws IOException, BadDataException, BadNameException {
        if (!this.backend.getLock().tryLockDirectory()) {
            return null;
        }
        Certificate inserted = this.backend.doInsertWithSpecialName(specialName, data, merge);
        this.subkeyLookup.storeCertificateSubkeyIds(inserted.getFingerprint(), inserted.getSubkeyIds());
        this.backend.getLock().releaseDirectory();
        return inserted;
    }

    @Override
    public Set<String> getCertificateFingerprintsForSubkeyId(long subkeyId) throws IOException {
        return this.subkeyLookup.getCertificateFingerprintsForSubkeyId(subkeyId);
    }

    @Override
    public void storeCertificateSubkeyIds(String certificate, List<Long> subkeyIds) throws IOException {
        this.subkeyLookup.storeCertificateSubkeyIds(certificate, subkeyIds);
    }

    public static interface LockingMechanism {
        public void lockDirectory() throws IOException, InterruptedException;

        public boolean tryLockDirectory() throws IOException;

        public boolean isLocked();

        public void releaseDirectory() throws IOException;
    }

    public static interface Backend {
        public LockingMechanism getLock();

        public Certificate readByFingerprint(String var1) throws BadNameException, IOException, BadDataException;

        public KeyMaterial readBySpecialName(String var1) throws BadNameException, IOException, BadDataException;

        public Iterator<Certificate> readItems();

        public KeyMaterial doInsertTrustRoot(InputStream var1, KeyMaterialMerger var2) throws BadDataException, IOException;

        public Certificate doInsert(InputStream var1, KeyMaterialMerger var2) throws IOException, BadDataException;

        public Certificate doInsertWithSpecialName(String var1, InputStream var2, KeyMaterialMerger var3) throws IOException, BadDataException, BadNameException;

        public Long getTagForFingerprint(String var1) throws BadNameException, IOException;

        public Long getTagForSpecialName(String var1) throws BadNameException, IOException;
    }
}

