/*
 * Decompiled with CFR 0.152.
 */
package pgp.certificate_store.certificate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import pgp.certificate_store.certificate.KeyMaterial;

public class Certificate
implements KeyMaterial {
    private final byte[] bytes;
    private final String fingerprint;
    private final List<Long> subkeyIds;
    private final Long tag;

    public Certificate(byte[] bytes, String fingerprint, List<Long> subkeyIds, Long tag) {
        this.bytes = bytes;
        this.fingerprint = fingerprint;
        this.subkeyIds = subkeyIds;
        this.tag = tag;
    }

    public Certificate(Certificate cert, Long tag) {
        this(cert.bytes, cert.fingerprint, cert.subkeyIds, tag);
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public Certificate asCertificate() {
        return this;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Long getTag() {
        return this.tag;
    }

    @Override
    public List<Long> getSubkeyIds() {
        return this.subkeyIds;
    }
}

