/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.cli.format;

import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.pgpainless.wot.api.AuthenticateAPI;
import org.pgpainless.wot.api.Binding;
import org.pgpainless.wot.cli.format.Formatter;
import org.pgpainless.wot.cli.format.SQWOTFormatter;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Identifier;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.network.TrustDepth;
import org.pgpainless.wot.query.Path;
import org.pgpainless.wot.query.Paths;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pgpainless/wot/cli/format/SQWOTFormatterTest;", "", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "formatter", "Lorg/pgpainless/wot/cli/format/Formatter;", "nodeAlice", "Lorg/pgpainless/wot/network/Node;", "nodeBob", "nodeCharlie", "testFormattingOfAuthenticateResult", "", "pgpainless-wot-cli_test"})
public final class SQWOTFormatterTest {
    @NotNull
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @NotNull
    private final Formatter formatter = (Formatter)new SQWOTFormatter();
    @NotNull
    private final Node nodeAlice = new Node(new Identifier(StringsKt.repeat((CharSequence)"A", (int)40)), null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Alice <alice@pgpainless.org>", (Object)RevocationState.Companion.notRevoked())), 6, null);
    @NotNull
    private final Node nodeBob = new Node(new Identifier(StringsKt.repeat((CharSequence)"B", (int)40)), null, null, null, 14, null);
    @NotNull
    private final Node nodeCharlie = new Node(new Identifier(StringsKt.repeat((CharSequence)"C", (int)40)), null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Charlie <charlie@example.org>", (Object)RevocationState.Companion.notRevoked())), 6, null);

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testFormattingOfAuthenticateResult() {
        void $this$testFormattingOfAuthenticateResult_u24lambda_u240;
        Paths paths;
        int targetAmount = 120;
        Paths paths2 = paths = new Paths();
        String string = "Alice <alice@pgpainless.org>";
        Identifier identifier = this.nodeAlice.getFingerprint();
        boolean bl = false;
        Object[] objectArray = new Edge.Component[1];
        Date date = this.dateFormat.parse("2023-01-01");
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"dateFormat.parse(\"2023-01-01\")");
        objectArray[0] = new Edge.Certification(this.nodeBob, this.nodeAlice, "Alice <alice@pgpainless.org>", date, null, true, Integer.valueOf(120), TrustDepth.Companion.auto(0), null, 256, null);
        $this$testFormattingOfAuthenticateResult_u24lambda_u240.add(new Path(this.nodeBob, CollectionsKt.mutableListOf((Object[])objectArray), TrustDepth.Companion.auto(0)), 120);
        Unit unit = Unit.INSTANCE;
        Paths paths3 = paths;
        String string2 = string;
        Identifier identifier2 = identifier;
        Binding binding = new Binding(identifier2, string2, paths3);
        AuthenticateAPI.Result result = new AuthenticateAPI.Result(binding, targetAmount);
        String output = this.formatter.format(result);
        AssertionsKt.assertEquals$default((Object)((Object)StringsKt.trimStart((CharSequence)"\n[\u2713] AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA Alice <alice@pgpainless.org>: fully authenticated (100%)\n  \u25ef BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\n  \u2502   certified the following binding on 2023-01-01\n  \u2514 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA \"Alice <alice@pgpainless.org>\"\n")).toString(), (Object)output, null, (int)4, null);
    }
}

