/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot;

import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.wot.PGPNetworkParser;
import org.pgpainless.wot.api.WebOfTrustAPI;
import org.pgpainless.wot.dsl.PGPDSL;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.Node;
import org.pgpainless.wot.network.ReferenceTime;
import org.pgpainless.wot.network.RevocationState;
import org.pgpainless.wot.network.Root;
import org.pgpainless.wot.network.Roots;
import org.pgpainless.wot.testfixtures.AdHocVectors;
import pgp.certificate_store.PGPCertificateStore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/wot/AdHocTest;", "Lorg/pgpainless/wot/dsl/PGPDSL;", "()V", "test", "", "pgpainless-wot_test"})
@SourceDebugExtension(value={"SMAP\nAdHocTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdHocTest.kt\norg/pgpainless/wot/AdHocTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class AdHocTest
implements PGPDSL {
    @Test
    public final void test() {
        AdHocVectors.BestViaRoot vectors = new AdHocVectors.BestViaRoot();
        PGPCertificateStore store = vectors.getPgpCertificateStore();
        Network network = PGPNetworkParser.buildNetwork$default((PGPNetworkParser)new PGPNetworkParser(store), null, null, (int)3, null);
        WebOfTrustAPI api = new WebOfTrustAPI(network, new Roots(new Root(vectors.getAliceFingerprint())), false, false, 120, ReferenceTime.Companion.now());
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)api.authenticate(vectors.getTargetFingerprint(), vectors.getTargetUID(), false).getAcceptable(), string);
    }

    @NotNull
    public Fingerprint Fingerprint(@NotNull PGPPublicKeyRing certificate) {
        return PGPDSL.DefaultImpls.Fingerprint((PGPDSL)this, (PGPPublicKeyRing)certificate);
    }

    @NotNull
    public Fingerprint Fingerprint(@NotNull OpenPgpFingerprint pgpFingerprint) {
        return PGPDSL.DefaultImpls.Fingerprint((PGPDSL)this, (OpenPgpFingerprint)pgpFingerprint);
    }

    @NotNull
    public Node Node(@NotNull PGPPublicKeyRing certificate) {
        return PGPDSL.DefaultImpls.Node((PGPDSL)this, (PGPPublicKeyRing)certificate);
    }

    @NotNull
    public Node Node(@NotNull KeyRingInfo validatedCert) {
        return PGPDSL.DefaultImpls.Node((PGPDSL)this, (KeyRingInfo)validatedCert);
    }

    @NotNull
    public RevocationState RevocationState(@Nullable PGPSignature signature) {
        return PGPDSL.DefaultImpls.RevocationState((PGPDSL)this, (PGPSignature)signature);
    }

    @NotNull
    public RevocationState RevocationState(@NotNull org.pgpainless.algorithm.RevocationState pgpRevocationState) {
        return PGPDSL.DefaultImpls.RevocationState((PGPDSL)this, (org.pgpainless.algorithm.RevocationState)pgpRevocationState);
    }
}

