/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import kotlin.text.Charsets;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.authentication.CertificateAuthenticity;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.wot.CertificateAuthorityImpl;
import org.pgpainless.wot.KeyRingCertificateStore;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Root;
import org.pgpainless.wot.network.Roots;
import org.pgpainless.wot.testfixtures.AdHocVectors;
import pgp.certificate_store.PGPCertificateStore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0018H\u0007J\b\u0010\u001a\u001a\u00020\u0018H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/pgpainless/wot/CertificateAuthorityImplTest;", "", "()V", "certAuthority", "Lorg/pgpainless/wot/CertificateAuthorityImpl;", "getCertAuthority", "()Lorg/pgpainless/wot/CertificateAuthorityImpl;", "store", "Lorg/pgpainless/wot/KeyRingCertificateStore;", "getStore", "()Lorg/pgpainless/wot/KeyRingCertificateStore;", "trustRoots", "Lorg/pgpainless/wot/network/Roots;", "getTrustRoots", "()Lorg/pgpainless/wot/network/Roots;", "v", "Lorg/pgpainless/wot/testfixtures/AdHocVectors$BestViaRoot;", "getV", "()Lorg/pgpainless/wot/testfixtures/AdHocVectors$BestViaRoot;", "Fingerprint", "Lorg/pgpainless/wot/network/Fingerprint;", "publicKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "encryptToAuthenticatableRecipients", "", "testSuccessfulAuthentication", "testUnsuccessfulAuthentication", "pgpainless-wot_test"})
@SourceDebugExtension(value={"SMAP\nCertificateAuthorityImplTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateAuthorityImplTest.kt\norg/pgpainless/wot/CertificateAuthorityImplTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1#2:86\n1549#3:87\n1620#3,3:88\n*S KotlinDebug\n*F\n+ 1 CertificateAuthorityImplTest.kt\norg/pgpainless/wot/CertificateAuthorityImplTest\n*L\n41#1:87\n41#1:88,3\n*E\n"})
public final class CertificateAuthorityImplTest {
    @NotNull
    private final AdHocVectors.BestViaRoot v = new AdHocVectors.BestViaRoot();
    @NotNull
    private final KeyRingCertificateStore store = new KeyRingCertificateStore(this.v.getPublicKeyRingCollection());
    @NotNull
    private final Roots trustRoots = new Roots(new Root(this.v.getAliceFingerprint()));
    @NotNull
    private final CertificateAuthorityImpl certAuthority = CertificateAuthorityImpl.Companion.webOfTrustFromCertificateStore((PGPCertificateStore)this.store, this.trustRoots, new Date());

    @NotNull
    public final AdHocVectors.BestViaRoot getV() {
        return this.v;
    }

    @NotNull
    public final KeyRingCertificateStore getStore() {
        return this.store;
    }

    @NotNull
    public final Roots getTrustRoots() {
        return this.trustRoots;
    }

    @NotNull
    public final CertificateAuthorityImpl getCertAuthority() {
        return this.certAuthority;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testSuccessfulAuthentication() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CertificateAuthenticity authenticity = this.certAuthority.authenticateBinding((OpenPgpFingerprint)new OpenPgpV4Fingerprint(this.v.getTargetFingerprint().toString()), this.v.getTargetUID(), false, new Date(), 120);
        Object object = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)authenticity.isAuthenticated(), object);
        Fingerprint fingerprint = this.v.getTargetFingerprint();
        PGPPublicKeyRing pGPPublicKeyRing = authenticity.getCertificate();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"authenticity.certificate");
        AssertionsKt.assertEquals$default((Object)fingerprint, (Object)this.Fingerprint(pGPPublicKeyRing), null, (int)4, null);
        object = new Fingerprint[]{this.v.getAliceFingerprint(), this.v.getBobFingerprint(), this.v.getCarolFingerprint(), this.v.getTargetFingerprint()};
        List list = CollectionsKt.listOf((Object[])object);
        List list2 = ((CertificateAuthenticity.CertificationChain)CollectionsKt.first((Iterable)authenticity.getCertificationChains().keySet())).getChainLinks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"authenticity.certificati\u2026s.keys.first().chainLinks");
        object = list2;
        List list3 = list;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CertificateAuthenticity.ChainLink chainLink = (CertificateAuthenticity.ChainLink)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            PGPPublicKeyRing pGPPublicKeyRing2 = it.getCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing2, (String)"it.certificate");
            collection.add(this.Fingerprint(pGPPublicKeyRing2));
        }
        AssertionsKt.assertEquals$default((Object)list3, (Object)((List)destination$iv$iv), null, (int)4, null);
    }

    @Test
    public final void testUnsuccessfulAuthentication() {
        CertificateAuthenticity authenticity = this.certAuthority.authenticateBinding((OpenPgpFingerprint)new OpenPgpV4Fingerprint(this.v.getTargetFingerprint().toString()), "Imposter <imposter@example.org>", false, new Date(), 120);
        String string = null;
        boolean bl = false;
        AssertionsKt.assertFalse((boolean)authenticity.isAuthenticated(), string);
    }

    @Test
    public final void encryptToAuthenticatableRecipients() {
        String msg;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)output).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addAuthenticatableRecipients(this.v.getTargetUID(), false, (CertificateAuthority)this.certAuthority, 120)));
        String string = msg = "Hello, World!\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        encryptionStream.write(byArray);
        encryptionStream.close();
        EncryptionResult encResult = encryptionStream.getResult();
        String string2 = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)encResult.isEncryptedFor(this.v.getTargetCert()), string2);
        string2 = null;
        boolean bl2 = false;
        AssertionsKt.assertFalse((boolean)encResult.isEncryptedFor(this.v.getAliceCert()), string2);
        string2 = null;
        boolean bl3 = false;
        AssertionsKt.assertFalse((boolean)encResult.isEncryptedFor(this.v.getBobCert()), string2);
        string2 = null;
        boolean bl4 = false;
        AssertionsKt.assertFalse((boolean)encResult.isEncryptedFor(this.v.getCarolCert()), string2);
        string2 = null;
        boolean bl5 = false;
        AssertionsKt.assertFalse((boolean)encResult.isEncryptedFor(this.v.getYellowCert()), string2);
        string2 = null;
        boolean bl6 = false;
        AssertionsKt.assertFalse((boolean)encResult.isEncryptedFor(this.v.getZebraCert()), string2);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)input).withOptions(ConsumerOptions.get().addDecryptionKey(this.v.getTargetKey()));
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)((InputStream)decryptionStream), (OutputStream)plaintext);
        decryptionStream.close();
        String string3 = plaintext.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"plaintext.toString()");
        AssertionsKt.assertEquals$default((Object)msg, (Object)string3, null, (int)4, null);
    }

    @NotNull
    public final Fingerprint Fingerprint(@NotNull PGPPublicKeyRing publicKeyRing) {
        Intrinsics.checkNotNullParameter((Object)publicKeyRing, (String)"publicKeyRing");
        String string = OpenPgpFingerprint.of((PGPKeyRing)((PGPKeyRing)publicKeyRing)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"of(publicKeyRing).toString()");
        return new Fingerprint(string);
    }
}

