/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.wot.KeyRingCertificateStore;
import org.pgpainless.wot.PGPNetworkParser;
import org.pgpainless.wot.network.Edge;
import org.pgpainless.wot.network.Fingerprint;
import org.pgpainless.wot.network.Network;
import org.pgpainless.wot.network.ReferenceTime;
import org.pgpainless.wot.testfixtures.TestCertificateStores;
import org.pgpainless.wot.testfixtures.WotTestVectors;
import pgp.cert_d.PGPCertificateDirectory;
import pgp.certificate_store.PGPCertificateStore;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\nH\u0007J\b\u0010\u001b\u001a\u00020\nH\u0007J\b\u0010\u001c\u001a\u00020\nH\u0007J\b\u0010\u001d\u001a\u00020\nH\u0007J\b\u0010\u001e\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/wot/PGPNetworkParserTest;", "", "()V", "barBankCa", "Lorg/pgpainless/wot/network/Fingerprint;", "barBankEmployee", "fooBankAdmin", "fooBankCa", "fooBankEmployee", "assertHasEdge", "", "network", "Lorg/pgpainless/wot/network/Network;", "issuer", "target", "assertHasIssuerAndTarget", "certifications", "Lorg/pgpainless/wot/network/Edge;", "assertHasNoEdge", "assertHasNoReverseEdge", "assertHasReverseEdge", "fingerprintOf", "cert", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getEdgeFromTo", "getReverseEdgeFromTo", "referenceTime is propagated properly", "testWithCrossSignedCertificates", "testWithTwoNodesAndOneDelegation", "testWotCreationOfEmptyCertificates", "testWotWithAnomaly", "pgpainless-wot_test"})
@SourceDebugExtension(value={"SMAP\nPGPNetworkParserTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPNetworkParserTest.kt\norg/pgpainless/wot/PGPNetworkParserTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1726#2,3:138\n1#3:141\n*S KotlinDebug\n*F\n+ 1 PGPNetworkParserTest.kt\norg/pgpainless/wot/PGPNetworkParserTest\n*L\n49#1:138,3\n*E\n"})
public final class PGPNetworkParserTest {
    @NotNull
    private final Fingerprint fooBankCa = this.fingerprintOf(WotTestVectors.Companion.getFreshFooBankCaCert());
    @NotNull
    private final Fingerprint fooBankEmployee = this.fingerprintOf(WotTestVectors.Companion.getFreshFooBankEmployeeCert());
    @NotNull
    private final Fingerprint fooBankAdmin = this.fingerprintOf(WotTestVectors.Companion.getFreshFooBankAdminCert());
    @NotNull
    private final Fingerprint barBankCa = this.fingerprintOf(WotTestVectors.Companion.getFreshBarBankCaCert());
    @NotNull
    private final Fingerprint barBankEmployee = this.fingerprintOf(WotTestVectors.Companion.getFreshBarBankEmployeeCert());

    private final Fingerprint fingerprintOf(PGPPublicKeyRing cert) {
        String string = OpenPgpFingerprint.of((PGPKeyRing)((PGPKeyRing)cert)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"of(cert).toString()");
        return new Fingerprint(string);
    }

    @Test
    public final void testWithTwoNodesAndOneDelegation() {
        PGPCertificateDirectory certD = TestCertificateStores.oneDelegationGraph();
        Intrinsics.checkNotNullExpressionValue((Object)certD, (String)"certD");
        Network network = PGPNetworkParser.buildNetwork$default((PGPNetworkParser)new PGPNetworkParser(certD), null, null, (int)3, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)network.getNodes().size(), null, (int)4, null);
        this.assertHasEdge(network, this.fooBankAdmin, this.barBankCa);
        this.assertHasReverseEdge(network, this.fooBankAdmin, this.barBankCa);
        this.assertHasNoEdge(network, this.barBankCa, this.fooBankAdmin);
        this.assertHasNoReverseEdge(network, this.barBankCa, this.fooBankAdmin);
    }

    @Test
    public final void testWithCrossSignedCertificates() {
        boolean bl;
        String string;
        Network network;
        block3: {
            PGPCertificateDirectory certD = TestCertificateStores.disconnectedGraph();
            Intrinsics.checkNotNullExpressionValue((Object)certD, (String)"certD");
            network = PGPNetworkParser.buildNetwork$default((PGPNetworkParser)new PGPNetworkParser(certD), null, null, (int)3, null);
            AssertionsKt.assertEquals$default((Object)5, (Object)network.getNodes().size(), null, (int)4, null);
            string = null;
            boolean bl2 = false;
            Object[] objectArray = new Fingerprint[]{this.fooBankCa, this.fooBankEmployee, this.fooBankAdmin, this.barBankCa, this.barBankEmployee};
            Iterable $this$all$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Fingerprint it = (Fingerprint)element$iv;
                    boolean bl3 = false;
                    if (network.getNodes().containsKey(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        AssertionsKt.assertTrue((boolean)bl, string);
        Object v = network.getEdges().get(this.fooBankCa);
        Intrinsics.checkNotNull(v);
        List fooBankCaEdges = (List)v;
        AssertionsKt.assertEquals$default((Object)2, (Object)fooBankCaEdges.size(), null, (int)4, null);
        Edge fbc2fbe = this.getEdgeFromTo(network, this.fooBankCa, this.fooBankEmployee);
        AssertionsKt.assertNotNull$default((Object)fbc2fbe, null, (int)2, null);
        Edge fbc2fba = this.getEdgeFromTo(network, this.fooBankCa, this.fooBankAdmin);
        AssertionsKt.assertNotNull$default((Object)fbc2fba, null, (int)2, null);
        this.assertHasIssuerAndTarget(fbc2fbe, this.fooBankCa, this.fooBankEmployee);
        this.assertHasIssuerAndTarget(fbc2fba, this.fooBankCa, this.fooBankAdmin);
        this.assertHasEdge(network, this.barBankCa, this.barBankEmployee);
        this.assertHasReverseEdge(network, this.barBankCa, this.barBankEmployee);
        this.assertHasNoEdge(network, this.fooBankCa, this.barBankCa);
        this.assertHasNoReverseEdge(network, this.fooBankCa, this.barBankCa);
    }

    @Test
    public final void testWotCreationOfEmptyCertificates() {
        PGPCertificateDirectory certD = TestCertificateStores.emptyGraph();
        Intrinsics.checkNotNullExpressionValue((Object)certD, (String)"certD");
        Network network = PGPNetworkParser.buildNetwork$default((PGPNetworkParser)new PGPNetworkParser(certD), null, null, (int)3, null);
        String string = null;
        boolean bl = false;
        AssertionsKt.assertTrue((boolean)network.getNodes().isEmpty(), string);
        string = null;
        boolean bl2 = false;
        AssertionsKt.assertTrue((boolean)network.getEdges().isEmpty(), string);
        string = null;
        boolean bl3 = false;
        AssertionsKt.assertTrue((boolean)network.getReverseEdges().isEmpty(), string);
    }

    @Test
    public final void testWotWithAnomaly() {
        PGPCertificateDirectory store = TestCertificateStores.anomalyGraph();
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"store");
        Network network = PGPNetworkParser.buildNetwork$default((PGPNetworkParser)new PGPNetworkParser(store), null, null, (int)3, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)network.getNodes().size(), null, (int)4, null);
    }

    @Test
    public final void referenceTime is propagated properly() {
        ReferenceTime referenceTime = ReferenceTime.Companion.now();
        Network network = PGPNetworkParser.buildNetwork$default((PGPNetworkParser)new PGPNetworkParser((PGPCertificateStore)new KeyRingCertificateStore(CollectionsKt.emptyList())), null, (ReferenceTime)referenceTime, (int)1, null);
        AssertionsKt.assertEquals$default((Object)referenceTime, (Object)network.getReferenceTime(), null, (int)4, null);
    }

    private final void assertHasIssuerAndTarget(Edge certifications, Fingerprint issuer, Fingerprint target) {
        AssertionsKt.assertEquals$default((Object)issuer, (Object)certifications.getIssuer().getFingerprint(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)target, (Object)certifications.getTarget().getFingerprint(), null, (int)4, null);
    }

    private final void assertHasEdge(Network network, Fingerprint issuer, Fingerprint target) {
        AssertionsKt.assertNotNull((Object)this.getEdgeFromTo(network, issuer, target), (String)("Expected edge from " + issuer + " to " + target + " but got none."));
    }

    private final void assertHasReverseEdge(Network network, Fingerprint issuer, Fingerprint target) {
        AssertionsKt.assertNotNull((Object)this.getReverseEdgeFromTo(network, issuer, target), (String)("Expected reverse edge to " + target + " from " + issuer + " but got none."));
    }

    private final void assertHasNoEdge(Network network, Fingerprint issuer, Fingerprint target) {
        Edge edge = this.getEdgeFromTo(network, issuer, target);
        AssertionsKt.assertNull((Object)edge, (String)("Expected no edge from " + issuer + " to " + target + " but got " + edge));
    }

    private final void assertHasNoReverseEdge(Network network, Fingerprint issuer, Fingerprint target) {
        Edge reverseEdge = this.getReverseEdgeFromTo(network, issuer, target);
        AssertionsKt.assertNull((Object)reverseEdge, (String)("Expected no reverse edge on " + target + " from " + issuer + " but got " + reverseEdge));
    }

    private final Edge getEdgeFromTo(Network network, Fingerprint issuer, Fingerprint target) {
        Object v1;
        block2: {
            List list = (List)network.getEdges().get(issuer);
            if (list == null) {
                return null;
            }
            List edges = list;
            Iterable iterable = edges;
            for (Object t : iterable) {
                Edge it = (Edge)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)target, (Object)it.getTarget().getFingerprint())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private final Edge getReverseEdgeFromTo(Network network, Fingerprint issuer, Fingerprint target) {
        Object v1;
        block2: {
            List list = (List)network.getReverseEdges().get(target);
            if (list == null) {
                return null;
            }
            List revEdges = list;
            Iterable iterable = revEdges;
            for (Object t : iterable) {
                Edge it = (Edge)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)issuer, (Object)it.getIssuer().getFingerprint())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }
}

