/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.wot.testfixtures;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.Trustworthiness;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.subpackets.CertificationSubpackets;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/wot/testfixtures/WotTestVectors;", "", "()V", "Companion", "pgpainless-wot_testFixtures"})
public final class WotTestVectors {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final PGPSecretKeyRing freshFooBankCaKey;
    @NotNull
    private static final PGPPublicKeyRing freshFooBankCaCert;
    @NotNull
    private static final String fooBankCaPassphrase;
    @NotNull
    private static final SecretKeyRingProtector fooBankCaProtector;
    @NotNull
    private static final PGPSecretKeyRing freshFooBankEmployeeKey;
    @NotNull
    private static final PGPPublicKeyRing freshFooBankEmployeeCert;
    @NotNull
    private static final String fooBankEmployeePassphrase;
    @NotNull
    private static final SecretKeyRingProtector fooBankEmployeeProtector;
    @NotNull
    private static final PGPSecretKeyRing freshFooBankAdminKey;
    @NotNull
    private static final PGPPublicKeyRing freshFooBankAdminCert;
    @NotNull
    private static final String fooBankAdminPassphrase;
    @NotNull
    private static final SecretKeyRingProtector fooBankAdminProtector;
    @NotNull
    private static final PGPSecretKeyRing freshFooBankCustomerKey;
    @NotNull
    private static final PGPPublicKeyRing freshFooBankCustomerCert;
    @NotNull
    private static final SecretKeyRingProtector fooBankCustomerProtector;
    @NotNull
    private static final PGPSecretKeyRing freshBarBankCaKey;
    @NotNull
    private static final PGPPublicKeyRing freshBarBankCaCert;
    @NotNull
    private static final SecretKeyRingProtector barBankCaProtector;
    @NotNull
    private static final PGPSecretKeyRing freshBarBankEmployeeKey;
    @NotNull
    private static final PGPPublicKeyRing freshBarBankEmployeeCert;
    @NotNull
    private static final PGPSecretKeyRing freshFakeFooBankEmployeeKey;
    @NotNull
    private static final PGPPublicKeyRing freshFakeFooBankEmployeeCert;

    @JvmStatic
    @NotNull
    public static final InputStream getTestResource(@NotNull String resource) {
        return Companion.getTestResource(resource);
    }

    @NotNull
    public static final PGPSecretKeyRing getFreshFooBankCaKey() {
        return Companion.getFreshFooBankCaKey();
    }

    @NotNull
    public static final PGPPublicKeyRing getFreshFooBankCaCert() {
        return Companion.getFreshFooBankCaCert();
    }

    @NotNull
    public static final String getFooBankCaPassphrase() {
        return Companion.getFooBankCaPassphrase();
    }

    @NotNull
    public static final SecretKeyRingProtector getFooBankCaProtector() {
        return Companion.getFooBankCaProtector();
    }

    @NotNull
    public static final PGPSecretKeyRing getFreshFooBankEmployeeKey() {
        return Companion.getFreshFooBankEmployeeKey();
    }

    @NotNull
    public static final PGPPublicKeyRing getFreshFooBankEmployeeCert() {
        return Companion.getFreshFooBankEmployeeCert();
    }

    @NotNull
    public static final String getFooBankEmployeePassphrase() {
        return Companion.getFooBankEmployeePassphrase();
    }

    @NotNull
    public static final SecretKeyRingProtector getFooBankEmployeeProtector() {
        return Companion.getFooBankEmployeeProtector();
    }

    @NotNull
    public static final PGPSecretKeyRing getFreshFooBankAdminKey() {
        return Companion.getFreshFooBankAdminKey();
    }

    @NotNull
    public static final PGPPublicKeyRing getFreshFooBankAdminCert() {
        return Companion.getFreshFooBankAdminCert();
    }

    @NotNull
    public static final String getFooBankAdminPassphrase() {
        return Companion.getFooBankAdminPassphrase();
    }

    @NotNull
    public static final SecretKeyRingProtector getFooBankAdminProtector() {
        return Companion.getFooBankAdminProtector();
    }

    @NotNull
    public static final PGPSecretKeyRing getFreshFooBankCustomerKey() {
        return Companion.getFreshFooBankCustomerKey();
    }

    @NotNull
    public static final PGPPublicKeyRing getFreshFooBankCustomerCert() {
        return Companion.getFreshFooBankCustomerCert();
    }

    @NotNull
    public static final SecretKeyRingProtector getFooBankCustomerProtector() {
        return Companion.getFooBankCustomerProtector();
    }

    @NotNull
    public static final PGPSecretKeyRing getFreshBarBankCaKey() {
        return Companion.getFreshBarBankCaKey();
    }

    @NotNull
    public static final PGPPublicKeyRing getFreshBarBankCaCert() {
        return Companion.getFreshBarBankCaCert();
    }

    @NotNull
    public static final SecretKeyRingProtector getBarBankCaProtector() {
        return Companion.getBarBankCaProtector();
    }

    @NotNull
    public static final PGPSecretKeyRing getFreshBarBankEmployeeKey() {
        return Companion.getFreshBarBankEmployeeKey();
    }

    @NotNull
    public static final PGPPublicKeyRing getFreshBarBankEmployeeCert() {
        return Companion.getFreshBarBankEmployeeCert();
    }

    @NotNull
    public static final PGPSecretKeyRing getFreshFakeFooBankEmployeeKey() {
        return Companion.getFreshFakeFooBankEmployeeKey();
    }

    @NotNull
    public static final PGPPublicKeyRing getFreshFakeFooBankEmployeeCert() {
        return Companion.getFreshFakeFooBankEmployeeCert();
    }

    static {
        PGPSecretKeyRing pGPSecretKeyRing = PGPainless.readKeyRing().secretKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankCaKey.asc"));
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing);
        freshFooBankCaKey = pGPSecretKeyRing;
        PGPPublicKeyRing pGPPublicKeyRing = PGPainless.readKeyRing().publicKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankCaCert.asc"));
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing);
        freshFooBankCaCert = pGPPublicKeyRing;
        fooBankCaPassphrase = "superS3cureP4ssphrase";
        SecretKeyRingProtector secretKeyRingProtector = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((String)fooBankCaPassphrase));
        Intrinsics.checkNotNullExpressionValue((Object)secretKeyRingProtector, (String)"unlockAnyKeyWith(\n      \u2026ord(fooBankCaPassphrase))");
        fooBankCaProtector = secretKeyRingProtector;
        PGPSecretKeyRing pGPSecretKeyRing2 = PGPainless.readKeyRing().secretKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankEmployeeKey.asc"));
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing2);
        freshFooBankEmployeeKey = pGPSecretKeyRing2;
        PGPPublicKeyRing pGPPublicKeyRing2 = PGPainless.readKeyRing().publicKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankEmployeeCert.asc"));
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing2);
        freshFooBankEmployeeCert = pGPPublicKeyRing2;
        fooBankEmployeePassphrase = "iLoveWorking@FooBank";
        SecretKeyRingProtector secretKeyRingProtector2 = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((String)fooBankEmployeePassphrase));
        Intrinsics.checkNotNullExpressionValue((Object)secretKeyRingProtector2, (String)"unlockAnyKeyWith(\n      \u2026oBankEmployeePassphrase))");
        fooBankEmployeeProtector = secretKeyRingProtector2;
        PGPSecretKeyRing pGPSecretKeyRing3 = PGPainless.readKeyRing().secretKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankAdminKey.asc"));
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing3);
        freshFooBankAdminKey = pGPSecretKeyRing3;
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPainless.readKeyRing().publicKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankAdminCert.asc"));
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing3);
        freshFooBankAdminCert = pGPPublicKeyRing3;
        fooBankAdminPassphrase = "keepFooBankSecure";
        SecretKeyRingProtector secretKeyRingProtector3 = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((String)fooBankAdminPassphrase));
        Intrinsics.checkNotNullExpressionValue((Object)secretKeyRingProtector3, (String)"unlockAnyKeyWith(\n      \u2026(fooBankAdminPassphrase))");
        fooBankAdminProtector = secretKeyRingProtector3;
        PGPSecretKeyRing pGPSecretKeyRing4 = PGPainless.readKeyRing().secretKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankCustomerKey.asc"));
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing4);
        freshFooBankCustomerKey = pGPSecretKeyRing4;
        PGPPublicKeyRing pGPPublicKeyRing4 = PGPainless.readKeyRing().publicKeyRing(Companion.getTestResource("test_vectors/freshly_generated/foobankCustomerCert.asc"));
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing4);
        freshFooBankCustomerCert = pGPPublicKeyRing4;
        SecretKeyRingProtector secretKeyRingProtector4 = SecretKeyRingProtector.unprotectedKeys();
        Intrinsics.checkNotNullExpressionValue((Object)secretKeyRingProtector4, (String)"unprotectedKeys()");
        fooBankCustomerProtector = secretKeyRingProtector4;
        PGPSecretKeyRing pGPSecretKeyRing5 = PGPainless.readKeyRing().secretKeyRing(Companion.getTestResource("test_vectors/freshly_generated/barbankCaKey.asc"));
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing5);
        freshBarBankCaKey = pGPSecretKeyRing5;
        PGPPublicKeyRing pGPPublicKeyRing5 = PGPainless.readKeyRing().publicKeyRing(Companion.getTestResource("test_vectors/freshly_generated/barbankCaCert.asc"));
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing5);
        freshBarBankCaCert = pGPPublicKeyRing5;
        SecretKeyRingProtector secretKeyRingProtector5 = SecretKeyRingProtector.unprotectedKeys();
        Intrinsics.checkNotNullExpressionValue((Object)secretKeyRingProtector5, (String)"unprotectedKeys()");
        barBankCaProtector = secretKeyRingProtector5;
        PGPSecretKeyRing pGPSecretKeyRing6 = PGPainless.readKeyRing().secretKeyRing(Companion.getTestResource("test_vectors/freshly_generated/barbankEmployeeKey.asc"));
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing6);
        freshBarBankEmployeeKey = pGPSecretKeyRing6;
        PGPPublicKeyRing pGPPublicKeyRing6 = PGPainless.readKeyRing().publicKeyRing(Companion.getTestResource("test_vectors/freshly_generated/barbankEmployeeCert.asc"));
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing6);
        freshBarBankEmployeeCert = pGPPublicKeyRing6;
        PGPSecretKeyRing pGPSecretKeyRing7 = PGPainless.readKeyRing().secretKeyRing(Companion.getTestResource("test_vectors/freshly_generated/fakeFoobankEmployeeKey.asc"));
        Intrinsics.checkNotNull((Object)pGPSecretKeyRing7);
        freshFakeFooBankEmployeeKey = pGPSecretKeyRing7;
        PGPPublicKeyRing pGPPublicKeyRing7 = PGPainless.readKeyRing().publicKeyRing(Companion.getTestResource("test_vectors/freshly_generated/fakeFoobankEmployeeCert.asc"));
        Intrinsics.checkNotNull((Object)pGPPublicKeyRing7);
        freshFakeFooBankEmployeeCert = pGPPublicKeyRing7;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u0004\u0018\u00010 J\b\u0010P\u001a\u0004\u0018\u00010 J\b\u0010Q\u001a\u0004\u0018\u00010 J\b\u0010R\u001a\u0004\u0018\u00010 J\b\u0010S\u001a\u0004\u0018\u00010 J\u0010\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\tH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0007R\u001c\u0010\u0010\u001a\u00020\t8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\fR\u001c\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0007R\u001c\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0007R\u001c\u0010\u0019\u001a\u00020\t8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\fR\u001c\u0010\u001c\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\u0007R\u001c\u0010\u001f\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010(R\u001c\u0010)\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0002\u001a\u0004\b+\u0010#R\u001c\u0010,\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010\u0002\u001a\u0004\b.\u0010(R\u001c\u0010/\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0002\u001a\u0004\b1\u0010#R\u001c\u00102\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u0002\u001a\u0004\b4\u0010(R\u001c\u00105\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u0010\u0002\u001a\u0004\b7\u0010#R\u001c\u00108\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010\u0002\u001a\u0004\b:\u0010(R\u001c\u0010;\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b<\u0010\u0002\u001a\u0004\b=\u0010#R\u001c\u0010>\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b?\u0010\u0002\u001a\u0004\b@\u0010(R\u001c\u0010A\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bB\u0010\u0002\u001a\u0004\bC\u0010#R\u001c\u0010D\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bE\u0010\u0002\u001a\u0004\bF\u0010(R\u001c\u0010G\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bH\u0010\u0002\u001a\u0004\bI\u0010#R\u001c\u0010J\u001a\u00020%8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bK\u0010\u0002\u001a\u0004\bL\u0010(\u00a8\u0006W"}, d2={"Lorg/pgpainless/wot/testfixtures/WotTestVectors$Companion;", "", "()V", "barBankCaProtector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "getBarBankCaProtector$annotations", "getBarBankCaProtector", "()Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "fooBankAdminPassphrase", "", "getFooBankAdminPassphrase$annotations", "getFooBankAdminPassphrase", "()Ljava/lang/String;", "fooBankAdminProtector", "getFooBankAdminProtector$annotations", "getFooBankAdminProtector", "fooBankCaPassphrase", "getFooBankCaPassphrase$annotations", "getFooBankCaPassphrase", "fooBankCaProtector", "getFooBankCaProtector$annotations", "getFooBankCaProtector", "fooBankCustomerProtector", "getFooBankCustomerProtector$annotations", "getFooBankCustomerProtector", "fooBankEmployeePassphrase", "getFooBankEmployeePassphrase$annotations", "getFooBankEmployeePassphrase", "fooBankEmployeeProtector", "getFooBankEmployeeProtector$annotations", "getFooBankEmployeeProtector", "freshBarBankCaCert", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getFreshBarBankCaCert$annotations", "getFreshBarBankCaCert", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "freshBarBankCaKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "getFreshBarBankCaKey$annotations", "getFreshBarBankCaKey", "()Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "freshBarBankEmployeeCert", "getFreshBarBankEmployeeCert$annotations", "getFreshBarBankEmployeeCert", "freshBarBankEmployeeKey", "getFreshBarBankEmployeeKey$annotations", "getFreshBarBankEmployeeKey", "freshFakeFooBankEmployeeCert", "getFreshFakeFooBankEmployeeCert$annotations", "getFreshFakeFooBankEmployeeCert", "freshFakeFooBankEmployeeKey", "getFreshFakeFooBankEmployeeKey$annotations", "getFreshFakeFooBankEmployeeKey", "freshFooBankAdminCert", "getFreshFooBankAdminCert$annotations", "getFreshFooBankAdminCert", "freshFooBankAdminKey", "getFreshFooBankAdminKey$annotations", "getFreshFooBankAdminKey", "freshFooBankCaCert", "getFreshFooBankCaCert$annotations", "getFreshFooBankCaCert", "freshFooBankCaKey", "getFreshFooBankCaKey$annotations", "getFreshFooBankCaKey", "freshFooBankCustomerCert", "getFreshFooBankCustomerCert$annotations", "getFreshFooBankCustomerCert", "freshFooBankCustomerKey", "getFreshFooBankCustomerKey$annotations", "getFreshFooBankCustomerKey", "freshFooBankEmployeeCert", "getFreshFooBankEmployeeCert$annotations", "getFreshFooBankEmployeeCert", "freshFooBankEmployeeKey", "getFreshFooBankEmployeeKey$annotations", "getFreshFooBankEmployeeKey", "crossSign", "", "getCrossSignedBarBankCaCert", "getCrossSignedBarBankEmployeeCert", "getCrossSignedFooBankAdminCert", "getCrossSignedFooBankCaCert", "getCrossSignedFooBankEmployeeCert", "getTestResource", "Ljava/io/InputStream;", "resource", "pgpainless-wot_testFixtures"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final InputStream getTestResource(@NotNull String resource) {
            InputStream input;
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            InputStream inputStream = input = WotTestVectors.class.getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) {
                boolean bl = false;
                String string = "Unknown resource " + resource;
                throw new IllegalArgumentException(string.toString());
            }
            return inputStream;
        }

        @NotNull
        public final PGPSecretKeyRing getFreshFooBankCaKey() {
            return freshFooBankCaKey;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankCaKey$annotations() {
        }

        @NotNull
        public final PGPPublicKeyRing getFreshFooBankCaCert() {
            return freshFooBankCaCert;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankCaCert$annotations() {
        }

        @NotNull
        public final String getFooBankCaPassphrase() {
            return fooBankCaPassphrase;
        }

        @JvmStatic
        public static /* synthetic */ void getFooBankCaPassphrase$annotations() {
        }

        @NotNull
        public final SecretKeyRingProtector getFooBankCaProtector() {
            return fooBankCaProtector;
        }

        @JvmStatic
        public static /* synthetic */ void getFooBankCaProtector$annotations() {
        }

        @NotNull
        public final PGPSecretKeyRing getFreshFooBankEmployeeKey() {
            return freshFooBankEmployeeKey;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankEmployeeKey$annotations() {
        }

        @NotNull
        public final PGPPublicKeyRing getFreshFooBankEmployeeCert() {
            return freshFooBankEmployeeCert;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankEmployeeCert$annotations() {
        }

        @NotNull
        public final String getFooBankEmployeePassphrase() {
            return fooBankEmployeePassphrase;
        }

        @JvmStatic
        public static /* synthetic */ void getFooBankEmployeePassphrase$annotations() {
        }

        @NotNull
        public final SecretKeyRingProtector getFooBankEmployeeProtector() {
            return fooBankEmployeeProtector;
        }

        @JvmStatic
        public static /* synthetic */ void getFooBankEmployeeProtector$annotations() {
        }

        @NotNull
        public final PGPSecretKeyRing getFreshFooBankAdminKey() {
            return freshFooBankAdminKey;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankAdminKey$annotations() {
        }

        @NotNull
        public final PGPPublicKeyRing getFreshFooBankAdminCert() {
            return freshFooBankAdminCert;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankAdminCert$annotations() {
        }

        @NotNull
        public final String getFooBankAdminPassphrase() {
            return fooBankAdminPassphrase;
        }

        @JvmStatic
        public static /* synthetic */ void getFooBankAdminPassphrase$annotations() {
        }

        @NotNull
        public final SecretKeyRingProtector getFooBankAdminProtector() {
            return fooBankAdminProtector;
        }

        @JvmStatic
        public static /* synthetic */ void getFooBankAdminProtector$annotations() {
        }

        @NotNull
        public final PGPSecretKeyRing getFreshFooBankCustomerKey() {
            return freshFooBankCustomerKey;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankCustomerKey$annotations() {
        }

        @NotNull
        public final PGPPublicKeyRing getFreshFooBankCustomerCert() {
            return freshFooBankCustomerCert;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFooBankCustomerCert$annotations() {
        }

        @NotNull
        public final SecretKeyRingProtector getFooBankCustomerProtector() {
            return fooBankCustomerProtector;
        }

        @JvmStatic
        public static /* synthetic */ void getFooBankCustomerProtector$annotations() {
        }

        @NotNull
        public final PGPSecretKeyRing getFreshBarBankCaKey() {
            return freshBarBankCaKey;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshBarBankCaKey$annotations() {
        }

        @NotNull
        public final PGPPublicKeyRing getFreshBarBankCaCert() {
            return freshBarBankCaCert;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshBarBankCaCert$annotations() {
        }

        @NotNull
        public final SecretKeyRingProtector getBarBankCaProtector() {
            return barBankCaProtector;
        }

        @JvmStatic
        public static /* synthetic */ void getBarBankCaProtector$annotations() {
        }

        @NotNull
        public final PGPSecretKeyRing getFreshBarBankEmployeeKey() {
            return freshBarBankEmployeeKey;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshBarBankEmployeeKey$annotations() {
        }

        @NotNull
        public final PGPPublicKeyRing getFreshBarBankEmployeeCert() {
            return freshBarBankEmployeeCert;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshBarBankEmployeeCert$annotations() {
        }

        @NotNull
        public final PGPSecretKeyRing getFreshFakeFooBankEmployeeKey() {
            return freshFakeFooBankEmployeeKey;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFakeFooBankEmployeeKey$annotations() {
        }

        @NotNull
        public final PGPPublicKeyRing getFreshFakeFooBankEmployeeCert() {
            return freshFakeFooBankEmployeeCert;
        }

        @JvmStatic
        public static /* synthetic */ void getFreshFakeFooBankEmployeeCert$annotations() {
        }

        @Nullable
        public final PGPPublicKeyRing getCrossSignedBarBankCaCert() throws IOException {
            return PGPainless.readKeyRing().publicKeyRing(this.getTestResource("cross_signed/barbankCaCert.asc"));
        }

        @Nullable
        public final PGPPublicKeyRing getCrossSignedBarBankEmployeeCert() throws IOException {
            return PGPainless.readKeyRing().publicKeyRing(this.getTestResource("cross_signed/barbankEmployeeCert.asc"));
        }

        @Nullable
        public final PGPPublicKeyRing getCrossSignedFooBankAdminCert() throws IOException {
            return PGPainless.readKeyRing().publicKeyRing(this.getTestResource("cross_signed/foobankAdminCert.asc"));
        }

        @Nullable
        public final PGPPublicKeyRing getCrossSignedFooBankCaCert() throws IOException {
            return PGPainless.readKeyRing().publicKeyRing(this.getTestResource("cross_signed/foobankCaCert.asc"));
        }

        @Nullable
        public final PGPPublicKeyRing getCrossSignedFooBankEmployeeCert() throws IOException {
            return PGPainless.readKeyRing().publicKeyRing(this.getTestResource("cross_signed/foobankEmployeeCert.asc"));
        }

        public final void crossSign() throws IOException, PGPException {
            String fooBankRegex = "<[^>]+[@.]foobank\\.com>$";
            String barBankRegex = "<[^>]+[@.]barbank\\.com>$";
            PGPPublicKeyRing pGPPublicKeyRing = PGPainless.certify().userIdOnCertificate("Foo Bank Employee <employee@foobank.com>", this.getFreshFooBankEmployeeCert()).withKey(this.getFreshFooBankCaKey(), this.getFooBankCaProtector()).buildWithSubpackets(new CertificationSubpackets.Callback(){

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.addNotationData(false, "affiliation@foobank.com", "employee");
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"certify()\n              \u2026    .certifiedCertificate");
            PGPPublicKeyRing caCertifiedFooBankEmployeeCert2 = pGPPublicKeyRing;
            PGPPublicKeyRing pGPPublicKeyRing2 = PGPainless.certify().userIdOnCertificate("Foo Bank Admin <admin@foobank.com>", this.getFreshFooBankAdminCert()).withKey(this.getFreshFooBankCaKey(), this.getFooBankCaProtector()).buildWithSubpackets(new CertificationSubpackets.Callback(){

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.addNotationData(false, "affiliation@foobank.com", "administrator");
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing2, (String)"certify()\n              \u2026    .certifiedCertificate");
            PGPPublicKeyRing caCertifiedFooBankAdminCert2 = pGPPublicKeyRing2;
            PGPPublicKeyRing pGPPublicKeyRing3 = PGPainless.certify().certificate(this.getFreshFooBankCaCert(), Trustworthiness.fullyTrusted().introducer()).withKey(this.getFreshFooBankEmployeeKey(), this.getFooBankEmployeeProtector()).buildWithSubpackets(new CertificationSubpackets.Callback(fooBankRegex){
                final /* synthetic */ String $fooBankRegex;
                {
                    this.$fooBankRegex = $fooBankRegex;
                }

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.setRegularExpression(this.$fooBankRegex);
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing3, (String)"fooBankRegex = \"<[^>]+[@\u2026    .certifiedCertificate");
            PGPPublicKeyRing employeeDelegatedCaCert2 = pGPPublicKeyRing3;
            PGPPublicKeyRing pGPPublicKeyRing4 = PGPainless.certify().certificate(this.getFreshFooBankCaCert(), Trustworthiness.fullyTrusted().introducer()).withKey(this.getFreshFooBankAdminKey(), this.getFooBankAdminProtector()).buildWithSubpackets(new CertificationSubpackets.Callback(fooBankRegex){
                final /* synthetic */ String $fooBankRegex;
                {
                    this.$fooBankRegex = $fooBankRegex;
                }

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.setRegularExpression(this.$fooBankRegex);
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing4, (String)"fooBankRegex = \"<[^>]+[@\u2026    .certifiedCertificate");
            PGPPublicKeyRing adminDelegatedCaCert2 = pGPPublicKeyRing4;
            PGPPublicKeyRing pGPPublicKeyRing5 = PGPainless.certify().certificate(this.getFreshFooBankCaCert(), Trustworthiness.fullyTrusted().introducer()).withKey(this.getFreshFooBankCustomerKey(), SecretKeyRingProtector.unprotectedKeys()).buildWithSubpackets(new CertificationSubpackets.Callback(fooBankRegex){
                final /* synthetic */ String $fooBankRegex;
                {
                    this.$fooBankRegex = $fooBankRegex;
                }

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.setRegularExpression(this.$fooBankRegex);
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing5, (String)"fooBankRegex = \"<[^>]+[@\u2026    .certifiedCertificate");
            PGPPublicKeyRing customerDelegatedCaCert2 = pGPPublicKeyRing5;
            PGPPublicKeyRing mergedFooCa = PGPPublicKeyRing.join((PGPPublicKeyRing)employeeDelegatedCaCert2, (PGPPublicKeyRing)adminDelegatedCaCert2);
            mergedFooCa = PGPPublicKeyRing.join((PGPPublicKeyRing)mergedFooCa, (PGPPublicKeyRing)customerDelegatedCaCert2);
            PGPPublicKeyRing pGPPublicKeyRing6 = PGPainless.certify().certificate(this.getFreshBarBankCaCert(), Trustworthiness.fullyTrusted().introducer()).withKey(this.getFreshFooBankAdminKey(), this.getFooBankAdminProtector()).buildWithSubpackets(new CertificationSubpackets.Callback(){

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.setRegularExpression("<[^>]+[@.]barbank\\.com>$");
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing6, (String)"certify()\n              \u2026  }).certifiedCertificate");
            PGPPublicKeyRing fooAdminDelegatedBarCa2 = pGPPublicKeyRing6;
            PGPPublicKeyRing pGPPublicKeyRing7 = PGPainless.certify().certificate(this.getFreshBarBankCaCert(), Trustworthiness.fullyTrusted().introducer()).withKey(this.getFreshBarBankEmployeeKey(), SecretKeyRingProtector.unprotectedKeys()).buildWithSubpackets(new CertificationSubpackets.Callback(barBankRegex){
                final /* synthetic */ String $barBankRegex;
                {
                    this.$barBankRegex = $barBankRegex;
                }

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.setRegularExpression(this.$barBankRegex);
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing7, (String)"barBankRegex = \"<[^>]+[@\u2026    .certifiedCertificate");
            PGPPublicKeyRing barEmployeeDelegatesBarCa2 = pGPPublicKeyRing7;
            PGPPublicKeyRing mergedBarCa = PGPPublicKeyRing.join((PGPPublicKeyRing)fooAdminDelegatedBarCa2, (PGPPublicKeyRing)barEmployeeDelegatesBarCa2);
            PGPPublicKeyRing pGPPublicKeyRing8 = PGPainless.certify().userIdOnCertificate("Bar Bank Employee <employee@barbank.com>", this.getFreshBarBankEmployeeCert()).withKey(this.getFreshBarBankCaKey(), SecretKeyRingProtector.unprotectedKeys()).buildWithSubpackets(new CertificationSubpackets.Callback(){

                public void modifyHashedSubpackets(@NotNull CertificationSubpackets hashedSubpackets) {
                    Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
                    hashedSubpackets.addNotationData(false, "affiliation@barbank.com", "employee");
                }
            }).getCertifiedCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing8, (String)"certify()\n              \u2026    .certifiedCertificate");
            PGPPublicKeyRing barCaCertifiedEmployeeCert2 = pGPPublicKeyRing8;
            System.out.println((Object)"Foo Employee");
            System.out.println((Object)PGPainless.asciiArmor((PGPKeyRing)((PGPKeyRing)caCertifiedFooBankEmployeeCert2)));
            System.out.println((Object)"Foo Admin");
            System.out.println((Object)PGPainless.asciiArmor((PGPKeyRing)((PGPKeyRing)caCertifiedFooBankAdminCert2)));
            System.out.println((Object)"Foo CA");
            System.out.println((Object)PGPainless.asciiArmor((PGPKeyRing)((PGPKeyRing)mergedFooCa)));
            System.out.println((Object)"Bar CA");
            System.out.println((Object)PGPainless.asciiArmor((PGPKeyRing)((PGPKeyRing)mergedBarCa)));
            System.out.println((Object)"Bar Employee");
            System.out.println((Object)PGPainless.asciiArmor((PGPKeyRing)((PGPKeyRing)barCaCertifiedEmployeeCert2)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

